/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class DisableClangTidyIntentionAction
extends SuppressIntentionAction
implements Iconable {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, it -> {
            InspectionToolWrapper wrapper = it.getInspectionTool(ClangTidyInspection.getInspectionShortName(), project);
            if (wrapper != null) {
                ClangTidyInspection inspection = (ClangTidyInspection)wrapper.getTool();
                inspection.setClangTidyChecks(this.modifyConfiguration(inspection.getClangTidyChecks()));
            }
        });
    }

    @NotNull
    protected abstract String modifyConfiguration(@NotNull String var1);

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project);
        InspectionProfileImpl currentProfile = profileManager.getCurrentProfile();
        InspectionToolWrapper toolWrapper = currentProfile.getInspectionTool(ClangTidyInspection.getInspectionShortName(), project);
        return toolWrapper != null;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public abstract String getText();

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }
}

