/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.google.gson.stream.JsonWriter;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class CommonClangTidyUtil {
    @NlsSafe
    public static final String TOOL_NAME = "Clang-Tidy";
    public static final Pattern CLANG_TIDY_VERSION_PATTERN = Pattern.compile("^.*?([\\d]+\\.[\\d]+\\.?[\\d]*).*", 32);
    @NlsSafe
    public static final String CLANG_TIDY_BASE_WEB_PAGE = "https://clang.llvm.org/extra/clang-tidy";
    @NlsSafe
    public static final String CLANG_TIDY_HOW_TO_USE_WEB_PAGE = "https://clang.llvm.org/extra/clang-tidy/#using-clang-tidy";
    @NlsSafe
    public static final String CLANG_TIDY_CHECKS_WEB_PAGE = "https://clang.llvm.org/extra/clang-tidy/checks";
    private static final HashSet<@NlsSafe String> clangAnalyzerChecksWithDocumentation = ContainerUtil.newHashSet((Object[])new String[]{"clang-analyzer-core.DynamicTypePropagation", "clang-analyzer-core.uninitialized.CapturedBlockVariable", "clang-analyzer-cplusplus.InnerPointer", "clang-analyzer-nullability.NullableReturnedFromNonnull", "clang-analyzer-optin.osx.OSObjectCStyleCast", "clang-analyzer-optin.performance.GCDAntipattern", "clang-analyzer-optin.performance.Padding", "clang-analyzer-optin.portability.UnixAPI", "clang-analyzer-osx.MIG", "clang-analyzer-osx.NumberObjectConversion", "clang-analyzer-osx.OSObjectRetainCount", "clang-analyzer-osx.ObjCProperty", "clang-analyzer-osx.cocoa.AutoreleaseWrite", "clang-analyzer-osx.cocoa.Loops", "clang-analyzer-osx.cocoa.MissingSuperCall", "clang-analyzer-osx.cocoa.NonNilReturnValue", "clang-analyzer-osx.cocoa.RunLoopAutoreleaseLeak", "clang-analyzer-valist.CopyToSelf", "clang-analyzer-valist.Uninitialized", "clang-analyzer-valist.Unterminated"});
    private static final ImmutableList<FileExtensionPair> defaultFileExtensions = ContainerUtil.immutableList((List)new ArrayList<FileExtensionPair>(3){
        {
            if (PluginUtils.hasAppCode()) {
                this.add(new FileExtensionPair("mm", "h", NamingConventionStyle.NONE));
            }
            ContainerUtil.addAll((Collection)this, (Object[])new FileExtensionPair[]{new FileExtensionPair("cpp", "h", NamingConventionStyle.NONE), new FileExtensionPair("c", "h", NamingConventionStyle.NONE)});
            if (PluginUtils.hasCLion()) {
                this.add(new FileExtensionPair("cu", "cuh", NamingConventionStyle.NONE));
            }
        }
    });

    @NotNull
    public static ImmutableList<FileExtensionPair> getDefaultFileExtensions() {
        return defaultFileExtensions;
    }

    @Nullable
    public static File getCustomClangTidyPath() {
        return (File)ApplicationManager.getApplication().runReadAction(() -> {
            ClangTidySettings settings = ClangTidySettings.getInstance();
            return settings != null && settings.getUseExternalClangTidy() && settings.getExternalClangTidyPath() != null ? new File(settings.getExternalClangTidyPath()) : null;
        });
    }

    @NotNull
    public static String generateVfsOverlay(@NotNull OverlayMapping mapping, @NotNull ClangUrlConverter converter) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<Map<String, Object[]>> roots = new ArrayList<Map<String, Object[]>>();
        for (File overlayFile : mapping.getOverlayFiles()) {
            File sourceFile = mapping.getSourceFile(overlayFile);
            if (sourceFile == null) continue;
            File parentDirectory = FileUtil.getParentFile((File)sourceFile);
            Map<String, String> contents = Map.of("name", sourceFile.getName(), "type", "file", "external-contents", converter.fixWslPathWhenRequired(overlayFile.getAbsolutePath()));
            roots.add(Map.of("name", parentDirectory != null ? converter.fixWslPathWhenRequired(parentDirectory.getAbsolutePath()) : "", "type", "directory", "contents", new Object[]{contents}));
        }
        data.put("version", "0");
        data.put("roots", roots.toArray());
        Yaml yaml = new Yaml();
        return yaml.dump(data);
    }

    public static void writeCompilationDatabase(@NotNull Writer outputWriter, @NotNull String compilerExecutable, @NotNull String compilerWorkingDirectory, @NotNull List<String> compilerOptions, @NotNull String inputFile) throws IOException {
        try (JsonWriter jsonWriter = new JsonWriter(outputWriter);){
            jsonWriter.beginArray();
            jsonWriter.beginObject();
            jsonWriter.name("directory");
            jsonWriter.value(compilerWorkingDirectory);
            jsonWriter.name("arguments");
            jsonWriter.beginArray();
            jsonWriter.value(compilerExecutable);
            for (String compilerOption : compilerOptions) {
                jsonWriter.value(compilerOption);
            }
            jsonWriter.value(inputFile);
            jsonWriter.endArray();
            jsonWriter.name("file");
            jsonWriter.value(inputFile);
            jsonWriter.endObject();
            jsonWriter.endArray();
        }
    }

    @NotNull
    public static File getBuiltinClangTidyPath() {
        return ClangUtils.getBuiltinClangToolPath(SystemInfo.isWindows ? "clang-tidy.exe" : "clang-tidy");
    }

    public static boolean isToolEnabled(LocalInspectionTool inspection, @Nullable PsiFile file, @NotNull Project project) {
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)project)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project);
        InspectionProfileImpl profile = profileManager.getProfile(currentProfile);
        return profile.isToolEnabled(HighlightDisplayKey.find((String)inspection.getID()), (PsiElement)file);
    }

    @NotNull
    public static List<OurClangTidyInspection> getOurInspections(boolean onlyEnabled, @NotNull PsiFile file, @NotNull Project project) {
        List<InspectionToolWrapper<?, ?>> tools = CommonClangTidyUtil.findTools(onlyEnabled, file, project);
        ArrayList<OurClangTidyInspection> list = new ArrayList<OurClangTidyInspection>();
        for (InspectionToolWrapper<?, ?> tool : tools) {
            if (tool == null || !(tool.getTool() instanceof OurClangTidyInspection)) continue;
            OurClangTidyInspection toolTool = (OurClangTidyInspection)tool.getTool();
            list.add(toolTool);
        }
        return list;
    }

    @Nullable
    public static MisraInspection getMisraInspection(@NotNull PsiFile file, @NotNull Project project) {
        InspectionProfileEntry tool = CommonClangTidyUtil.findTool(MisraInspection.Companion.getInspectionShortName(), false, file, project);
        return tool instanceof MisraInspection ? (MisraInspection)tool : null;
    }

    @Nullable
    public static ClangTidyInspection getClangTidyInspection(@Nullable PsiFile file, @NotNull Project project) {
        InspectionProfileEntry tool = CommonClangTidyUtil.findTool(ClangTidyInspection.getInspectionShortName(), false, file, project);
        return tool instanceof ClangTidyInspection ? (ClangTidyInspection)tool : null;
    }

    @Nullable
    public static ClangTidyInspectionBase findInspectionFromClangTidyDiagnostic(@NotNull ClangTidyDiagnostic diagnostic, @NotNull PsiFile file, @NotNull Project project) {
        for (OurClangTidyInspection inspection : CommonClangTidyUtil.getOurInspections(false, file, project)) {
            if (!inspection.getCheckName().equals(diagnostic.getDiagnosticName())) continue;
            return inspection;
        }
        if (CommonClangTidyUtil.isMisraInspection(diagnostic)) {
            return CommonClangTidyUtil.getMisraInspection(file, project);
        }
        if (CommonClangTidyUtil.isClazyInspection(diagnostic)) {
            return CommonClangTidyUtil.getClazyInspection(file, project);
        }
        return CommonClangTidyUtil.getClangTidyInspection(file, project);
    }

    @Nullable
    public static ClazyInspection getClazyInspection(@NotNull PsiFile file, @NotNull Project project) {
        InspectionProfileEntry tool = CommonClangTidyUtil.findTool(ClazyInspection.getInspectionShortName(), false, file, project);
        return tool instanceof ClazyInspection ? (ClazyInspection)tool : null;
    }

    private static boolean isMisraInspection(@NotNull ClangTidyDiagnostic diagnostic) {
        return diagnostic.getDiagnosticName().startsWith("clion-misra-");
    }

    private static boolean isClazyInspection(@NotNull ClangTidyDiagnostic diagnostic) {
        return diagnostic.getDiagnosticName().startsWith("-Wclazy") || diagnostic.getDiagnosticName().startsWith("clazy");
    }

    @Nullable
    public static InspectionProfileEntry findTool(@NotNull String inspectionId, boolean onlyEnabled, @Nullable PsiFile file, @NotNull Project project) {
        for (InspectionToolWrapper<?, ?> toolWrapper : CommonClangTidyUtil.findTools(onlyEnabled, file, project)) {
            if (toolWrapper == null || !toolWrapper.getID().equals(inspectionId)) continue;
            return toolWrapper.getTool();
        }
        return null;
    }

    @NotNull
    public static List<InspectionToolWrapper<?, ?>> findTools(boolean onlyEnabled, @Nullable PsiFile file, @NotNull Project project) {
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)project)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project);
        InspectionProfileImpl profile = profileManager.getProfile(currentProfile);
        if (profile == null) {
            return Collections.emptyList();
        }
        List wrappers = profile.getInspectionTools((PsiElement)file);
        if (!onlyEnabled) {
            return wrappers;
        }
        ArrayList list = new ArrayList();
        for (InspectionToolWrapper wrapper : wrappers) {
            if (wrapper == null || !profile.isToolEnabled(HighlightDisplayKey.find((String)wrapper.getID()), (PsiElement)file)) continue;
            list.add(wrapper);
        }
        return list;
    }

    @NlsSafe
    @NotNull
    public static String getClangTidyConfig(@NlsSafe @NotNull String checks, @NotNull List<ClangTidyCheckOption> checkOptions) {
        return ClangUtils.getClangTidyConfig(checks, checkOptions);
    }

    @NlsSafe
    @NotNull
    public static String concatClangTidyChecks(@NlsSafe @NotNull String checksA, @NlsSafe @NotNull String checksB) {
        List checks = ContainerUtil.concat((List)StringUtil.split((String)checksA, (String)","), (List)StringUtil.split((String)checksB, (String)","));
        return StringUtil.join((Collection)checks, (String)",");
    }

    private static @NotNull List<@NlsSafe String> getEnabledChecks(@NlsSafe @NotNull String checks) {
        List<String> options = CommonClangTidyUtil.getTrimmedOptions(checks);
        options.removeIf(it -> CommonClangTidyUtil.isDisabled(options, it));
        return options;
    }

    @NlsSafe
    @NotNull
    public static String joinChecks(@NlsSafe @NotNull String configA, @NlsSafe @NotNull String configB) {
        List<String> checksA = CommonClangTidyUtil.getEnabledChecks(configA);
        List<String> checksB = CommonClangTidyUtil.getEnabledChecks(configB);
        String joinedA = StringUtil.join(checksA, (String)",");
        String joinedB = StringUtil.join(checksB, (String)",");
        return CommonClangTidyUtil.concatClangTidyChecks(joinedA, joinedB);
    }

    @NotNull
    public static String enableCheck(@NotNull String configuration, @NotNull String checkName) {
        List<String> options = CommonClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> option.equals("-" + checkName));
        if (CommonClangTidyUtil.isDisabled(options, checkName)) {
            options.add(checkName);
        }
        return StringUtil.join(options, (String)",");
    }

    @NotNull
    public static String disableCheck(@NotNull String configuration, @NotNull String checkName) {
        List<String> options = CommonClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> option.equals(checkName));
        if (!CommonClangTidyUtil.isDisabled(options, checkName)) {
            options.add("-" + checkName);
        }
        return StringUtil.join(options, (String)",");
    }

    public static void modifyAllChecksWithSingleGroup(@NotNull Map<String, Boolean> checksState, @NotNull ClangTidyInspectionBase inspection) {
        if (checksState.isEmpty()) {
            return;
        }
        String groupName = CommonClangTidyUtil.getGroupName((String)checksState.keySet().stream().findFirst().get());
        List<String> enabledChecks = checksState.entrySet().stream().filter(e -> (Boolean)e.getValue()).map(e -> (String)e.getKey()).toList();
        List<String> disabledChecks = checksState.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(e -> (String)e.getKey()).toList();
        if (enabledChecks.size() <= disabledChecks.size()) {
            inspection.disableAllChecksInGroup(groupName);
            for (String check : enabledChecks) {
                inspection.enableCheck(check);
            }
        } else {
            inspection.enableAllChecksInGroup(groupName);
            for (String check : disabledChecks) {
                inspection.disableCheck(check);
            }
        }
    }

    @NotNull
    public static String getGroupName(@NotNull String option) {
        if (option.startsWith("clang-analyzer")) {
            return "clang-analyzer";
        }
        if (option.startsWith("clion-misra-c2012")) {
            return "C2012";
        }
        if (option.startsWith("clion-misra-cpp2008")) {
            return "C++2008";
        }
        List parts = StringUtil.split((String)option, (String)"-");
        return parts.size() >= 1 ? (String)parts.get(0) : "";
    }

    @NotNull
    public static String enableGroup(@NotNull String configuration, @NotNull String groupName) {
        List<String> options = CommonClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> option.startsWith(groupName) || option.startsWith("-") && option.substring(1).startsWith(groupName));
        if (CommonClangTidyUtil.isDisabled(options, groupName)) {
            options.add(groupName + "-*");
        }
        return StringUtil.join(options, (String)",");
    }

    @NotNull
    public static String disableGroup(@NotNull String configuration, @NotNull String groupName) {
        List<String> options = CommonClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> option.startsWith(groupName) || option.startsWith("-") && option.substring(1).startsWith(groupName));
        if (!CommonClangTidyUtil.isDisabled(options, groupName)) {
            options.add("-" + groupName + "-*");
        }
        return StringUtil.join(options, (String)",");
    }

    @NotNull
    public static String getCheckNameWithoutGroup(@NotNull String checkName) {
        String groupName = CommonClangTidyUtil.getGroupName(checkName) + "-";
        return checkName.startsWith(groupName) ? checkName.substring(groupName.length()) : checkName;
    }

    public static List<String> getTrimmedOptions(@NotNull String configuration) {
        List options = StringUtil.split((String)configuration, (String)",");
        options.replaceAll(String::trim);
        return options;
    }

    public static boolean isDisabled(@NotNull List<String> options, @NotNull String checkName) {
        boolean disabled = false;
        for (String option : options) {
            if (option.equals("*")) {
                disabled = false;
                continue;
            }
            if (option.equals("-*")) {
                disabled = true;
                continue;
            }
            if (CommonClangTidyUtil.groupOrCheckEnabled(option, checkName)) {
                disabled = false;
                continue;
            }
            if (!CommonClangTidyUtil.groupOrCheckDisabled(option, checkName)) continue;
            disabled = true;
        }
        return disabled;
    }

    @NotNull
    public static String buildClangTidyHelpPage(@NotNull String checkName) {
        if (!CommonClangTidyUtil.hasDocumentationPage(checkName)) {
            return "";
        }
        if (StringUtil.split((String)checkName, (String)"-").size() <= 1) {
            return "";
        }
        String groupName = CommonClangTidyUtil.getGroupName(checkName);
        if (StringUtil.isEmpty((String)groupName)) {
            return "";
        }
        String checkNameWithoutGroup = checkName.substring(groupName.length() + 1);
        if (StringUtil.isEmpty((String)checkNameWithoutGroup)) {
            return "";
        }
        if (groupName.equals("linuxkernel") && checkNameWithoutGroup.equals("must-check-errs")) {
            checkNameWithoutGroup = "must-use-errs";
        }
        return "https://clang.llvm.org/extra/clang-tidy/checks/" + groupName + "/" + checkNameWithoutGroup + ".html";
    }

    private static boolean hasDocumentationPage(@NotNull String checkName) {
        return !checkName.startsWith("clang-analyzer") || clangAnalyzerChecksWithDocumentation.contains(checkName);
    }

    private static boolean groupOrCheckEnabled(@NotNull String option, @NotNull String checkName) {
        return option.equals(checkName) || option.length() > 1 && option.endsWith("*") && checkName.startsWith(option.substring(0, option.length() - 1));
    }

    private static boolean groupOrCheckDisabled(@NotNull String option, @NotNull String checkName) {
        if (!option.startsWith("-")) {
            return false;
        }
        if (option.endsWith("*")) {
            return option.length() > 2 && checkName.startsWith(option.substring(1, option.length() - 1));
        }
        return option.length() > 1 && checkName.equals(option.substring(1));
    }
}

