/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyInspectionDescriptionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyTooltipLinkHandler
extends TooltipLinkHandler {
    private static final Logger LOG = Logger.getInstance(ClangTidyTooltipLinkHandler.class);

    @NlsSafe
    @Nullable
    public String getDescription(@NotNull String refSuffix, @NotNull Editor editor) {
        try {
            return "<html>\n<body>\n" + new ClangTidyInspectionDescriptionProvider().getTooltip(refSuffix) + "&nbsp;" + ClangTidyTooltipLinkHandler.getLearnMoreLink(refSuffix) + "</body>\n</html>\n";
        }
        catch (Exception e) {
            LOG.error("Failed to get description for: " + refSuffix, (Throwable)e);
            return "";
        }
    }

    @NotNull
    @NlsSafe
    private static String getLearnMoreLink(@NotNull @NlsSafe String checkName) {
        return "<a style=\"white-space: nowrap\" href=#clangTidyFullDescription/" + checkName + ">" + ClangdBundle.message("clang.tidy.description.learn.more.link", new Object[0]) + "</a>";
    }
}

