/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClangTidySuppressIntentionAction
extends SuppressIntentionAction {
    @NotNull
    private final String myCheckName;
    @NotNull
    private static final Pattern NOLINT_ARGS_PATTERN = Pattern.compile(".*NOLINT\\s*\\((.*)\\).*");
    @NotNull
    private static final Pattern COMMENT_PATTERN = Pattern.compile(".*//(.*)|/\\*(.*)\\*/");
    private static final Logger LOG = Logger.getInstance(ClangTidySuppressIntentionAction.class);

    public ClangTidySuppressIntentionAction(@NotNull String checkName) {
        this.myCheckName = checkName;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (editor == null) {
            return;
        }
        PsiFile file = element.getContainingFile();
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int offset = editor.getCaretModel().getOffset();
        int lineNumber = document.getLineNumber(offset);
        TextRange lineTextRange = DocumentUtil.getLineTextRange((Document)document, (int)lineNumber);
        String lineText = document.getText(lineTextRange);
        Matcher commentMatcher = COMMENT_PATTERN.matcher(lineText);
        if (commentMatcher.find()) {
            boolean isEolComment = commentMatcher.group(1) != null;
            int groupToTake = isEolComment ? 1 : 2;
            String commentText = commentMatcher.group(groupToTake);
            Matcher noLineMatcher = NOLINT_ARGS_PATTERN.matcher(commentText);
            if (noLineMatcher.find()) {
                String checkNameList = noLineMatcher.group(1);
                ClangTidySuppressIntentionAction.insertNoLintComment((String)(checkNameList.trim().isEmpty() ? this.myCheckName : "," + this.myCheckName), lineTextRange.getStartOffset() + commentMatcher.start(groupToTake) + noLineMatcher.start(1) + checkNameList.length(), file, project);
                return;
            }
            if (isEolComment) {
                ClangTidySuppressIntentionAction.insertNoLintComment(" NOLINT(" + this.myCheckName + ")", lineTextRange.getEndOffset(), file, project);
                return;
            }
        }
        ClangTidySuppressIntentionAction.insertNoLintComment(" // NOLINT(" + this.myCheckName + ")", lineTextRange.getEndOffset(), file, project);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        int offset;
        int lineNumber;
        TextRange lineTextRange;
        if (editor == null || !element.isValid()) {
            return false;
        }
        Document document = editor.getDocument();
        String lineText = document.getText(lineTextRange = DocumentUtil.getLineTextRange((Document)document, (int)(lineNumber = document.getLineNumber(offset = element.getTextOffset()))));
        return !lineText.endsWith("\\");
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return ClangdBundle.message("inspection.clangTidy.suppress.for.line", new Object[0]);
    }

    @NotNull
    public String getText() {
        return ClangdBundle.message("inspection.clangTidy.suppress.check.for.line", StringUtil.wrapWithDoubleQuote((String)this.myCheckName));
    }

    private static void insertNoLintComment(@NotNull String comment, int offset, @NotNull PsiFile file, @NotNull Project project) {
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null || !file.isValid()) {
            LOG.error((Object)("Can't insert nolint comment: document is null (" + document == "null), file.isValid (" + file.isValid() + ")" ? 1 : 0));
            return;
        }
        document.replaceString(offset, offset, (CharSequence)comment);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
    }
}

