/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyFileUtils;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ConfigureClangTidyOptionsAction;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CreateClangTidyFileOptionAction;
import com.jetbrains.cidr.lang.daemon.clang.tidy.EditClangTidyOptionsAction;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyStatusBarWidget
extends EditorBasedStatusBarPopup {
    public static final String ID = "ClangTidyStatusBarWidget";

    public ClangTidyStatusBarWidget(@NotNull Project project) {
        super(project, false);
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        ClangTidyInspection inspection = CommonClangTidyUtil.getClangTidyInspection(null, this.myProject);
        ClangTidyFilesState state = (ClangTidyFilesState)this.myProject.getService(ClangTidyFilesState.class);
        if (state == null || file == null || inspection == null || !inspection.isPreferClangTidyFilesOverIDESettings()) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        if (!OCFileTypeHelpers.isHeaderFile((String)file.getName()) && !OCFileTypeHelpers.isSourceFile((String)file.getName())) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        return new EditorBasedStatusBarPopup.WidgetState("", ClangdBundle.message("clang.tidy.status.bar.widget.title", new Object[0]), true);
    }

    @Nullable
    protected ListPopup createPopup(@NotNull DataContext context) {
        VirtualFile selectedFile = this.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        File currentFile = new File(selectedFile.getPath());
        File nearestClangTidyFile = ClangTidyFileUtils.findNearestClangTidyFile(currentFile, this.myProject);
        actionGroup.add((AnAction)new EditClangTidyOptionsAction(currentFile, this.myProject, nearestClangTidyFile));
        actionGroup.add((AnAction)new CreateClangTidyFileOptionAction(currentFile, this.myProject, nearestClangTidyFile));
        actionGroup.add((AnAction)new ConfigureClangTidyOptionsAction(this.myProject));
        return new PopupFactoryImpl.ActionGroupPopup(ClangdBundle.message("language.cpp.clang-tidy.configurable.name", new Object[0]), (ActionGroup)actionGroup, context, false, false, true, false, null, 15, null, null);
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        return new ClangTidyStatusBarWidget(project);
    }
}

