/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.InspectionDescriptionProvider;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import java.awt.Color;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ClangTidyInspectionDescriptionProvider
extends InspectionDescriptionProvider {
    private static final String CLANG_TIDY_CSS_PLACEHOLDER = "/* CLION CLANG-TIDY DOCUMENTATION CSS PLACEHOLDER */";
    private static final Character[] PUNCTUATORS = new Character[]{Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf(':'), Character.valueOf(';')};

    @Override
    @Nullable
    public String getTooltip(@NotNull String checkName) throws Exception {
        Document document = ClangTidyInspectionDescriptionProvider.buildHtmlDocument(checkName);
        if (document == null) {
            return "";
        }
        Node descriptionNode = ClangTidyInspectionDescriptionProvider.findFirstParagraphWithDescription(document.getChildNodes(), checkName);
        if (descriptionNode == null) {
            return "";
        }
        String text = descriptionNode.getTextContent();
        text = ClangTidyInspectionDescriptionProvider.trimWhitespaces(text);
        text = ClangTidyInspectionDescriptionProvider.replaceTrailingPunctuatorsWithDots(text);
        return text;
    }

    @Override
    @Nullable
    public String getHtmlDescription(@NotNull String checkName) throws Exception {
        String descriptionPath = ClangTidyInspectionDescriptionProvider.getBundledDescriptionPath(checkName);
        if (!FileUtil.exists((String)descriptionPath)) {
            return null;
        }
        try (FileInputStream stream = new FileInputStream(descriptionPath);){
            String descriptionText = ResourceUtil.loadText((InputStream)stream);
            String string = descriptionText = ClangTidyInspectionDescriptionProvider.replaceCssPlaceholder(descriptionText);
            return string;
        }
    }

    @Override
    public boolean hasHtmlDescription(@NotNull String checkName) {
        return FileUtil.exists((String)ClangTidyInspectionDescriptionProvider.getBundledDescriptionPath(checkName));
    }

    @Override
    public boolean hasAnyHtmlDescription() {
        return true;
    }

    @NotNull
    @NlsSafe
    private static String replaceCssPlaceholder(@NotNull String text) throws Exception {
        StringBuilder cssTagsBuilder = new StringBuilder();
        for (String cssFile : ClangTidyInspectionDescriptionProvider.getBundledCssFiles()) {
            cssTagsBuilder.append(ClangTidyInspectionDescriptionProvider.createCssLinkElement(cssFile));
        }
        cssTagsBuilder.append(ClangTidyInspectionDescriptionProvider.createInlinePygmentsCssElement());
        return text.replace(CLANG_TIDY_CSS_PLACEHOLDER, cssTagsBuilder.toString());
    }

    @NotNull
    @NlsSafe
    private static String replaceTrailingPunctuatorsWithDots(@NotNull @NlsSafe String description) {
        int finalEndIndex;
        int endIndex = description.length();
        while (endIndex > 0 && ContainerUtil.exists((Object[])PUNCTUATORS, arg_0 -> ClangTidyInspectionDescriptionProvider.lambda$replaceTrailingPunctuatorsWithDots$0(description, finalEndIndex = endIndex--, arg_0))) {
        }
        return description.substring(0, endIndex) + "...";
    }

    @Nullable
    private static Document buildHtmlDocument(@NotNull String checkName) throws Exception {
        String descriptionPath = ClangTidyInspectionDescriptionProvider.getBundledDescriptionPath(checkName);
        if (!FileUtil.exists((String)descriptionPath)) {
            return null;
        }
        try (FileInputStream stream = new FileInputStream(descriptionPath);){
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(stream));
            return document;
        }
    }

    private static Node findFirstParagraphWithDescription(@NotNull NodeList nodes, @NotNull String checkName) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("section") || !ClangTidyInspectionDescriptionProvider.hasAttributes(node, Pair.pair((Object)"id", (Object)checkName))) {
                Node descriptionInChildNodes = ClangTidyInspectionDescriptionProvider.findFirstParagraphWithDescription(node.getChildNodes(), checkName);
                if (descriptionInChildNodes == null) continue;
                return descriptionInChildNodes;
            }
            NodeList childNodes = node.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node childNode = childNodes.item(j);
                if (!childNode.getNodeName().equals("p")) continue;
                return childNode;
            }
        }
        return null;
    }

    private static boolean hasAttributes(@NotNull Node node, Pair<String, String> ... attributes) {
        if (!node.hasAttributes()) {
            return false;
        }
        NamedNodeMap nodeAttributes = node.getAttributes();
        for (Pair<String, String> attribute : attributes) {
            String attributeValue;
            Node classNode = nodeAttributes.getNamedItem((String)attribute.first);
            if (classNode == null || StringUtil.isEmpty((String)(attributeValue = classNode.getNodeValue())) || !attributeValue.equals(attribute.second)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String trimWhitespaces(@NotNull String text) {
        return text.replaceAll("[ \t]+", " ").replaceAll("\n ", "\n");
    }

    @NotNull
    private static String createInlinePygmentsCssElement() {
        return "<style>\n" + ClangTidyInspectionDescriptionProvider.getPygmentsCssContent() + "\n</style>";
    }

    @NotNull
    private static String createCssLinkElement(@NotNull String cssFilePath) {
        return "<link rel=\"stylesheet\" type=\"text/css\" href=" + StringUtil.wrapWithDoubleQuote((String)cssFilePath) + "/>";
    }

    @NotNull
    private static String getBundledDescriptionPath(@NotNull String checkName) {
        String groupName = CommonClangTidyUtil.getGroupName(checkName);
        String checkNameWithoutGroup = CommonClangTidyUtil.getCheckNameWithoutGroup(checkName);
        if (groupName.equals("linuxkernel") && checkNameWithoutGroup.equals("must-check-errs")) {
            checkNameWithoutGroup = "must-use-errs";
        }
        return FileUtil.join((String[])new String[]{ClangTidyInspectionDescriptionProvider.getDocumentationBasePath(), groupName, checkNameWithoutGroup + ".html"});
    }

    @NotNull
    public static List<String> getBundledCssFiles() {
        String[] cssFileNames = new String[]{"basic.css", "haiku.css", "clang-tools-extra-styles.css"};
        ArrayList<String> cssFilePaths = new ArrayList<String>(cssFileNames.length);
        String basePath = ClangTidyInspectionDescriptionProvider.getDocumentationBasePath();
        for (String cssFileName : cssFileNames) {
            cssFilePaths.add(FileUtil.join((String[])new String[]{basePath, cssFileName}));
        }
        return cssFilePaths;
    }

    @NotNull
    @NlsSafe
    private static String getPygmentsCssContent() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        Map highlightClassesToColor = Map.ofEntries(Map.entry(new String[]{".o", ".nc", ".nf", ".nn", ".vm", ".vi", ".vg", ".vc", ".nv", ".nn", ".nl", ".ne", ".no"}, ClangTidyInspectionDescriptionProvider.toRgbColor(UIUtil.getLabelForeground())), Map.entry(new String[]{".c", ".c1", ".cm", ".ch"}, ClangTidyInspectionDescriptionProvider.toForegroundRgbColor(scheme.getAttributes(OCHighlightingKeys.OC_LINE_COMMENT))), Map.entry(new String[]{".k", ".kt", ".nb", ".kr", ".sa", ".kn", ".kd", ".kc", ".bp"}, ClangTidyInspectionDescriptionProvider.toForegroundRgbColor(scheme.getAttributes(OCHighlightingKeys.OC_KEYWORD))), Map.entry(new String[]{".mi", ".il", ".mo", ".mh", ".mb", ".mf"}, ClangTidyInspectionDescriptionProvider.toForegroundRgbColor(scheme.getAttributes(OCHighlightingKeys.OC_NUMBER))), Map.entry(new String[]{".cp", ".cpf"}, ClangTidyInspectionDescriptionProvider.toForegroundRgbColor(scheme.getAttributes(OCHighlightingKeys.OC_DIRECTIVE))), Map.entry(new String[]{".sc", ".s"}, ClangTidyInspectionDescriptionProvider.toForegroundRgbColor(scheme.getAttributes(OCHighlightingKeys.OC_STRING))));
        String[] labelCssClasses = new String[]{"p", "h1", "h2", "h3", "dt", "pre", ".pre", ".line"};
        String[] panelBackgroundCssClasses = new String[]{"body", "code", ".highlight"};
        String[] italicFontStyles = new String[]{".c", ".ch", ".cm", ".cpf", ".c1", ".si", ".sd"};
        ArrayList<String> cssStyles = new ArrayList<String>();
        cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle("pre", "line-height", "125%"));
        cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle("dt:target, span.highlighted", "background-color", "transparent"));
        for (Map.Entry highlightClassToColor : highlightClassesToColor.entrySet()) {
            for (String highlightClass : (String[])highlightClassToColor.getKey()) {
                cssStyles.add(ClangTidyInspectionDescriptionProvider.createHighlightForegroundCssStyle(highlightClass, (String)highlightClassToColor.getValue()));
            }
        }
        for (String labelCssClass : labelCssClasses) {
            cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle(labelCssClass, "color", ClangTidyInspectionDescriptionProvider.toRgbColor(UIUtil.getLabelForeground())));
        }
        for (String panelBackgroundCssClass : panelBackgroundCssClasses) {
            cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle(panelBackgroundCssClass, "background", ClangTidyInspectionDescriptionProvider.toRgbColor(UIUtil.getPanelBackground())));
        }
        for (String italicFontStyle : italicFontStyles) {
            cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle(italicFontStyle, "font-style", "italic"));
        }
        cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle("a:link, a:visited, a:active, a .pre", "color", ClangTidyInspectionDescriptionProvider.toRgbColor(JBUI.CurrentTheme.Link.Foreground.ENABLED)));
        Font ideFont = StartupUiUtil.getLabelFont();
        String[] familyFonts = new String[]{StringUtil.wrapWithDoubleQuote((String)ideFont.getName()), StringUtil.wrapWithDoubleQuote((String)"DejaVu Sans"), "Arial", "Helvetica", "sans-serif"};
        cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle("body", "font-family", StringUtil.join((String[])familyFonts, (String)",")));
        cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle("body", "font-size", ideFont.getSize() + "px"));
        cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle("pre", "font-family", "monospace"));
        return StringUtil.join(cssStyles, (String)"\n");
    }

    @NotNull
    private static String createHighlightForegroundCssStyle(@NotNull String childCssClass, @NotNull String value) {
        return ClangTidyInspectionDescriptionProvider.createCssStyle(".highlight " + childCssClass, "color", value);
    }

    @NotNull
    private static String createCssStyle(@NotNull String elementsOrClasses, @NotNull String property, @NotNull String value) {
        return elementsOrClasses + " {" + property + ": " + value + "; }";
    }

    @NotNull
    private static String toForegroundRgbColor(@NotNull TextAttributes attributes) {
        return ClangTidyInspectionDescriptionProvider.toRgbColor(attributes.getForegroundColor());
    }

    @NotNull
    private static String toRgbColor(@NotNull Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    @NotNull
    private static String getDocumentationBasePath() {
        return CidrPathManager.getBinPath(ClangTidyInspectionDescriptionProvider.class, (String)"clion/bin", (String)"clang/clangTidyDoc", null, (boolean)false).toString();
    }

    private static /* synthetic */ boolean lambda$replaceTrailingPunctuatorsWithDots$0(String description, int finalEndIndex, Character p) {
        return description.charAt(finalEndIndex - 1) == p.charValue();
    }
}

