/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyFileUtils {
    @NonNls
    public static final String CLANG_TIDY = ".clang-tidy";

    @Nullable
    public static File findNearestClangTidyFile(@NotNull File sourceFile, @NotNull Project project) {
        ClangTidyFilesState state = (ClangTidyFilesState)project.getService(ClangTidyFilesState.class);
        return state != null ? state.findNearestClangTidyFile(sourceFile) : null;
    }

    public static boolean createClangTidyFileInDirectory(@NotNull Project project) {
        VirtualFile directory = project.getBaseDir();
        try {
            if (directory == null) {
                return false;
            }
            WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                VirtualFile vfClangTidy = directory.createChildData((Object)project, CLANG_TIDY);
                vfClangTidy.setCharset(StandardCharsets.UTF_8);
                ClangTidyInspection inspection = CommonClangTidyUtil.getClangTidyInspection(null, project);
                VfsUtil.saveText((VirtualFile)vfClangTidy, (String)ClangTidyFileUtils.convertChecksToClangTidy(inspection != null ? inspection.getClangTidyChecks() : ""));
                FileEditorManager.getInstance((Project)project).openFile(vfClangTidy, true);
            });
        }
        catch (Throwable e) {
            if (e.getCause() instanceof FileAlreadyExistsException) {
                return false;
            }
            ExceptionUtil.rethrow((Throwable)e);
        }
        return true;
    }

    public static String convertChecksToClangTidy(@NotNull String clangTidyChecks) {
        return "# Generated from CLion Inspection settings\n---\nChecks: '" + clangTidyChecks.replace(",", ",\n") + "'";
    }
}

