/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.settings.CPPLanguageConfigurable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyConfigurable
extends CPPLanguageConfigurable {
    private final ClangTidySettings mySettings = ClangTidySettings.getInstance();
    private JBCheckBox myCheckBox;
    private JBTextField myTextField;
    private ProgressIndicator myProgressIndicator;

    @NotNull
    public String getId() {
        return "language.cpp.clang-tidy";
    }

    @Nullable
    public String getHelpTopic() {
        return "settings.clangtidy";
    }

    @Nullable
    public JComponent createComponent() {
        this.myCheckBox = new JBCheckBox(ClangdBundle.message("configurable.clangTidy.use.external.binary.checkbox", new Object[0]), this.mySettings.getUseExternalClangTidy());
        this.myTextField = new JBTextField(this.mySettings.getExternalClangTidyPath(), 30);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
        BrowseFilesListener browseFilesListener = new BrowseFilesListener((JTextField)this.myTextField, ClangdBundle.message("configurable.clangTidy.use.external.binary.path", new Object[0]), "", descriptor);
        final TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton((JTextField)this.myTextField, (ActionListener)browseFilesListener);
        textFieldWithBrowseButton.setEnabled(this.myCheckBox.isSelected());
        this.myCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isSelected = ClangTidyConfigurable.this.myCheckBox.isSelected();
                textFieldWithBrowseButton.setEnabled(isSelected);
            }
        });
        JBLabel minClangTidySupportedVersionHint = new JBLabel(ClangdBundle.message("configurable.clangTidy.min.supported.clangTidy.version", new Object[0]));
        minClangTidySupportedVersionHint.setForeground((Color)JBColor.GRAY);
        minClangTidySupportedVersionHint.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        JBLabel builtinClangTidyVersion = new JBLabel();
        builtinClangTidyVersion.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        builtinClangTidyVersion.setCopyable(true);
        builtinClangTidyVersion.setText(ClangdBundle.message("configurable.clangTool.version.checking", "Clang-Tidy"));
        this.myProgressIndicator = new AbstractProgressIndicatorBase();
        ClangUtils.getClangToolVersionAsync("Clang-Tidy", CommonClangTidyUtil.getBuiltinClangTidyPath().getPath(), this.myProgressIndicator).thenAccept(output -> SwingUtilities.invokeLater(() -> {
            this.myProgressIndicator.checkCanceled();
            Matcher matcher = StringUtil.isNotEmpty((String)output) ? CommonClangTidyUtil.CLANG_TIDY_VERSION_PATTERN.matcher((CharSequence)output) : null;
            String versionText = matcher != null && matcher.matches() ? ClangdBundle.message("configurable.clangTool.version", "Clang-Tidy", matcher.group(1)) : ClangdBundle.message("configurable.clangTool.version.unable.check", "Clang-Tidy");
            builtinClangTidyVersion.setText(versionText);
        }));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.myCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        panel.add((Component)textFieldWithBrowseButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel.add((Component)minClangTidySupportedVersionHint, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel.add((Component)builtinClangTidyVersion, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.insets((int)20, (int)10), 0, 0));
        return panel;
    }

    public void disposeUIResources() {
        if (this.myProgressIndicator != null && this.myProgressIndicator.isRunning()) {
            this.myProgressIndicator.cancel();
        }
        this.myProgressIndicator = null;
    }

    public boolean isModified() {
        return this.myCheckBox.isSelected() != this.mySettings.getUseExternalClangTidy() || !this.myTextField.getText().equals(this.mySettings.getExternalClangTidyPath());
    }

    public void apply() throws ConfigurationException {
        this.saveSettings();
        CidrLangUtil.restartCodeAnalyzer();
    }

    public void reset() {
        ApplicationManager.getApplication().runReadAction(() -> {
            this.myCheckBox.setSelected(this.mySettings.getUseExternalClangTidy());
            this.myTextField.setText(this.mySettings.getExternalClangTidyPath());
        });
    }

    @Nls
    public String getDisplayName() {
        return ClangdBundle.message("inspection.clangTidy.name", new Object[0]);
    }

    private void saveSettings() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.mySettings.setUseExternalClangTidy(this.myCheckBox.isSelected());
            this.mySettings.setExternalClangTidyPath(this.myTextField.getText());
        });
    }
}

