/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.TabbedPaneImpl;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.CellBuilder;
import com.intellij.ui.layout.CellKt;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.ModalityUiUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProviderListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexerParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangIndexerCustomCommandDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdDumpIndexerState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdIndexerPanel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdIndexerPanelKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J;\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000eH\u0002J\"\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J0\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u001f2\b\b\u0002\u0010$\u001a\u00020\u001fH\u0002J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdIndexerPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "indexAppState", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdIndexerPanel$IndexAppState;", "indexViewerState", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdIndexerPanel$IndexViewerState;", "actWithService", "", "console", "Lcom/intellij/execution/ui/ConsoleView;", "block", "Lkotlin/Function1;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;", "Lkotlin/ParameterName;", "name", "service", "", "connectToService", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "lspView", "appView", "createAppLog", "Lkotlin/Pair;", "Lcom/intellij/openapi/ui/DialogPanel;", "createIndexViewer", "createIndexerParams", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionIndexerParams;", "clangdModulesPath", "", "createLspLog", "runIndexerCommand", "Ljava/util/concurrent/CompletableFuture;", "command", "arguments", "updateSettings", "IndexAppState", "IndexViewerState", "intellij.c.clangd"})
public final class ClangdIndexerPanel
extends ClangdPanelBase {
    @NotNull
    private final IndexViewerState indexViewerState = new IndexViewerState(null, false, null, 7, null);
    @NotNull
    private final IndexAppState indexAppState = new IndexAppState(null, null, null, 0, 15, null);

    public ClangdIndexerPanel(@NotNull Project project) {
        this.indexAppState.setIndexerModulesCacheMb(ClangdSettings.getInstance(project).getIndexerModulesCacheMb());
        TabbedPaneImpl tabbedPane = new TabbedPaneImpl(1);
        this.add((Component)tabbedPane);
        final ConsoleView lspConsoleView = this.createLspLog(project);
        tabbedPane.add("LSP Log", (Component)lspConsoleView.getComponent());
        Pair<DialogPanel, ConsoleView> pair = this.createAppLog(project);
        DialogPanel appPanel2 = (DialogPanel)pair.component1();
        final ConsoleView appConsoleView = (ConsoleView)pair.component2();
        tabbedPane.add("App Log", (Component)appPanel2);
        this.indexAppState.setAppPanel(appPanel2);
        this.indexAppState.setAppConsoleView(appConsoleView);
        this.indexViewerState.setIndexViewer(this.createIndexViewer(project));
        tabbedPane.add("Index Viewer", (Component)this.indexViewerState.getIndexViewer());
        project.getMessageBus().connect((Disposable)this).subscribe(ClangLanguageServiceProviderListener.TOPIC, (Object)new ClangLanguageServiceProviderListener(){

            @Override
            public void onServiceStarted(@NotNull ClangLanguageService service) {
                if (Intrinsics.areEqual((Object)service.getDescriptor(), (Object)"indexer")) {
                    this.connectToService(service, lspConsoleView, appConsoleView);
                }
            }
        });
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(project);
        this.connectToService(clangLanguageServiceProvider != null ? clangLanguageServiceProvider.getIfStartedIndexer() : null, lspConsoleView, appConsoleView);
        AnAction[] anActionArray = new AnAction[]{(AnAction)new ClangdDumpIndexerState()};
        this.createToolbarWithActions(anActionArray);
    }

    private final ConsoleView createLspLog(Project project) {
        ConsoleView lspConsoleView = new TextConsoleBuilderImpl(project).getConsole();
        Disposer.register((Disposable)this, (Disposable)((Disposable)lspConsoleView));
        ConsoleViewImpl consoleViewImpl = lspConsoleView instanceof ConsoleViewImpl ? (ConsoleViewImpl)lspConsoleView : null;
        EditorSettings editorSettings = consoleViewImpl != null && (consoleViewImpl = consoleViewImpl.getEditor()) != null ? consoleViewImpl.getSettings() : null;
        if (editorSettings != null) {
            editorSettings.setUseSoftWraps(false);
        }
        TextAttributes methodHighlightAttrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        Pattern methodPattern = Pattern.compile("\"method\": \"(.*?)\"");
        lspConsoleView.addMessageFilter((arg_0, arg_1) -> ClangdIndexerPanel.createLspLog$lambda$0(methodPattern, methodHighlightAttrs, arg_0, arg_1));
        return lspConsoleView;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<DialogPanel, ConsoleView> createAppLog(Project project) {
        void constraints$iv;
        Color bgcolor$iv;
        LayoutBuilder builder$iv;
        ConsoleView appConsoleView = new TextConsoleBuilderImpl(project).getConsole();
        Disposer.register((Disposable)this, (Disposable)((Disposable)appConsoleView));
        ConsoleViewImpl consoleViewImpl = appConsoleView instanceof ConsoleViewImpl ? (ConsoleViewImpl)appConsoleView : null;
        EditorSettings editorSettings = consoleViewImpl != null && (consoleViewImpl = consoleViewImpl.getEditor()) != null ? consoleViewImpl.getSettings() : null;
        if (editorSettings != null) {
            editorSettings.setUseSoftWraps(false);
        }
        int coresNumber = Runtime.getRuntime().availableProcessors();
        LCFlags[] $this$toTypedArray$iv = (LCFlags[])CollectionsKt.toList((Iterable)((Iterable)new IntRange(0, coresNumber)));
        boolean $i$f$toTypedArray22 = false;
        LCFlags[] thisCollection$iv = $this$toTypedArray$iv;
        DefaultComboBoxModel<Integer> indexingThreadsModel = new DefaultComboBoxModel<Integer>(thisCollection$iv.toArray(new Integer[0]));
        indexingThreadsModel.setSelectedItem(ClangdSettings.getInstance(project).getIndexingThreadsNum());
        indexingThreadsModel.addListDataListener(new ListDataListener(indexingThreadsModel, project, this, appConsoleView){
            final /* synthetic */ DefaultComboBoxModel<Integer> $indexingThreadsModel;
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ ConsoleView $appConsoleView;
            {
                this.$indexingThreadsModel = $indexingThreadsModel;
                this.$project = $project;
                this.this$0 = $receiver;
                this.$appConsoleView = $appConsoleView;
            }

            public void intervalAdded(@Nullable ListDataEvent e) {
            }

            public void intervalRemoved(@Nullable ListDataEvent e) {
            }

            public void contentsChanged(@Nullable ListDataEvent e) {
                Object object = this.$indexingThreadsModel.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int newThreadsNum = (Integer)object;
                if (newThreadsNum != ClangdSettings.getInstance(this.$project).getIndexingThreadsNum()) {
                    ClangdSettings.getInstance(this.$project).setIndexingThreadsNum(newThreadsNum);
                    ClangdIndexerPanel.access$updateSettings(this.this$0, this.$project, this.$appConsoleView);
                }
            }
        });
        int[] $i$f$toTypedArray22 = new int[]{500, 1000, 1500, 2000, 2500, 3000, 3500, 4000, 4500, 5000, 5500, 6000, 6500, 7000};
        DefaultComboBoxModel<Integer> modulesCacheModel = new DefaultComboBoxModel<Integer>(ArraysKt.toTypedArray((int[])$i$f$toTypedArray22));
        modulesCacheModel.setSelectedItem(ClangdSettings.getInstance(project).getIndexerModulesCacheMb());
        modulesCacheModel.addListDataListener(new ListDataListener(modulesCacheModel, project, this, appConsoleView){
            final /* synthetic */ DefaultComboBoxModel<Integer> $modulesCacheModel;
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ ConsoleView $appConsoleView;
            {
                this.$modulesCacheModel = $modulesCacheModel;
                this.$project = $project;
                this.this$0 = $receiver;
                this.$appConsoleView = $appConsoleView;
            }

            public void intervalAdded(@Nullable ListDataEvent e) {
            }

            public void intervalRemoved(@Nullable ListDataEvent e) {
            }

            public void contentsChanged(@Nullable ListDataEvent e) {
                Object object = this.$modulesCacheModel.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int newModulesCacheMb = (Integer)object;
                if (newModulesCacheMb != ClangdSettings.getInstance(this.$project).getIndexerModulesCacheMb()) {
                    ClangdSettings.getInstance(this.$project).setIndexerModulesCacheMb(newModulesCacheMb);
                    ClangdIndexerPanel.access$updateSettings(this.this$0, this.$project, this.$appConsoleView);
                }
            }
        });
        thisCollection$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$createAppLog_u24lambda_u241 = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.row$default((RowBuilder)((RowBuilder)$this$createAppLog_u24lambda_u241), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(project, this, appConsoleView, indexingThreadsModel, modulesCacheModel){
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ ConsoleView $appConsoleView;
            final /* synthetic */ DefaultComboBoxModel<Integer> $indexingThreadsModel;
            final /* synthetic */ DefaultComboBoxModel<Integer> $modulesCacheModel;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$appConsoleView = $appConsoleView;
                this.$indexingThreadsModel = $indexingThreadsModel;
                this.$modulesCacheModel = $modulesCacheModel;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                boolean isSelected$iv;
                String text$iv;
                Object object;
                Object object2 = this.$project;
                ClangdIndexerPanel clangdIndexerPanel = this.this$0;
                ConsoleView consoleView = this.$appConsoleView;
                boolean isVerticalFlow$iv = false;
                boolean isFullWidth$iv = false;
                boolean $i$f$cell = false;
                $this$row.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$invoke_u24lambda_u249 = new InnerCell((Cell)$this$row);
                boolean bl = false;
                $this$invoke_u24lambda_u249.button("Clear Caches", (Function1)new Function1<ActionEvent, Unit>(clangdIndexerPanel, object2, consoleView){
                    final /* synthetic */ ClangdIndexerPanel this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ ConsoleView $appConsoleView;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$appConsoleView = $appConsoleView;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionEvent it) {
                        DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                        if (dialogPanel != null) {
                            dialogPanel.apply();
                        }
                        ClangdIndexerPanel.runIndexerCommand$default(this.this$0, this.$project, this.$appConsoleView, "clearCaches", null, 8, null);
                    }
                });
                $this$invoke_u24lambda_u249.button("Rebuild", (Function1)new Function1<ActionEvent, Unit>(clangdIndexerPanel, object2, consoleView){
                    final /* synthetic */ ClangdIndexerPanel this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ ConsoleView $appConsoleView;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$appConsoleView = $appConsoleView;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionEvent it) {
                        DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                        if (dialogPanel != null) {
                            dialogPanel.apply();
                        }
                        ClangdIndexerPanel.runIndexerCommand$default(this.this$0, this.$project, this.$appConsoleView, "rebuild", null, 8, null);
                    }
                });
                $this$invoke_u24lambda_u249.button("Reindex", (Function1)new Function1<ActionEvent, Unit>(clangdIndexerPanel, object2, consoleView){
                    final /* synthetic */ ClangdIndexerPanel this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ ConsoleView $appConsoleView;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$appConsoleView = $appConsoleView;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionEvent it) {
                        DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                        if (dialogPanel != null) {
                            dialogPanel.apply();
                        }
                        ClangdIndexerPanel.runIndexerCommand$default(this.this$0, this.$project, this.$appConsoleView, "reindex", null, 8, null);
                    }
                });
                $this$invoke_u24lambda_u249.button("Cancel", (Function1)new Function1<ActionEvent, Unit>(clangdIndexerPanel, object2, consoleView){
                    final /* synthetic */ ClangdIndexerPanel this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ ConsoleView $appConsoleView;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$appConsoleView = $appConsoleView;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionEvent it) {
                        DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                        if (dialogPanel != null) {
                            dialogPanel.apply();
                        }
                        ClangdIndexerPanel.runIndexerCommand$default(this.this$0, this.$project, this.$appConsoleView, "cancel", null, 8, null);
                    }
                });
                CellBuilder it22 = object = $this$invoke_u24lambda_u249.button("Pause", (Function1)new Function1<ActionEvent, Unit>(clangdIndexerPanel, object2, consoleView){
                    final /* synthetic */ ClangdIndexerPanel this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ ConsoleView $appConsoleView;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$appConsoleView = $appConsoleView;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionEvent it) {
                        DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                        if (dialogPanel != null) {
                            dialogPanel.apply();
                        }
                        JButton jButton = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getPauseButton();
                        boolean isUnpause = Intrinsics.areEqual((Object)(jButton != null ? jButton.getText() : null), (Object)"Unpause");
                        ClangdIndexerPanel.runIndexerCommand$default(this.this$0, this.$project, this.$appConsoleView, isUnpause ? "unpause" : "pause", null, 8, null).thenAccept(arg_0 -> createAppLog.appPanel.1.1.5.invoke$lambda$0((Function1)new Function1<Boolean, Unit>(this.this$0, isUnpause){
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ boolean $isUnpause;
                            {
                                this.this$0 = $receiver;
                                this.$isUnpause = $isUnpause;
                                super(1);
                            }

                            public final void invoke(Boolean it) {
                                if (it.booleanValue()) {
                                    Function0 edt2 = (Function0)new Function0<Unit>(this.this$0, this.$isUnpause){
                                        final /* synthetic */ ClangdIndexerPanel this$0;
                                        final /* synthetic */ boolean $isUnpause;
                                        {
                                            this.this$0 = $receiver;
                                            this.$isUnpause = $isUnpause;
                                            super(0);
                                        }

                                        public final void invoke() {
                                            JButton jButton = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getPauseButton();
                                            if (jButton != null) {
                                                jButton.setText(this.$isUnpause ? "Pause" : "Unpause");
                                            }
                                        }
                                    };
                                    ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> createAppLog.appPanel.1.1.1.invoke$lambda$0(edt2));
                                }
                            }

                            private static final void invoke$lambda$0(Function0 $tmp0) {
                                $tmp0.invoke();
                            }
                        }, arg_0));
                    }

                    private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                        $tmp0.invoke(p0);
                    }
                });
                boolean bl2 = false;
                ClangdIndexerPanel.access$getIndexAppState$p(clangdIndexerPanel).setPauseButton((JButton)it22.getComponent());
                $this$invoke_u24lambda_u249.button("Custom", (Function1)new Function1<ActionEvent, Unit>(object2){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionEvent it) {
                        new ClangIndexerCustomCommandDialog(this.$project).show();
                    }
                });
                object = "Skip function bodies";
                boolean it22 = ClangdSettings.getInstance(object2).getIndexerSkipBodies();
                String comment$iv = null;
                boolean $i$f$checkBox = false;
                CellKt.applyToComponent((CellBuilder)((Cell)$this$invoke_u24lambda_u249).checkBox(text$iv, isSelected$iv, comment$iv), (Function1)((Function1)new Function1<JBCheckBox, Unit>($this$invoke_u24lambda_u249, clangdIndexerPanel, object2, consoleView){
                    final /* synthetic */ InnerCell $this_cell$inlined;
                    final /* synthetic */ ClangdIndexerPanel this$0;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ ConsoleView $appConsoleView$inlined;
                    {
                        this.$this_cell$inlined = innerCell;
                        this.this$0 = clangdIndexerPanel;
                        this.$project$inlined = project;
                        this.$appConsoleView$inlined = consoleView;
                        super(1);
                    }

                    public final void invoke(@NotNull JBCheckBox $this$applyToComponent) {
                        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                        $this$applyToComponent.addActionListener(new ActionListener($this$applyToComponent, this.$this_cell$inlined, this.this$0, this.$project$inlined, this.$appConsoleView$inlined){
                            final /* synthetic */ JBCheckBox $this_applyToComponent;
                            final /* synthetic */ InnerCell $this_cell$inlined;
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project$inlined;
                            final /* synthetic */ ConsoleView $appConsoleView$inlined;
                            {
                                this.$this_applyToComponent = $this_applyToComponent;
                                this.$this_cell$inlined = innerCell;
                                this.this$0 = clangdIndexerPanel;
                                this.$project$inlined = project;
                                this.$appConsoleView$inlined = consoleView;
                            }

                            public final void actionPerformed(ActionEvent it) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                JCheckBox cb = (JCheckBox)this.$this_applyToComponent;
                                boolean bl = false;
                                InnerCell $this$invoke_u24lambda_u249_u24lambda_u242_u24lambda_u241 = this.$this_cell$inlined;
                                boolean bl2 = false;
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                boolean newSkipBodies = !ClangdSettings.getInstance(this.$project$inlined).getIndexerSkipBodies();
                                ClangdSettings.getInstance(this.$project$inlined).setIndexerSkipBodies(newSkipBodies);
                                Function1 function1 = (Function1)new Function1<Boolean, Unit>(this.$project$inlined, newSkipBodies, cb){
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ boolean $newSkipBodies;
                                    final /* synthetic */ JCheckBox $cb;
                                    {
                                        this.$project = $project;
                                        this.$newSkipBodies = $newSkipBodies;
                                        this.$cb = $cb;
                                        super(1);
                                    }

                                    public final void invoke(Boolean it) {
                                        if (!it.booleanValue()) {
                                            ClangdSettings.getInstance(this.$project).setIndexerSkipBodies(!this.$newSkipBodies);
                                            this.$cb.getModel().setSelected(!this.$newSkipBodies);
                                        }
                                    }
                                };
                                ClangdIndexerPanel.access$updateSettings(this.this$0, this.$project$inlined, this.$appConsoleView$inlined).thenAccept(new Consumer(function1){
                                    private final /* synthetic */ Function1 function;
                                    {
                                        this.function = function;
                                    }

                                    public final /* synthetic */ void accept(Object p0) {
                                        this.function.invoke(p0);
                                    }
                                });
                            }
                        });
                    }
                }));
                text$iv = "Skip implicit instantiations";
                isSelected$iv = ClangdSettings.getInstance(object2).getIndexerSkipImplicitInstantiations();
                comment$iv = null;
                $i$f$checkBox = false;
                CellKt.applyToComponent((CellBuilder)((Cell)$this$invoke_u24lambda_u249).checkBox(text$iv, isSelected$iv, comment$iv), (Function1)((Function1)new Function1<JBCheckBox, Unit>($this$invoke_u24lambda_u249, clangdIndexerPanel, object2, consoleView){
                    final /* synthetic */ InnerCell $this_cell$inlined;
                    final /* synthetic */ ClangdIndexerPanel this$0;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ ConsoleView $appConsoleView$inlined;
                    {
                        this.$this_cell$inlined = innerCell;
                        this.this$0 = clangdIndexerPanel;
                        this.$project$inlined = project;
                        this.$appConsoleView$inlined = consoleView;
                        super(1);
                    }

                    public final void invoke(@NotNull JBCheckBox $this$applyToComponent) {
                        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                        $this$applyToComponent.addActionListener(new ActionListener($this$applyToComponent, this.$this_cell$inlined, this.this$0, this.$project$inlined, this.$appConsoleView$inlined){
                            final /* synthetic */ JBCheckBox $this_applyToComponent;
                            final /* synthetic */ InnerCell $this_cell$inlined;
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project$inlined;
                            final /* synthetic */ ConsoleView $appConsoleView$inlined;
                            {
                                this.$this_applyToComponent = $this_applyToComponent;
                                this.$this_cell$inlined = innerCell;
                                this.this$0 = clangdIndexerPanel;
                                this.$project$inlined = project;
                                this.$appConsoleView$inlined = consoleView;
                            }

                            public final void actionPerformed(ActionEvent it) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                JCheckBox cb = (JCheckBox)this.$this_applyToComponent;
                                boolean bl = false;
                                InnerCell $this$invoke_u24lambda_u249_u24lambda_u244_u24lambda_u243 = this.$this_cell$inlined;
                                boolean bl2 = false;
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                boolean newSkipII = !ClangdSettings.getInstance(this.$project$inlined).getIndexerSkipImplicitInstantiations();
                                ClangdSettings.getInstance(this.$project$inlined).setIndexerSkipImplicitInstantiations(newSkipII);
                                Function1 function1 = (Function1)new Function1<Boolean, Unit>(this.$project$inlined, newSkipII, cb){
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ boolean $newSkipII;
                                    final /* synthetic */ JCheckBox $cb;
                                    {
                                        this.$project = $project;
                                        this.$newSkipII = $newSkipII;
                                        this.$cb = $cb;
                                        super(1);
                                    }

                                    public final void invoke(Boolean it) {
                                        if (!it.booleanValue()) {
                                            ClangdSettings.getInstance(this.$project).setIndexerSkipImplicitInstantiations(!this.$newSkipII);
                                            this.$cb.getModel().setSelected(!this.$newSkipII);
                                        }
                                    }
                                };
                                ClangdIndexerPanel.access$updateSettings(this.this$0, this.$project$inlined, this.$appConsoleView$inlined).thenAccept(new /* invalid duplicate definition of identical inner class */);
                            }
                        });
                    }
                }));
                text$iv = "Deprioritize update";
                isSelected$iv = ClangdSettings.getInstance(object2).getIndexerRestrictUpdatingThreads();
                comment$iv = null;
                $i$f$checkBox = false;
                CellKt.applyToComponent((CellBuilder)((Cell)$this$invoke_u24lambda_u249).checkBox(text$iv, isSelected$iv, comment$iv), (Function1)((Function1)new Function1<JBCheckBox, Unit>($this$invoke_u24lambda_u249, clangdIndexerPanel, object2, consoleView){
                    final /* synthetic */ InnerCell $this_cell$inlined;
                    final /* synthetic */ ClangdIndexerPanel this$0;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ ConsoleView $appConsoleView$inlined;
                    {
                        this.$this_cell$inlined = innerCell;
                        this.this$0 = clangdIndexerPanel;
                        this.$project$inlined = project;
                        this.$appConsoleView$inlined = consoleView;
                        super(1);
                    }

                    public final void invoke(@NotNull JBCheckBox $this$applyToComponent) {
                        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                        $this$applyToComponent.addActionListener(new ActionListener($this$applyToComponent, this.$this_cell$inlined, this.this$0, this.$project$inlined, this.$appConsoleView$inlined){
                            final /* synthetic */ JBCheckBox $this_applyToComponent;
                            final /* synthetic */ InnerCell $this_cell$inlined;
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project$inlined;
                            final /* synthetic */ ConsoleView $appConsoleView$inlined;
                            {
                                this.$this_applyToComponent = $this_applyToComponent;
                                this.$this_cell$inlined = innerCell;
                                this.this$0 = clangdIndexerPanel;
                                this.$project$inlined = project;
                                this.$appConsoleView$inlined = consoleView;
                            }

                            public final void actionPerformed(ActionEvent it) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                JCheckBox cb = (JCheckBox)this.$this_applyToComponent;
                                boolean bl = false;
                                InnerCell $this$invoke_u24lambda_u249_u24lambda_u246_u24lambda_u245 = this.$this_cell$inlined;
                                boolean bl2 = false;
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                boolean newRUT = !ClangdSettings.getInstance(this.$project$inlined).getIndexerRestrictUpdatingThreads();
                                ClangdSettings.getInstance(this.$project$inlined).setIndexerRestrictUpdatingThreads(newRUT);
                                Function1 function1 = (Function1)new Function1<Boolean, Unit>(this.$project$inlined, newRUT, cb){
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ boolean $newRUT;
                                    final /* synthetic */ JCheckBox $cb;
                                    {
                                        this.$project = $project;
                                        this.$newRUT = $newRUT;
                                        this.$cb = $cb;
                                        super(1);
                                    }

                                    public final void invoke(Boolean it) {
                                        if (!it.booleanValue()) {
                                            ClangdSettings.getInstance(this.$project).setIndexerRestrictUpdatingThreads(!this.$newRUT);
                                            this.$cb.getModel().setSelected(!this.$newRUT);
                                        }
                                    }
                                };
                                ClangdIndexerPanel.access$updateSettings(this.this$0, this.$project$inlined, this.$appConsoleView$inlined).thenAccept(new /* invalid duplicate definition of identical inner class */);
                            }
                        });
                    }
                }));
                text$iv = "Show debug messages";
                isSelected$iv = ClangdSettings.getInstance(object2).getIndexerShowDebugMessages();
                comment$iv = null;
                $i$f$checkBox = false;
                CellKt.applyToComponent((CellBuilder)((Cell)$this$invoke_u24lambda_u249).checkBox(text$iv, isSelected$iv, comment$iv), (Function1)((Function1)new Function1<JBCheckBox, Unit>($this$invoke_u24lambda_u249, clangdIndexerPanel, object2, consoleView){
                    final /* synthetic */ InnerCell $this_cell$inlined;
                    final /* synthetic */ ClangdIndexerPanel this$0;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ ConsoleView $appConsoleView$inlined;
                    {
                        this.$this_cell$inlined = innerCell;
                        this.this$0 = clangdIndexerPanel;
                        this.$project$inlined = project;
                        this.$appConsoleView$inlined = consoleView;
                        super(1);
                    }

                    public final void invoke(@NotNull JBCheckBox $this$applyToComponent) {
                        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                        $this$applyToComponent.addActionListener(new ActionListener($this$applyToComponent, this.$this_cell$inlined, this.this$0, this.$project$inlined, this.$appConsoleView$inlined){
                            final /* synthetic */ JBCheckBox $this_applyToComponent;
                            final /* synthetic */ InnerCell $this_cell$inlined;
                            final /* synthetic */ ClangdIndexerPanel this$0;
                            final /* synthetic */ Project $project$inlined;
                            final /* synthetic */ ConsoleView $appConsoleView$inlined;
                            {
                                this.$this_applyToComponent = $this_applyToComponent;
                                this.$this_cell$inlined = innerCell;
                                this.this$0 = clangdIndexerPanel;
                                this.$project$inlined = project;
                                this.$appConsoleView$inlined = consoleView;
                            }

                            public final void actionPerformed(ActionEvent it) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                JCheckBox cfr_ignored_0 = (JCheckBox)this.$this_applyToComponent;
                                boolean bl = false;
                                InnerCell $this$invoke_u24lambda_u249_u24lambda_u248_u24lambda_u247 = this.$this_cell$inlined;
                                boolean bl2 = false;
                                DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexAppState$p(this.this$0).getAppPanel();
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                boolean newShowDebugMessages = !ClangdSettings.getInstance(this.$project$inlined).getIndexerShowDebugMessages();
                                ClangdSettings.getInstance(this.$project$inlined).setIndexerShowDebugMessages(newShowDebugMessages);
                                ClangdIndexerPanel.access$updateSettings(this.this$0, this.$project$inlined, this.$appConsoleView$inlined);
                            }
                        });
                    }
                }));
                $this$row.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
                object2 = this.$indexingThreadsModel;
                isVerticalFlow$iv = false;
                isFullWidth$iv = false;
                boolean $i$f$cell2 = false;
                $this$row.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$invoke_u24lambda_u2410 = new InnerCell((Cell)$this$row);
                boolean bl3 = false;
                Cell.label$default((Cell)((Cell)$this$invoke_u24lambda_u2410), (String)"Indexing threads:", null, null, (boolean)false, (int)14, null);
                Cell.comboBox$default((Cell)((Cell)$this$invoke_u24lambda_u2410), (ComboBoxModel)((ComboBoxModel)object2), (Function0)((Function0)new Function0<Integer>((DefaultComboBoxModel<Integer>)object2){
                    final /* synthetic */ DefaultComboBoxModel<Integer> $indexingThreadsModel;
                    {
                        this.$indexingThreadsModel = $indexingThreadsModel;
                        super(0);
                    }

                    @Nullable
                    public final Integer invoke() {
                        Object object = this.$indexingThreadsModel.getSelectedItem();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                        return (Integer)object;
                    }
                }), (Function1)((Function1)new Function1<Integer, Unit>((DefaultComboBoxModel<Integer>)object2){
                    final /* synthetic */ DefaultComboBoxModel<Integer> $indexingThreadsModel;
                    {
                        this.$indexingThreadsModel = $indexingThreadsModel;
                        super(1);
                    }

                    public final void invoke(@Nullable Integer it) {
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.Int");
                        this.$indexingThreadsModel.setSelectedItem(it);
                    }
                }), null, (int)8, null);
                $this$row.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
                object2 = this.$modulesCacheModel;
                isVerticalFlow$iv = false;
                isFullWidth$iv = false;
                $i$f$cell2 = false;
                $this$row.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$invoke_u24lambda_u2411 = new InnerCell((Cell)$this$row);
                boolean bl4 = false;
                Cell.label$default((Cell)((Cell)$this$invoke_u24lambda_u2411), (String)"Modules cache:", null, null, (boolean)false, (int)14, null);
                Cell.comboBox$default((Cell)((Cell)$this$invoke_u24lambda_u2411), (ComboBoxModel)((ComboBoxModel)object2), (Function0)((Function0)new Function0<Integer>((DefaultComboBoxModel<Integer>)object2){
                    final /* synthetic */ DefaultComboBoxModel<Integer> $modulesCacheModel;
                    {
                        this.$modulesCacheModel = $modulesCacheModel;
                        super(0);
                    }

                    @Nullable
                    public final Integer invoke() {
                        Object object = this.$modulesCacheModel.getSelectedItem();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                        return (Integer)object;
                    }
                }), (Function1)((Function1)new Function1<Integer, Unit>((DefaultComboBoxModel<Integer>)object2){
                    final /* synthetic */ DefaultComboBoxModel<Integer> $modulesCacheModel;
                    {
                        this.$modulesCacheModel = $modulesCacheModel;
                        super(1);
                    }

                    public final void invoke(@Nullable Integer it) {
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.Int");
                        this.$modulesCacheModel.setSelectedItem(it);
                    }
                }), null, (int)8, null);
                $this$row.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
            }
        }), (int)3, null);
        RowBuilder.row$default((RowBuilder)((RowBuilder)$this$createAppLog_u24lambda_u241), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(appConsoleView){
            final /* synthetic */ ConsoleView $appConsoleView;
            {
                this.$appConsoleView = $appConsoleView;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                CCFlags[] cCFlagsArray = new CCFlags[]{$this$row.getGrow(), $this$row.getPush()};
                $this$row.component(this.$appConsoleView.getComponent()).constraints(cCFlagsArray);
            }
        }), (int)3, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        Color color = bgcolor$iv = Registry.getColor((String)"ui.kotlin.ui.dsl.deprecated.panel.color", null);
        if (color != null) {
            Color it$iv = color;
            boolean bl2 = false;
            panel$iv.setBackground(it$iv);
        }
        builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        DialogPanel appPanel2 = panel$iv;
        return new Pair((Object)appPanel2, (Object)appConsoleView);
    }

    private final DialogPanel createIndexViewer(Project project) {
        Color bgcolor$iv;
        LayoutBuilder builder$iv;
        JBTextArea textArea = new JBTextArea((Document)new DefaultStyledDocument());
        textArea.setEditable(false);
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$createIndexViewer_u24lambda_u242 = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.row$default((RowBuilder)((RowBuilder)$this$createIndexViewer_u24lambda_u242), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this, project, textArea){
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ JBTextArea $textArea;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$textArea = $textArea;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                CCFlags[] cCFlagsArray = new CCFlags[]{$this$row.getGrowX(), CCFlags.pushX};
                Cell.textField$default((Cell)((Cell)$this$row), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(ClangdIndexerPanel.access$getIndexViewerState$p(this.this$0)){

                    @Nullable
                    public Object get() {
                        return ((IndexViewerState)this.receiver).getQuery();
                    }

                    public void set(@Nullable Object value) {
                        ((IndexViewerState)this.receiver).setQuery((String)value);
                    }
                }), null, (int)2, null).constraints(cCFlagsArray).focused();
                Cell.checkBox$default((Cell)((Cell)$this$row), (String)"Only CLion Index", (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(ClangdIndexerPanel.access$getIndexViewerState$p(this.this$0)){

                    @Nullable
                    public Object get() {
                        return ((IndexViewerState)this.receiver).getOnlyCLionIndex();
                    }

                    public void set(@Nullable Object value) {
                        ((IndexViewerState)this.receiver).setOnlyCLionIndex((Boolean)value);
                    }
                }), null, (int)4, null);
                $this$row.button("Query", (Function1)new Function1<ActionEvent, Unit>(this.this$0, this.$project, this.$textArea){
                    final /* synthetic */ ClangdIndexerPanel this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ JBTextArea $textArea;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$textArea = $textArea;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionEvent it) {
                        DialogPanel dialogPanel = ClangdIndexerPanel.access$getIndexViewerState$p(this.this$0).getIndexViewer();
                        if (dialogPanel != null) {
                            dialogPanel.apply();
                        }
                        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(this.$project);
                        if (service.isDummy()) {
                            this.$textArea.setText("Service is not started yet!");
                            return;
                        }
                        CompletableFuture<List<CLionSymbolInformation>> symbolsFuture = service.getSymbols(ClangdIndexerPanel.access$getIndexViewerState$p(this.this$0).getQuery(), ClangdIndexerPanel.access$getIndexViewerState$p(this.this$0).getOnlyCLionIndex());
                        List symbols = (List)CidrConcurrentUtilsKt.waitCancelAware((Future)symbolsFuture, (String)"workspace/symbols");
                        Collection collection = symbols;
                        if (collection == null || collection.isEmpty()) {
                            this.$textArea.setText("No symbols found!");
                            return;
                        }
                        StringBuilder sb = new StringBuilder();
                        Iterator<E> iterator = symbols.iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            int counter = n++;
                            CLionSymbolInformation symbol = (CLionSymbolInformation)((Object)iterator.next());
                            sb.append(counter + 1 + ". " + symbol + "\n");
                        }
                        this.$textArea.setText(sb.toString());
                    }
                });
            }
        }), (int)3, null);
        RowBuilder.row$default((RowBuilder)((RowBuilder)$this$createIndexViewer_u24lambda_u242), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(textArea){
            final /* synthetic */ JBTextArea $textArea;
            {
                this.$textArea = $textArea;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                $this$row.scrollPane((Component)this.$textArea);
            }
        }), (int)3, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        Color color = bgcolor$iv = Registry.getColor((String)"ui.kotlin.ui.dsl.deprecated.panel.color", null);
        if (color != null) {
            Color it$iv = color;
            boolean bl2 = false;
            panel$iv.setBackground(it$iv);
        }
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        return panel$iv;
    }

    private final CompletableFuture<Boolean> updateSettings(Project project, ConsoleView console) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!this.actWithService(project, console, (Function1<? super ClangdIndexerService, Unit>)((Function1)new Function1<ClangdIndexerService, Unit>(this, project, console, result){
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ConsoleView $console;
            final /* synthetic */ CompletableFuture<Boolean> $result;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$console = $console;
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull ClangdIndexerService it) {
                it.notifySettingsChanged(ClangdIndexerPanel.access$createIndexerParams(this.this$0, this.$project, it.getClangdModulesPath())).whenComplete((arg_0, arg_1) -> updateSettings.1.invoke$lambda$0((Function2)new Function2<Boolean, Throwable, Unit>(this.$console, this.$result){
                    final /* synthetic */ ConsoleView $console;
                    final /* synthetic */ CompletableFuture<Boolean> $result;
                    {
                        this.$console = $console;
                        this.$result = $result;
                        super(2);
                    }

                    public final void invoke(Boolean res, Throwable ex) {
                        if (ex != null || res != null && !res.booleanValue()) {
                            this.$console.print("setMode: failed\n", ConsoleViewContentType.NORMAL_OUTPUT);
                            this.$result.complete(false);
                        } else {
                            this.$console.print("setMode: success\n", ConsoleViewContentType.NORMAL_OUTPUT);
                            this.$result.complete(true);
                        }
                    }
                }, arg_0, arg_1));
            }

            private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                $tmp0.invoke(p0, p1);
            }
        }))) {
            result.complete(false);
        }
        return result;
    }

    private final ClionIndexerParams createIndexerParams(Project project, String clangdModulesPath) {
        ClangdSettings settings = ClangdSettings.getInstance(project);
        boolean skipBodies = settings.getIndexerSkipBodies();
        boolean skipII = settings.getIndexerSkipImplicitInstantiations();
        int modulesCacheMb = settings.getIndexerModulesCacheMb();
        int indexingThreadsNum = settings.getIndexingThreadsNum();
        boolean restrictUpdatingThreads = settings.getIndexerRestrictUpdatingThreads();
        boolean showDebugMessages = settings.getIndexerShowDebugMessages();
        return new ClionIndexerParams(clangdModulesPath, skipBodies, skipII, modulesCacheMb, indexingThreadsNum, restrictUpdatingThreads, showDebugMessages);
    }

    private final CompletableFuture<Boolean> runIndexerCommand(Project project, ConsoleView console, String command, String arguments) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!this.actWithService(project, console, (Function1<? super ClangdIndexerService, Unit>)((Function1)new Function1<ClangdIndexerService, Unit>(command, arguments, console, result){
            final /* synthetic */ String $command;
            final /* synthetic */ String $arguments;
            final /* synthetic */ ConsoleView $console;
            final /* synthetic */ CompletableFuture<Boolean> $result;
            {
                this.$command = $command;
                this.$arguments = $arguments;
                this.$console = $console;
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull ClangdIndexerService it) {
                it.executeCommand(this.$command, this.$arguments).whenComplete((arg_0, arg_1) -> runIndexerCommand.1.invoke$lambda$0((Function2)new Function2<Boolean, Throwable, Unit>(this.$console, this.$command, this.$result){
                    final /* synthetic */ ConsoleView $console;
                    final /* synthetic */ String $command;
                    final /* synthetic */ CompletableFuture<Boolean> $result;
                    {
                        this.$console = $console;
                        this.$command = $command;
                        this.$result = $result;
                        super(2);
                    }

                    public final void invoke(Boolean res, Throwable ex) {
                        if (ex != null || res != null && !res.booleanValue()) {
                            this.$console.print(this.$command + ": failed\n", ConsoleViewContentType.NORMAL_OUTPUT);
                            this.$result.complete(false);
                        } else {
                            this.$console.print(this.$command + ": success\n", ConsoleViewContentType.NORMAL_OUTPUT);
                            this.$result.complete(true);
                        }
                    }
                }, arg_0, arg_1));
            }

            private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                $tmp0.invoke(p0, p1);
            }
        }))) {
            result.complete(false);
        }
        return result;
    }

    static /* synthetic */ CompletableFuture runIndexerCommand$default(ClangdIndexerPanel clangdIndexerPanel, Project project, ConsoleView consoleView, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "";
        }
        return clangdIndexerPanel.runIndexerCommand(project, consoleView, string, string2);
    }

    private final boolean actWithService(Project project, ConsoleView console, Function1<? super ClangdIndexerService, Unit> block) {
        Object object = ClangLanguageServiceProvider.getProvider(project);
        if (object == null || (object = object.getIfStartedIndexer()) == null) {
            return false;
        }
        Object service = object;
        if (service.isDummy()) {
            console.print("Service is not started yet!\n", ConsoleViewContentType.NORMAL_OUTPUT);
            return false;
        }
        if (!(service instanceof ClangdIndexerService)) {
            console.print("Service is not an instance of " + ClangdIndexerService.class.getSimpleName() + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
            return false;
        }
        block.invoke(service);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void connectToService(ClangLanguageService service, ConsoleView lspView, ConsoleView appView) {
        if (service == null || service.isDummy()) {
            return;
        }
        if (service instanceof ClangdIndexerService) {
            List<String> list;
            Object object = ((ClangdIndexerService)service).getCopyOfAppLog();
            Iterable<String> it = object;
            boolean bl = false;
            List<String> list2 = list = !((Collection)it).isEmpty() ? object : null;
            if (list != null) {
                void $this$reduce$iv;
                it = list;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void right;
                    String string = (String)iterator$iv.next();
                    String left = (String)accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = left + "\n" + (String)right;
                }
                object = (String)accumulator$iv;
                if (object != null) {
                    Object object2;
                    Object object3;
                    Object it2 = object3 = object;
                    boolean bl3 = false;
                    Object object4 = object2 = ((CharSequence)it2).length() > 0 ? object3 : null;
                    if (object2 != null) {
                        it2 = object3 = object2;
                        boolean bl4 = false;
                        ClangdIndexerPanelKt.access$printConsole(appView, (String)it2);
                    }
                }
            }
        }
        service.getMessageBus().connect((Disposable)this).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(lspView, appView){
            private boolean indexStartedCame;
            private int lastReportedPercent;
            final /* synthetic */ ConsoleView $lspView;
            final /* synthetic */ ConsoleView $appView;
            {
                this.$lspView = $lspView;
                this.$appView = $appView;
                this.lastReportedPercent = -1;
            }

            public final boolean getIndexStartedCame() {
                return this.indexStartedCame;
            }

            public final void setIndexStartedCame(boolean bl) {
                this.indexStartedCame = bl;
            }

            public final int getLastReportedPercent() {
                return this.lastReportedPercent;
            }

            public final void setLastReportedPercent(int n) {
                this.lastReportedPercent = n;
            }

            public void onMessage(@NotNull String contents, boolean incoming) {
                Function0 edt2 = (Function0)new Function0<Unit>(incoming, this.$lspView, contents){
                    final /* synthetic */ boolean $incoming;
                    final /* synthetic */ ConsoleView $lspView;
                    final /* synthetic */ String $contents;
                    {
                        this.$incoming = $incoming;
                        this.$lspView = $lspView;
                        this.$contents = $contents;
                        super(0);
                    }

                    public final void invoke() {
                        String string = ClangdIndexerPanelKt.access$getDATE_FORMAT$p().format(System.currentTimeMillis());
                        Intrinsics.checkNotNull((Object)string);
                        String linkText = string + " " + (this.$incoming ? "-->" : "<--");
                        this.$lspView.printHyperlink(linkText, arg_0 -> connectToService.onMessage.edt.1.invoke$lambda$0(this.$contents, linkText, arg_0));
                        this.$lspView.print(" ", ConsoleViewContentType.NORMAL_OUTPUT);
                        this.$lspView.print(ClangdIndexerPanelKt.access$toOneLine(this.$contents), ConsoleViewContentType.NORMAL_OUTPUT);
                        this.$lspView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                    }

                    private static final void invoke$lambda$0(String $contents, String $linkText, Project it) {
                        ClangdIndexerPanelKt.access$showJsonInEditor(it, $contents, $linkText);
                    }
                };
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> connectToService.5.onMessage$lambda$0(edt2));
            }

            public void onIndexingStarted() {
                this.indexStartedCame = true;
                this.lastReportedPercent = -1;
            }

            public void onIndexingProgress(int processed, int total) {
                int newPercent;
                if (this.indexStartedCame) {
                    ClangdIndexerPanelKt.access$printConsole(this.$appView, "Indexing started: " + total + " TUs to process");
                    this.indexStartedCame = false;
                }
                if ((newPercent = (int)((double)processed / (double)total * (double)100)) != this.lastReportedPercent) {
                    this.lastReportedPercent = newPercent;
                    ClangdIndexerPanelKt.access$printConsole(this.$appView, "Progress: " + newPercent + "%");
                }
            }

            public void onIndexingFinished(@NotNull List<String> deletedSymbolsPaths, @NotNull String path) {
                ClangdIndexerPanelKt.access$printConsole(this.$appView, "Indexing finished! " + deletedSymbolsPaths.size() + " deleted (" + path + ")");
            }

            public void onIndexingMessage(@NotNull String message) {
                ClangdIndexerPanelKt.access$printConsole(this.$appView, message);
            }

            private static final void onMessage$lambda$0(Function0 $tmp0) {
                $tmp0.invoke();
            }
        });
    }

    private static final Filter.Result createLspLog$lambda$0(Pattern $methodPattern, TextAttributes $methodHighlightAttrs, String line, int length) {
        Filter.Result result;
        Matcher matcher = $methodPattern.matcher(line);
        int lineStartOffset = length - line.length();
        if (matcher.find()) {
            int groupStart = lineStartOffset + matcher.start(1);
            int groupEnd = lineStartOffset + matcher.end(1);
            result = new Filter.Result(groupStart, groupEnd, null, $methodHighlightAttrs);
        } else {
            result = null;
        }
        return result;
    }

    public static final /* synthetic */ CompletableFuture access$updateSettings(ClangdIndexerPanel $this, Project project, ConsoleView console) {
        return $this.updateSettings(project, console);
    }

    public static final /* synthetic */ ClionIndexerParams access$createIndexerParams(ClangdIndexerPanel $this, Project project, String clangdModulesPath) {
        return $this.createIndexerParams(project, clangdModulesPath);
    }

    public static final /* synthetic */ IndexAppState access$getIndexAppState$p(ClangdIndexerPanel $this) {
        return $this.indexAppState;
    }

    public static final /* synthetic */ IndexViewerState access$getIndexViewerState$p(ClangdIndexerPanel $this) {
        return $this.indexViewerState;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdIndexerPanel$IndexViewerState;", "", "query", "", "onlyCLionIndex", "", "indexViewer", "Lcom/intellij/openapi/ui/DialogPanel;", "(Ljava/lang/String;ZLcom/intellij/openapi/ui/DialogPanel;)V", "getIndexViewer", "()Lcom/intellij/openapi/ui/DialogPanel;", "setIndexViewer", "(Lcom/intellij/openapi/ui/DialogPanel;)V", "getOnlyCLionIndex", "()Z", "setOnlyCLionIndex", "(Z)V", "getQuery", "()Ljava/lang/String;", "setQuery", "(Ljava/lang/String;)V", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.c.clangd"})
    public static final class IndexViewerState {
        @NotNull
        private String query;
        private boolean onlyCLionIndex;
        @Nullable
        private DialogPanel indexViewer;

        public IndexViewerState(@NotNull String query, boolean onlyCLionIndex, @Nullable DialogPanel indexViewer) {
            this.query = query;
            this.onlyCLionIndex = onlyCLionIndex;
            this.indexViewer = indexViewer;
        }

        public /* synthetic */ IndexViewerState(String string, boolean bl, DialogPanel dialogPanel, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                dialogPanel = null;
            }
            this(string, bl, dialogPanel);
        }

        @NotNull
        public final String getQuery() {
            return this.query;
        }

        public final void setQuery(@NotNull String string) {
            this.query = string;
        }

        public final boolean getOnlyCLionIndex() {
            return this.onlyCLionIndex;
        }

        public final void setOnlyCLionIndex(boolean bl) {
            this.onlyCLionIndex = bl;
        }

        @Nullable
        public final DialogPanel getIndexViewer() {
            return this.indexViewer;
        }

        public final void setIndexViewer(@Nullable DialogPanel dialogPanel) {
            this.indexViewer = dialogPanel;
        }

        @NotNull
        public final String component1() {
            return this.query;
        }

        public final boolean component2() {
            return this.onlyCLionIndex;
        }

        @Nullable
        public final DialogPanel component3() {
            return this.indexViewer;
        }

        @NotNull
        public final IndexViewerState copy(@NotNull String query, boolean onlyCLionIndex, @Nullable DialogPanel indexViewer) {
            return new IndexViewerState(query, onlyCLionIndex, indexViewer);
        }

        public static /* synthetic */ IndexViewerState copy$default(IndexViewerState indexViewerState, String string, boolean bl, DialogPanel dialogPanel, int n, Object object) {
            if ((n & 1) != 0) {
                string = indexViewerState.query;
            }
            if ((n & 2) != 0) {
                bl = indexViewerState.onlyCLionIndex;
            }
            if ((n & 4) != 0) {
                dialogPanel = indexViewerState.indexViewer;
            }
            return indexViewerState.copy(string, bl, dialogPanel);
        }

        @NotNull
        public String toString() {
            return "IndexViewerState(query=" + this.query + ", onlyCLionIndex=" + this.onlyCLionIndex + ", indexViewer=" + this.indexViewer + ")";
        }

        public int hashCode() {
            int result = this.query.hashCode();
            int n = this.onlyCLionIndex ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + (this.indexViewer == null ? 0 : this.indexViewer.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndexViewerState)) {
                return false;
            }
            IndexViewerState indexViewerState = (IndexViewerState)other;
            if (!Intrinsics.areEqual((Object)this.query, (Object)indexViewerState.query)) {
                return false;
            }
            if (this.onlyCLionIndex != indexViewerState.onlyCLionIndex) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.indexViewer, (Object)indexViewerState.indexViewer);
        }

        public IndexViewerState() {
            this(null, false, null, 7, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J7\u0010\u001f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\tH\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdIndexerPanel$IndexAppState;", "", "pauseButton", "Ljavax/swing/JButton;", "appConsoleView", "Lcom/intellij/execution/ui/ConsoleView;", "appPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "indexerModulesCacheMb", "", "(Ljavax/swing/JButton;Lcom/intellij/execution/ui/ConsoleView;Lcom/intellij/openapi/ui/DialogPanel;I)V", "getAppConsoleView", "()Lcom/intellij/execution/ui/ConsoleView;", "setAppConsoleView", "(Lcom/intellij/execution/ui/ConsoleView;)V", "getAppPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "setAppPanel", "(Lcom/intellij/openapi/ui/DialogPanel;)V", "getIndexerModulesCacheMb", "()I", "setIndexerModulesCacheMb", "(I)V", "getPauseButton", "()Ljavax/swing/JButton;", "setPauseButton", "(Ljavax/swing/JButton;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.c.clangd"})
    public static final class IndexAppState {
        @Nullable
        private JButton pauseButton;
        @Nullable
        private ConsoleView appConsoleView;
        @Nullable
        private DialogPanel appPanel;
        private int indexerModulesCacheMb;

        public IndexAppState(@Nullable JButton pauseButton, @Nullable ConsoleView appConsoleView, @Nullable DialogPanel appPanel2, int indexerModulesCacheMb) {
            this.pauseButton = pauseButton;
            this.appConsoleView = appConsoleView;
            this.appPanel = appPanel2;
            this.indexerModulesCacheMb = indexerModulesCacheMb;
        }

        public /* synthetic */ IndexAppState(JButton jButton, ConsoleView consoleView, DialogPanel dialogPanel, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                jButton = null;
            }
            if ((n2 & 2) != 0) {
                consoleView = null;
            }
            if ((n2 & 4) != 0) {
                dialogPanel = null;
            }
            if ((n2 & 8) != 0) {
                n = 4000;
            }
            this(jButton, consoleView, dialogPanel, n);
        }

        @Nullable
        public final JButton getPauseButton() {
            return this.pauseButton;
        }

        public final void setPauseButton(@Nullable JButton jButton) {
            this.pauseButton = jButton;
        }

        @Nullable
        public final ConsoleView getAppConsoleView() {
            return this.appConsoleView;
        }

        public final void setAppConsoleView(@Nullable ConsoleView consoleView) {
            this.appConsoleView = consoleView;
        }

        @Nullable
        public final DialogPanel getAppPanel() {
            return this.appPanel;
        }

        public final void setAppPanel(@Nullable DialogPanel dialogPanel) {
            this.appPanel = dialogPanel;
        }

        public final int getIndexerModulesCacheMb() {
            return this.indexerModulesCacheMb;
        }

        public final void setIndexerModulesCacheMb(int n) {
            this.indexerModulesCacheMb = n;
        }

        @Nullable
        public final JButton component1() {
            return this.pauseButton;
        }

        @Nullable
        public final ConsoleView component2() {
            return this.appConsoleView;
        }

        @Nullable
        public final DialogPanel component3() {
            return this.appPanel;
        }

        public final int component4() {
            return this.indexerModulesCacheMb;
        }

        @NotNull
        public final IndexAppState copy(@Nullable JButton pauseButton, @Nullable ConsoleView appConsoleView, @Nullable DialogPanel appPanel2, int indexerModulesCacheMb) {
            return new IndexAppState(pauseButton, appConsoleView, appPanel2, indexerModulesCacheMb);
        }

        public static /* synthetic */ IndexAppState copy$default(IndexAppState indexAppState, JButton jButton, ConsoleView consoleView, DialogPanel dialogPanel, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                jButton = indexAppState.pauseButton;
            }
            if ((n2 & 2) != 0) {
                consoleView = indexAppState.appConsoleView;
            }
            if ((n2 & 4) != 0) {
                dialogPanel = indexAppState.appPanel;
            }
            if ((n2 & 8) != 0) {
                n = indexAppState.indexerModulesCacheMb;
            }
            return indexAppState.copy(jButton, consoleView, dialogPanel, n);
        }

        @NotNull
        public String toString() {
            return "IndexAppState(pauseButton=" + this.pauseButton + ", appConsoleView=" + this.appConsoleView + ", appPanel=" + this.appPanel + ", indexerModulesCacheMb=" + this.indexerModulesCacheMb + ")";
        }

        public int hashCode() {
            int result = this.pauseButton == null ? 0 : this.pauseButton.hashCode();
            result = result * 31 + (this.appConsoleView == null ? 0 : this.appConsoleView.hashCode());
            result = result * 31 + (this.appPanel == null ? 0 : this.appPanel.hashCode());
            result = result * 31 + Integer.hashCode(this.indexerModulesCacheMb);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndexAppState)) {
                return false;
            }
            IndexAppState indexAppState = (IndexAppState)other;
            if (!Intrinsics.areEqual((Object)this.pauseButton, (Object)indexAppState.pauseButton)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.appConsoleView, (Object)indexAppState.appConsoleView)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.appPanel, (Object)indexAppState.appPanel)) {
                return false;
            }
            return this.indexerModulesCacheMb == indexAppState.indexerModulesCacheMb;
        }

        public IndexAppState() {
            this(null, null, null, 0, 15, null);
        }
    }
}

