/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.CppModulesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyStatusBarWidgetFactory;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangLanguageServiceStartupActivity
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ClangLanguageServiceStartupActivity.runStartupActivity(project);
    }

    @NotNull
    public static CompletableFuture<Boolean> runStartupActivity(final @NotNull Project project) {
        if (project.isDefault() || project.isDisposed()) {
            return CompletableFuture.completedFuture(false);
        }
        project.getService(CppModulesState.class);
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                result.complete(false);
                return;
            }
            ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(project);
            if (provider2 == null) {
                result.complete(false);
                return;
            }
            if (ClangUtils.isClangdOn(project)) {
                ClangLanguageServiceStartupActivity.initLanguageService(provider2, project).whenComplete((res, ex) -> {
                    if (ex != null) {
                        result.completeExceptionally((Throwable)ex);
                    } else {
                        result.complete(true);
                    }
                });
            } else {
                result.complete(false);
            }
            MessageBusConnection connection = project.getMessageBus().connect();
            connection.subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

                public void profileChanged(@NotNull InspectionProfile profile) {
                    StatusBarWidgetsManager manager = (StatusBarWidgetsManager)project.getService(StatusBarWidgetsManager.class);
                    if (manager != null) {
                        manager.updateWidget(ClangTidyStatusBarWidgetFactory.class);
                    }
                }
            });
            connection.subscribe(OCWorkspaceListener.TOPIC, (Object)new MyClangdWorkspaceListener(project, provider2));
            connection.subscribe(ClangdSettingsListener.TOPIC, (Object)new MyClangdSettingsListener(project, provider2));
            connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyClangdBulkFilesListener(provider2));
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new MyClangdDocumentsListener(project, provider2), (Disposable)project);
            EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new MyClangdEditorsListener(provider2), (Disposable)project);
        });
        return result;
    }

    @NotNull
    private static CompletableFuture<Object> initLanguageService(@NotNull ClangLanguageServiceProvider provider2, @NotNull Project project) {
        final ClangLanguageService service = provider2.getOrStart();
        ClangLanguageService indexer = provider2.getOrStartIndexer();
        CompletableFuture<Object> openFilesFuture = new CompletableFuture<Object>();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project.isDisposed()) {
                openFilesFuture.complete(false);
                return;
            }
            ReadAction.run(() -> {
                ClangLanguageServiceStartupActivity.openAtService(project, service);
                ClangLanguageServiceStartupActivity.openAtService(project, indexer);
            });
            Set<VirtualFile> projectRoots = ClangLanguageServiceStartupActivity.getProjectRoots(project);
            if (!projectRoots.isEmpty()) {
                if (service.isActive() && ClangdBridge.isClangdOnlyMode()) {
                    service.notifySetCDB(projectRoots);
                }
                if (indexer.isActive()) {
                    indexer.notifySetCDB(projectRoots);
                }
            }
            openFilesFuture.complete(true);
        });
        if (!indexer.isDummy()) {
            File symbolsDir;
            File includeGraphFile = Paths.get(service.getClangdModulesPath(), "compilation_graph.txt").toFile();
            if (includeGraphFile.exists()) {
                service.notifyLoadGraph(includeGraphFile.getPath());
            }
            if ((symbolsDir = Paths.get(service.getClangdModulesPath(), "symbols").toFile()).exists()) {
                service.notifyLoadIndex(Collections.emptyList(), symbolsDir.getPath());
            }
            indexer.getMessageBus().connect().subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

                @Override
                public void onIndexingFinished(@NotNull List<String> deletedSymbolsPaths, @NotNull String symbolsDirPath) {
                    service.notifyLoadIndex(deletedSymbolsPaths, symbolsDirPath);
                }

                @Override
                public void onGraphFinished(@NotNull String path) {
                    service.notifyLoadGraph(path);
                }

                @Override
                public void onIndexPartFinished(@NotNull String path) {
                    service.notifyIndexPartFinished(path);
                }
            });
        }
        return openFilesFuture;
    }

    private static Set<VirtualFile> getProjectRoots(@NotNull Project project) {
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        for (OCResolveConfiguration config : OCWorkspace.getInstance((Project)project).getConfigurations()) {
            sources.addAll(config.getSources());
        }
        return sources;
    }

    private static void openAtService(@NotNull Project project, @NotNull ClangLanguageService service) {
        if (project.isDisposed()) {
            return;
        }
        if (!service.isActive()) {
            return;
        }
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            VirtualFile vFile;
            Project editorProject = editor.getProject();
            if (editorProject != project || (vFile = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) continue;
            service.notifyDocumentOpened(vFile, new EditorOpenRequestId(editor));
        }
    }

    private static void stopLanguageService(@NotNull ClangLanguageServiceProvider provider2) {
        provider2.stop();
        provider2.stopIndexer();
    }

    private static class MyClangdWorkspaceListener
    implements OCWorkspaceListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ClangLanguageServiceProvider myProvider;

        private MyClangdWorkspaceListener(@NotNull Project project, @NotNull ClangLanguageServiceProvider provider2) {
            this.myProject = project;
            this.myProvider = provider2;
        }

        public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
            this.selectedResolveConfigurationChanged();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                ClangLanguageService indexer;
                ClangLanguageService service;
                if (this.myProject.isDisposed()) {
                    return;
                }
                if (ClangdBridge.isClangdOnlyMode() && (service = this.myProvider.getIfStarted()) != null) {
                    service.notifySetCDB(ClangLanguageServiceStartupActivity.getProjectRoots(this.myProject));
                }
                if ((indexer = this.myProvider.getIfStartedIndexer()) != null) {
                    indexer.notifySetCDB(ClangLanguageServiceStartupActivity.getProjectRoots(this.myProject));
                }
            });
        }

        public void selectedResolveConfigurationChanged() {
            @Nullable ClangLanguageService langService = this.myProvider.getIfStarted();
            if (langService == null) {
                return;
            }
            String wslMsId = ClangUtils.getCurrentWslMsId(this.myProject);
            if (!langService.getWslMsId().equals(wslMsId)) {
                ClangLanguageServiceStartupActivity.stopLanguageService(this.myProvider);
                ClangLanguageServiceStartupActivity.initLanguageService(this.myProvider, this.myProject);
            }
        }
    }

    private static class MyClangdSettingsListener
    implements ClangdSettingsListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ClangLanguageServiceProvider myProvider;

        MyClangdSettingsListener(@NotNull Project project, @NotNull ClangLanguageServiceProvider provider2) {
            this.myProject = project;
            this.myProvider = provider2;
        }

        @Override
        public void onClangdOnChanged(boolean value) {
            if (ClangUtils.isClangdOn(this.myProject)) {
                ClangLanguageServiceStartupActivity.initLanguageService(this.myProvider, this.myProject);
            } else {
                ClangLanguageServiceStartupActivity.stopLanguageService(this.myProvider);
            }
        }
    }

    private static class MyClangdBulkFilesListener
    implements BulkFileListener {
        @NotNull
        private final ClangLanguageServiceProvider myProvider;

        private MyClangdBulkFilesListener(@NotNull ClangLanguageServiceProvider provider2) {
            this.myProvider = provider2;
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            for (VFileEvent vFileEvent : events) {
                ClangLanguageService indexer;
                VirtualFile file;
                VFileMoveEvent event;
                if (vFileEvent instanceof VFileMoveEvent) {
                    ClangLanguageService indexer2;
                    event = (VFileMoveEvent)vFileEvent;
                    file = event.getFile();
                    String oldUrl = event.getOldParent().getUrl() + "/" + file.getName();
                    String newUrl = file.getUrl();
                    ClangLanguageService service = this.myProvider.getIfStarted();
                    if (service != null) {
                        service.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                    }
                    if ((indexer2 = this.myProvider.getIfStarted()) == null) continue;
                    indexer2.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                    continue;
                }
                if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) {
                    ClangLanguageService indexer3;
                    event = (VFilePropertyChangeEvent)vFileEvent;
                    if (Objects.equals(event.getNewValue(), event.getOldValue())) continue;
                    String newName = (String)event.getNewValue();
                    String newUrl = event.getFile().getUrl();
                    assert (newUrl.endsWith(newName));
                    String oldName = (String)event.getOldValue();
                    String oldUrl = newUrl.substring(0, newUrl.length() - newName.length()) + oldName;
                    ClangLanguageService service = this.myProvider.getIfStarted();
                    if (service != null) {
                        service.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                    }
                    if ((indexer3 = this.myProvider.getIfStartedIndexer()) == null) continue;
                    indexer3.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                    continue;
                }
                if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
                event = (VFileContentChangeEvent)vFileEvent;
                if (!vFileEvent.isFromSave()) continue;
                file = event.getFile();
                ClangLanguageService service = this.myProvider.getIfStarted();
                if (service != null) {
                    service.notifyDocumentSaved(file);
                }
                if ((indexer = this.myProvider.getIfStartedIndexer()) == null) continue;
                indexer.notifyDocumentSaved(file);
            }
        }
    }

    private static class MyClangdDocumentsListener
    implements DocumentListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ClangLanguageServiceProvider myProvider;

        private MyClangdDocumentsListener(@NotNull Project project, @NotNull ClangLanguageServiceProvider provider2) {
            this.myProject = project;
            this.myProvider = provider2;
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            boolean isDocumentSaved;
            VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
            boolean bl = isDocumentSaved = !FileDocumentManager.getInstance().isDocumentUnsaved(event.getDocument());
            if (file != null) {
                ClangLanguageService indexer;
                ClangLanguageService service = this.myProvider.getIfStarted();
                if (service != null) {
                    service.notifyDocumentChanged(file, event);
                    if (isDocumentSaved) {
                        service.notifyDocumentSaved(file);
                    }
                }
                if ((indexer = this.myProvider.getIfStartedIndexer()) != null) {
                    indexer.notifyDocumentChanged(file, event);
                    if (isDocumentSaved) {
                        indexer.notifyDocumentSaved(file);
                    }
                }
            }
        }
    }

    private static class MyClangdEditorsListener
    implements EditorFactoryListener {
        @NotNull
        private final ClangLanguageServiceProvider myProvider;

        private MyClangdEditorsListener(@NotNull ClangLanguageServiceProvider provider2) {
            this.myProvider = provider2;
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument());
            if (file != null) {
                ClangLanguageService indexer;
                ClangLanguageService service = this.myProvider.getIfStarted();
                if (service != null) {
                    service.notifyDocumentOpened(file, new EditorOpenRequestId(event.getEditor()));
                }
                if ((indexer = this.myProvider.getIfStartedIndexer()) != null) {
                    indexer.notifyDocumentOpened(file, new EditorOpenRequestId(event.getEditor()));
                }
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument());
            if (file != null) {
                ClangLanguageService indexer;
                ClangLanguageService service = this.myProvider.getIfStarted();
                if (service != null) {
                    service.notifyDocumentClosed(file, new EditorOpenRequestId(event.getEditor()));
                }
                if ((indexer = this.myProvider.getIfStartedIndexer()) != null) {
                    indexer.notifyDocumentClosed(file, new EditorOpenRequestId(event.getEditor()));
                }
            }
        }
    }
}

