/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.find.TextSearchService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20Module;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.CppModulesState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.OnlyCppSourcesScope;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CppModulesStateImpl
implements CppModulesState,
Disposable {
    private static final Pattern exportModulePattern = Pattern.compile("export\\s+module\\s+\\w+[.\\w+]*\\s*[:\\w+[.\\w+]*]*\\s*;");
    private static final Pattern moduleImplOrInternalPartitionPattern = Pattern.compile("module\\s+\\w+[.\\w+]*\\s*[:\\w+[.\\w+]*]+\\s*;");
    @NotNull
    private final Project myProject;
    @NotNull
    private final QueueProcessor<UpdateEvent> myQueueProcessor = new QueueProcessor(e -> {
        int newSize;
        boolean isTraceEnabled = CidrLog.LOG.isTraceEnabled();
        int prevSize = isTraceEnabled ? this.byPath(modmap -> modmap.size()) : -1;
        e.perform();
        int n = newSize = isTraceEnabled ? this.byPath(modmap -> modmap.size()) : -1;
        if (isTraceEnabled) {
            CidrLog.LOG.trace("C++20 modules scanning: " + e + ", " + prevSize + " -> " + newSize);
        }
    });
    private final HashMap<String, Cpp20Module> myModulesByPath = new HashMap();
    private static final List<String> ALL_STD_CORE_HEADERS = List.of("cstddef", "limits", "cfloat", "cstdint", "new", "typeinfo", "exception", "initializer_list", "csignal", "cstdlib", "stdexcept", "system_error", "utility", "tuple", "optional", "variant", "any", "bitset", "type_traits", "ratio", "chrono", "ctime", "atomic", "typeindex", "array", "list", "forward_list", "vector", "deque", "queue", "stack", "map", "set", "unordered_map", "unordered_set", "iterator", "algorithm", "execution", "functional", "string_view", "string", "cctype", "cwctype", "cwchar", "cstdlib", "cuchar", "locale", "codecvt", "clocale", "iosfwd", "iostream", "ios", "streambuf", "istream", "ostream", "iomanip", "sstream", "fstream", "cstdio", "complex", "numeric", "valarray", "random", "cmath");

    public CppModulesStateImpl(@NotNull Project project) {
        this.myProject = project;
        this.myQueueProcessor.add((Object)new ScanFileSystem());
        this.myQueueProcessor.add((Object)new ScanIndex());
        if (DumbService.getInstance((Project)this.myProject).isDumb()) {
            DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> this.myQueueProcessor.add((Object)new ScanIndex()));
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    CppModulesStateImpl.this.myQueueProcessor.add((Object)new ScanPath(vFileEvent));
                }
            }
        });
        connection.subscribe(OCWorkspaceListener.TOPIC, (Object)new OCWorkspaceListener(){

            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                CppModulesStateImpl.this.myQueueProcessor.add((Object)new UpdateFromWorkspace());
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                CppModulesStateImpl.this.myQueueProcessor.add((Object)new ScanDocument(event));
            }
        }, (Disposable)this);
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                CppModulesStateImpl.this.myQueueProcessor.add((Object)new ScanIndex());
            }
        });
    }

    static boolean areCpp20ModulesEnabled() {
        return Registry.is((String)"clion.clang.clangd.enable.cpp20.modules");
    }

    private void tryAddModuleWithoutCompileCommand(@NotNull File moduleFile) {
        VirtualFile srcFile = VfsUtil.findFileByIoFile((File)moduleFile, (boolean)false);
        if (srcFile == null) {
            return;
        }
        this.tryAddModuleWithoutCompileCommand(srcFile);
    }

    @Nullable
    private static String getModuleName(@NotNull VirtualFile moduleVFile, @NotNull Ref<Boolean> isImpl) {
        CharSequence text = (CharSequence)ReadAction.compute(() -> {
            Document document = FileDocumentManager.getInstance().getDocument(moduleVFile);
            if (document == null) {
                return null;
            }
            return document.getImmutableCharSequence();
        });
        if (text == null) {
            return null;
        }
        Matcher m = exportModulePattern.matcher(text);
        isImpl.set((Object)false);
        if (!m.find()) {
            m = moduleImplOrInternalPartitionPattern.matcher(text);
            if (!m.find()) {
                return null;
            }
            isImpl.set((Object)true);
        }
        String line = m.group(0);
        @NotNull List parts = StringUtil.split((String)StringUtil.trimEnd((String)line, (String)";"), (String)" ");
        return (String)parts.get(parts.size() - 1);
    }

    @Nullable
    private static String getModuleName(@NotNull DocumentEvent event, @NotNull Ref<Boolean> isImpl) {
        try {
            CharSequence text = event.getDocument().getImmutableCharSequence();
            Matcher m = exportModulePattern.matcher(text);
            isImpl.set((Object)false);
            if (!m.find()) {
                m = moduleImplOrInternalPartitionPattern.matcher(text);
                if (!m.find()) {
                    return null;
                }
                isImpl.set((Object)true);
            }
            String line = m.group(0);
            @NotNull List parts = StringUtil.split((String)StringUtil.trimEnd((String)line, (String)";"), (String)" ");
            return (String)parts.get(parts.size() - 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private void tryAddModuleWithoutCompileCommand(@NotNull VirtualFile moduleVFile) {
        Ref isImpl = new Ref();
        @Nullable String modName = CppModulesStateImpl.getModuleName(moduleVFile, (Ref<Boolean>)isImpl);
        if (modName == null) {
            return;
        }
        this.addCppModule(new Cpp20Module(modName, null, null, moduleVFile.getPath(), (Boolean)isImpl.get()));
    }

    private static void appendStdModule(@NotNull StringBuilder sb, @NotNull String includePath, @NotNull String moduleName, @NotNull List<String> headers) {
        sb.append("module ").append(moduleName).append(" {\n");
        for (String header : headers) {
            sb.append("  header \"").append(includePath).append("/").append(header).append("\"\n");
        }
        sb.append("}\n");
    }

    private static boolean hasStdCoreIfc(@NotNull Path ifcPath) {
        return Files.exists(Paths.get(ifcPath.toString(), "x64", "Release", "std.core.ifc"), new LinkOption[0]) || Files.exists(Paths.get(ifcPath.toString(), "x86", "Release", "std.core.ifc"), new LinkOption[0]);
    }

    private void updateModuleMap(Project project) {
        if (project.isDisposed()) {
            return;
        }
        @Nullable ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(project);
        if (provider2 == null) {
            return;
        }
        @Nullable ClangLanguageService service = provider2.getIfStarted();
        if (service == null) {
            return;
        }
        @NotNull ClangUrlConverter converter = service.getUrlConverter();
        ArrayList<String> moduleNames = new ArrayList<String>();
        ArrayList<ClionCompileCommandParams> moduleCCParams = new ArrayList<ClionCompileCommandParams>();
        ArrayList<String> modulePPDefines = new ArrayList<String>();
        List modules = this.byPath(modmap -> new ArrayList(modmap.values()));
        Collections.sort(modules, Comparator.comparing(Cpp20Module::getName));
        for (Cpp20Module cppModule : modules) {
            @Nullable ClionCompileCommandParams ccParams = cppModule.getCompileCommand();
            if (ccParams == null) continue;
            moduleNames.add(cppModule.getName());
            moduleCCParams.add(ccParams);
            modulePPDefines.add(cppModule.getPPDefines());
        }
        service.notifyModuleMappingChanged(moduleNames, moduleCCParams, modulePPDefines);
        service.notifyDocumentChanged(VirtualFileManager.constructUrl((String)"file", (String)service.getContext().getCpp20ModuleMapPath()), CppModulesStateImpl.getAsCpp20ModuleMapImpl(converter, modules));
        service.notifyDocumentChanged(VirtualFileManager.constructUrl((String)"file", (String)service.getContext().getModuleMapPath()), CppModulesStateImpl.getModuleMapImpl(this.myProject));
        service.getContext().setCpp20ModulesEnabled(true);
    }

    @TestOnly
    @NotNull
    public String getAsCpp20ModuleMap() {
        @Nullable ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(this.myProject);
        if (provider2 == null) {
            return "<failed>";
        }
        @Nullable ClangLanguageService service = provider2.getIfStarted();
        if (service == null) {
            return "<failed>";
        }
        @NotNull ClangUrlConverter converter = service.getUrlConverter();
        ArrayList modules = this.byPath(modmap -> new ArrayList(modmap.values()));
        Collections.sort(modules, Comparator.comparing(Cpp20Module::getName));
        return CppModulesStateImpl.getAsCpp20ModuleMapImpl(converter, modules);
    }

    @NotNull
    private static String getModuleMapImpl(@NotNull Project project) {
        StringBuilder sb = new StringBuilder();
        List<HeadersSearchPath> headersSearchPaths = ClangUtils.headerSearchPathsForProject(project);
        if (headersSearchPaths != null) {
            boolean hasStdModules = false;
            if (SystemInfo.isWindows) {
                for (HeadersSearchPath headerSearchPath : headersSearchPaths) {
                    Path ifcPath;
                    if (!headerSearchPath.isBuiltInHeaders() || !headerSearchPath.getPath().endsWith("include") || !Files.exists(ifcPath = Paths.get(new File(headerSearchPath.getPath()).getParentFile().getAbsolutePath(), "ifc"), new LinkOption[0]) || !CppModulesStateImpl.hasStdCoreIfc(ifcPath)) continue;
                    hasStdModules = true;
                    String includePath = FileUtil.toSystemIndependentName((String)headerSearchPath.getPath());
                    CppModulesStateImpl.appendStdModule(sb, includePath, "std.regex", List.of("regex"));
                    CppModulesStateImpl.appendStdModule(sb, includePath, "std.filesystem", List.of("filesystem"));
                    CppModulesStateImpl.appendStdModule(sb, includePath, "std.memory", List.of("memory"));
                    CppModulesStateImpl.appendStdModule(sb, includePath, "std.threading", List.of("atomic", "condition_variable", "future", "mutex", "shared_mutex", "thread"));
                    CppModulesStateImpl.appendStdModule(sb, includePath, "std.core", ALL_STD_CORE_HEADERS);
                }
            }
            if (!hasStdModules) {
                HashSet<String> uniqueIncludes = new HashSet<String>();
                for (HeadersSearchPath headerSearchPath : headersSearchPaths) {
                    File[] files;
                    if (!headerSearchPath.isBuiltInHeaders() || (files = new File(headerSearchPath.getPath()).listFiles()) == null) continue;
                    String includePath = FileUtil.toSystemIndependentName((String)headerSearchPath.getPath());
                    for (File child : files) {
                        if (child.isDirectory() || child.getName().contains(".") || uniqueIncludes.contains(child.getName())) continue;
                        String name = child.getName();
                        uniqueIncludes.add(name);
                        CppModulesStateImpl.appendStdModule(sb, includePath, "std.clionInternalModule." + name, List.of(name));
                    }
                }
            }
        }
        return sb.toString();
    }

    @NotNull
    private static String getAsCpp20ModuleMapImpl(@NotNull ClangUrlConverter converter, @NotNull List<Cpp20Module> modules) {
        StringBuilder sb = new StringBuilder();
        Collections.sort(modules, (lhs, rhs) -> {
            if (lhs.getName().equals(rhs.getName())) {
                return Boolean.compare(lhs.isImpl(), rhs.isImpl());
            }
            return lhs.getName().compareTo(rhs.getName());
        });
        HashMap<String, Cpp20Module> processedModules = new HashMap<String, Cpp20Module>();
        for (Cpp20Module cppModule : modules) {
            Cpp20Module prevModule = processedModules.put(cppModule.getName(), cppModule);
            if (prevModule == null) {
                sb.append("module ").append(cppModule.getName()).append(" {\n");
                String modulePath = converter.fixWslPathWhenRequired(cppModule.getSourcePath());
                sb.append("  header \"").append(modulePath).append("\"\n");
                sb.append("}\n");
                continue;
            }
            CidrLog.LOG.warn("Several C++20 modules with the same name found.\nPrevious = " + prevModule + "\nNew = " + cppModule);
        }
        return sb.toString();
    }

    @TestOnly
    public void waitForQueueProcessor() {
        this.myQueueProcessor.waitFor();
    }

    private static boolean isCpp20ModuleFile(@NotNull String fileName) {
        return fileName.endsWith(".ixx") || fileName.endsWith(".cppm") || fileName.endsWith(".mxx");
    }

    private static boolean maybeCpp20ModuleFile(@NotNull String filePath) {
        return CppModulesStateImpl.isCpp20ModuleFile(filePath) || filePath.endsWith(".cpp") || filePath.endsWith(".cc") || filePath.endsWith(".cxx");
    }

    @Override
    public synchronized <T> T byPath(@NotNull Function<Map<String, Cpp20Module>, T> consumer) {
        return consumer.apply(this.myModulesByPath);
    }

    @Override
    public synchronized void addCppModule(@NotNull Cpp20Module cppModule) {
        this.myModulesByPath.put(cppModule.getSourcePath(), cppModule);
    }

    @Override
    public synchronized void removeCppModuleByPath(@NotNull String cppModulePath) {
        this.myModulesByPath.remove(cppModulePath);
    }

    @Override
    public synchronized void removeCppModulesInDir(@NotNull String dirPath) {
        ArrayList<Cpp20Module> toDelete = new ArrayList<Cpp20Module>();
        for (Map.Entry<String, Cpp20Module> entry : this.myModulesByPath.entrySet()) {
            if (!entry.getKey().startsWith(dirPath)) continue;
            toDelete.add(entry.getValue());
        }
        for (Cpp20Module module : toDelete) {
            this.myModulesByPath.remove(module.getSourcePath());
        }
    }

    @Override
    public synchronized void clearCppModules() {
        this.myModulesByPath.clear();
    }

    @Override
    public synchronized int size() {
        return this.myModulesByPath.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    synchronized boolean hasCppModule(@NotNull String cppModulePath) {
        return this.myModulesByPath.containsKey(cppModulePath);
    }

    boolean hasCppModule(@NotNull File cppModuleFile) {
        return this.hasCppModule(cppModuleFile.getPath());
    }

    @Override
    public boolean dirContainsCppModule(@NotNull String dirPath) {
        for (String path : this.myModulesByPath.keySet()) {
            if (!path.startsWith(dirPath)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    private class ScanFileSystem
    extends UpdateEvent {
        private ScanFileSystem() {
        }

        @Override
        public void performImpl() {
            String basePath = CppModulesStateImpl.this.myProject.getBasePath();
            if (StringUtil.isEmpty((String)basePath)) {
                return;
            }
            Set<File> moduleFiles = ScanFileSystem.findCpp20ModuleFiles(new File(basePath));
            for (File moduleFile : moduleFiles) {
                if (CppModulesStateImpl.this.hasCppModule(moduleFile)) continue;
                CppModulesStateImpl.this.tryAddModuleWithoutCompileCommand(moduleFile);
            }
            CppModulesStateImpl.this.updateModuleMap(CppModulesStateImpl.this.myProject);
        }

        @NotNull
        private static Set<File> findCpp20ModuleFiles(@NotNull File baseDir) {
            HashSet<File> cpp20ModulesCandidates = new HashSet<File>();
            ScanFileSystem.visitFilesIgnoringSymlinks(baseDir, (Processor<? super File>)((Processor)file -> {
                if (CppModulesStateImpl.isCpp20ModuleFile(file.getName())) {
                    cpp20ModulesCandidates.add((File)file);
                }
                return true;
            }), true);
            for (File parentDirectory = baseDir.getParentFile(); parentDirectory != null; parentDirectory = parentDirectory.getParentFile()) {
                ScanFileSystem.visitFilesIgnoringSymlinks(parentDirectory, (Processor<? super File>)((Processor)file -> {
                    if (CppModulesStateImpl.isCpp20ModuleFile(file.getName())) {
                        cpp20ModulesCandidates.add((File)file);
                    }
                    return true;
                }), false);
            }
            return cpp20ModulesCandidates;
        }

        private static boolean visitFilesIgnoringSymlinks(@NotNull File root, @NotNull Processor<? super File> processor, boolean recursive) {
            if (!processor.process((Object)root)) {
                return false;
            }
            File[] children = root.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (!(child.isFile() ? !processor.process((Object)child) : child.isDirectory() && recursive && !Files.isSymbolicLink(child.toPath()) && !ScanFileSystem.visitFilesIgnoringSymlinks(child, processor, true))) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "ScanFileSystem{}";
        }
    }

    private class ScanIndex
    extends UpdateEvent {
        private ScanIndex() {
        }

        @Override
        void performImpl() {
            ArrayList hits = new ArrayList();
            ThrowableComputable findTextComputable = () -> TextSearchService.getInstance().processFilesWithText("module", Processors.cancelableCollectProcessor((Collection)hits), (GlobalSearchScope)new OnlyCppSourcesScope(GlobalSearchScope.projectScope((Project)CppModulesStateImpl.this.myProject)));
            TextSearchService.TextSearchResult result = (TextSearchService.TextSearchResult)ReadAction.nonBlocking(() -> (TextSearchService.TextSearchResult)DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(findTextComputable)).executeSynchronously();
            if (result == TextSearchService.TextSearchResult.NO_TRIGRAMS) {
                return;
            }
            for (VirtualFile vf : hits) {
                if (CppModulesStateImpl.this.hasCppModule(vf.getPath())) continue;
                CppModulesStateImpl.this.tryAddModuleWithoutCompileCommand(vf);
            }
            CppModulesStateImpl.this.updateModuleMap(CppModulesStateImpl.this.myProject);
        }

        public String toString() {
            return "ScanIndex{}";
        }
    }

    private abstract class UpdateEvent {
        private UpdateEvent() {
        }

        final void perform() {
            if (!CppModulesStateImpl.areCpp20ModulesEnabled()) {
                return;
            }
            if (((Boolean)ReadAction.compute(() -> CppModulesStateImpl.this.myProject.isDisposed())).booleanValue()) {
                return;
            }
            this.performImpl();
        }

        abstract void performImpl();
    }

    private class UpdateFromWorkspace
    extends UpdateEvent {
        private UpdateFromWorkspace() {
        }

        @Override
        void performImpl() {
            ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(CppModulesStateImpl.this.myProject);
            if (provider2 == null) {
                return;
            }
            ClangLanguageService service = provider2.getOrStart();
            HashSet<String> allSources = new HashSet<String>();
            ClangUrlConverter converter = service.getUrlConverter();
            Cpp20ModulesContext cpp20ModulesContext = new Cpp20ModulesContext(service.getContext().getCpp20ModuleMapPath(), service.getContext().getCpp20ModulesPath(), service.getContext().getModuleMapPath());
            boolean anythingWasAdded = false;
            for (OCResolveConfiguration config : OCWorkspace.getInstance((Project)CppModulesStateImpl.this.myProject).getConfigurations()) {
                for (VirtualFile srcFile : config.getSources()) {
                    String[] modName;
                    ClangdCompilationCommand command;
                    String name = srcFile.getName();
                    if (allSources.contains(name)) continue;
                    allSources.add(name);
                    if (!CppModulesStateImpl.isCpp20ModuleFile(name) || (command = (ClangdCompilationCommand)ReadAction.compute(() -> this.lambda$performImpl$0(srcFile, modName = new String[]{""}, service, converter, cpp20ModulesContext))) == null) continue;
                    anythingWasAdded = true;
                    CppModulesStateImpl.this.addCppModule(new Cpp20Module(modName[0], command.ccParams, command.ppDefines, srcFile.getPath(), false));
                }
            }
            if (anythingWasAdded) {
                CppModulesStateImpl.this.updateModuleMap(CppModulesStateImpl.this.myProject);
            }
        }

        public String toString() {
            return "UpdateFromWorkspace{}";
        }

        private /* synthetic */ ClangdCompilationCommand lambda$performImpl$0(VirtualFile srcFile, String[] modName, ClangLanguageService service, ClangUrlConverter converter, Cpp20ModulesContext cpp20ModulesContext) throws RuntimeException {
            Document document = FileDocumentManager.getInstance().getDocument(srcFile);
            if (document == null) {
                return null;
            }
            Matcher m = exportModulePattern.matcher(document.getText());
            if (!m.find()) {
                return null;
            }
            String line = m.group(0);
            @NotNull List parts = StringUtil.split((String)StringUtil.trimEnd((String)line, (String)";"), (String)" ");
            modName[0] = (String)parts.get(parts.size() - 1);
            return service.getClangIdeFacade().getCompilationCommand(converter, CppModulesStateImpl.this.myProject, srcFile, "", cpp20ModulesContext);
        }
    }

    private class ScanDocument
    extends UpdateEvent {
        @NotNull
        private final DocumentEvent myEvent;

        private ScanDocument(DocumentEvent event) {
            this.myEvent = event;
        }

        @Override
        void performImpl() {
            VirtualFile file = FileDocumentManager.getInstance().getFile(this.myEvent.getDocument());
            if (file == null) {
                return;
            }
            if (CppModulesStateImpl.maybeCpp20ModuleFile(file.getName())) {
                VirtualFile origFile;
                VirtualFile virtualFile = origFile = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getOriginalFile() : file;
                if (origFile == null) {
                    return;
                }
                Cpp20Module module = CppModulesStateImpl.this.byPath(modmap -> (Cpp20Module)modmap.get(origFile.getPath()));
                Ref isImpl = new Ref();
                @Nullable String modName = CppModulesStateImpl.getModuleName(this.myEvent, (Ref<Boolean>)isImpl);
                if (modName == null) {
                    if (module != null) {
                        CppModulesStateImpl.this.removeCppModuleByPath(module.getSourcePath());
                        CppModulesStateImpl.this.updateModuleMap(CppModulesStateImpl.this.myProject);
                    }
                } else if (!modName.contains("CIDR_RULE_ZZZ")) {
                    if (module != null) {
                        if (!module.getName().equals(modName)) {
                            CppModulesStateImpl.this.addCppModule(new Cpp20Module(modName, module.getCompileCommand(), module.getPPDefines(), module.getSourcePath(), (Boolean)isImpl.get()));
                            CppModulesStateImpl.this.updateModuleMap(CppModulesStateImpl.this.myProject);
                        }
                    } else {
                        CppModulesStateImpl.this.addCppModule(new Cpp20Module(modName, null, null, origFile.getPath(), (Boolean)isImpl.get()));
                        CppModulesStateImpl.this.updateModuleMap(CppModulesStateImpl.this.myProject);
                    }
                }
            }
        }

        public String toString() {
            return "ScanDocument{myEvent=" + this.myEvent + "}";
        }
    }

    private class ScanPath
    extends UpdateEvent {
        @NotNull
        private final VFileEvent myEvent;

        private ScanPath(VFileEvent event) {
            this.myEvent = event;
        }

        @Override
        void performImpl() {
            if (this.handleFileEvent(this.myEvent, CppModulesStateImpl.this.myProject)) {
                CppModulesStateImpl.this.updateModuleMap(CppModulesStateImpl.this.myProject);
            }
        }

        private boolean handleFileEvent(@NotNull VFileEvent fileEvent, @NotNull Project project) {
            VirtualFile file = fileEvent.getFile();
            if (file == null) {
                return false;
            }
            boolean hasChanges = false;
            if (fileEvent instanceof VFileDeleteEvent) {
                if (CppModulesStateImpl.this.hasCppModule(file.getPath())) {
                    CppModulesStateImpl.this.removeCppModuleByPath(file.getPath());
                    hasChanges = true;
                } else if (file.isDirectory() && CppModulesStateImpl.this.dirContainsCppModule(file.getPath())) {
                    CppModulesStateImpl.this.removeCppModulesInDir(file.getPath());
                    hasChanges = true;
                }
            } else if (fileEvent instanceof VFileMoveEvent) {
                String oldPath = ((VFileMoveEvent)fileEvent).getOldPath();
                if (CppModulesStateImpl.this.hasCppModule(oldPath)) {
                    CppModulesStateImpl.this.removeCppModuleByPath(oldPath);
                    CppModulesStateImpl.this.tryAddModuleWithoutCompileCommand(file);
                    hasChanges = true;
                } else if (!CppModulesStateImpl.this.hasCppModule(file.getPath()) && CppModulesStateImpl.isCpp20ModuleFile(file.getPath())) {
                    CppModulesStateImpl.this.tryAddModuleWithoutCompileCommand(file);
                    hasChanges = true;
                }
            } else if (fileEvent instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)fileEvent;
                if (!propertyChangeEvent.getOldPath().equals(file.getPath()) && propertyChangeEvent.getPropertyName().equals("name")) {
                    if (CppModulesStateImpl.this.hasCppModule(propertyChangeEvent.getOldPath())) {
                        CppModulesStateImpl.this.removeCppModuleByPath(propertyChangeEvent.getOldPath());
                        CppModulesStateImpl.this.tryAddModuleWithoutCompileCommand(file);
                        hasChanges = true;
                    } else if (!CppModulesStateImpl.this.hasCppModule(file.getPath()) && CppModulesStateImpl.isCpp20ModuleFile(file.getPath())) {
                        CppModulesStateImpl.this.tryAddModuleWithoutCompileCommand(file);
                        hasChanges = true;
                    }
                }
            } else if (fileEvent instanceof VFileCreateEvent) {
                if (CppModulesStateImpl.isCpp20ModuleFile(file.getPath()) && !CppModulesStateImpl.this.hasCppModule(file.getPath())) {
                    CppModulesStateImpl.this.tryAddModuleWithoutCompileCommand(file);
                    hasChanges = true;
                }
                if (((VFileCreateEvent)fileEvent).getChildren() != null) {
                    for (ChildInfo childInfo : ((VFileCreateEvent)fileEvent).getChildren()) {
                        hasChanges |= this.handleChildInfo(file.getPath(), childInfo, project);
                    }
                }
            } else if (fileEvent instanceof VFileCopyEvent) {
                VFileCopyEvent copyEvent = (VFileCopyEvent)fileEvent;
                VirtualFile createdFile = copyEvent.findCreatedFile();
                if (createdFile == null) {
                    return false;
                }
                if (CppModulesStateImpl.isCpp20ModuleFile(createdFile.getPath()) && !CppModulesStateImpl.this.hasCppModule(createdFile.getPath())) {
                    CppModulesStateImpl.this.tryAddModuleWithoutCompileCommand(createdFile);
                    hasChanges = true;
                }
            }
            return hasChanges;
        }

        private boolean handleChildInfo(@NotNull String parentPath, @NotNull ChildInfo info, @NotNull Project project) {
            boolean hasChanged = false;
            String path = parentPath + "/" + info.getName();
            if (info.getChildren() != null) {
                for (ChildInfo childInfo : info.getChildren()) {
                    hasChanged |= this.handleChildInfo(path, childInfo, project);
                }
            }
            if (CppModulesStateImpl.isCpp20ModuleFile(path) && !CppModulesStateImpl.this.hasCppModule(path)) {
                CppModulesStateImpl.this.tryAddModuleWithoutCompileCommand(new File(path));
                return true;
            }
            return hasChanged;
        }

        public String toString() {
            return "ScanPath{myEvent=" + this.myEvent + "}";
        }
    }
}

