/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

@State(name="ClangdSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ClangdSettings
implements PersistentStateComponent<StoredState> {
    private static final String GLOBAL_COMPLETION_CACHE_ID = "clangd.use.global.completion.cache";
    private static final List<ClangFeatures.Warning> DISABLE_FOR_UnusedInspections = Collections.singletonList(ClangFeatures.Warnings.UNUSED_VARIABLE);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_InfiniteRecursion = Collections.singletonList(ClangFeatures.Warnings.INFINITE_RECURSION);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_ArrayIndexOufOfBounds = Collections.singletonList(ClangFeatures.Warnings.ARRAY_BOUNDS);
    private static final List<ClangFeatures.Warning> ENABLE_FOR_HidesUpperScope = Collections.singletonList(ClangFeatures.Warnings.SHADOW);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_FunctionImplicitDeclarationInspection = Collections.singletonList(ClangFeatures.Warnings.IMPLICIT_FUNCTION_DECLARATION);
    @NlsSafe
    private static final String DEFAULT_DISABLED_WARNINGS = ClangdSettings.makeWarningsDisabled(DISABLE_FOR_UnusedInspections, DISABLE_FOR_InfiniteRecursion, DISABLE_FOR_ArrayIndexOufOfBounds);
    @NlsSafe
    private static final String DEFAULT_ENABLED_WARNINGS = ClangdSettings.makeWarningsEnabled(ENABLE_FOR_HidesUpperScope, Collections.singletonList(ClangFeatures.Warnings.UNINITIALIZED), Collections.singletonList(ClangFeatures.Warnings.UNUSED_LABEL), Collections.singletonList(ClangFeatures.Warnings.UNUSED_LAMBDA_CAPTURE));
    @NlsSafe
    private static final String DEFAULT_DISABLED_ERRORS = ClangdSettings.makeWarningsAsErrors(DISABLE_FOR_FunctionImplicitDeclarationInspection);
    @NlsSafe
    private static final String DEFAULT_MESSAGE_FILTERS = PluginManagerCore.isRunningFromSources() ? "<-- clionDefinition\n--> reply:clionDefinition\n--> telemetry/event\n<-- clionDebugDumpMemoryStat\n--> reply:clionDebugDumpMemoryStat\nclion-method:clionDefinition\nclion-method:clionDebugDumpMemoryStat\nclion-method:telemetry/event" : "<-- clionDefinition\n--> reply:clionDefinition\n--> telemetry/event\n<-- clionDebugDumpMemoryStat\n--> reply:clionDebugDumpMemoryStat";
    @NotNull
    private final Project myProject;
    @NotNull
    private final StoredState myState = new StoredState();

    public ClangdSettings(@NotNull Project project) {
        this.myProject = project;
        ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(project);
        if (provider2 != null) {
            Registry.get((String)"clion.clang.clangd.on").addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    ClangdSettings.this.setClangdEnabledImpl(value.asBoolean());
                }
            }, (Disposable)provider2);
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)provider2).subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(){

                public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
                    if (id.equals(ClangdSettings.GLOBAL_COMPLETION_CACHE_ID)) {
                        ClangdSettings.this.setGlobalCompletionCacheEnabled((Boolean)newValue);
                    }
                }
            });
            Registry.get((String)"clang.parameter.info").addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue registryValue) {
                    boolean newValue = registryValue.asBoolean();
                    ClangdSettings.this.setProperty(value -> {
                        ClangdSettings.this.myState.parameterInfoViaClangd = value;
                    }, ClangdSettingsListener::onParameterInfoViaClangdChanged, ClangdSettings.this.myState.parameterInfoViaClangd, newValue);
                }
            }, (Disposable)provider2);
        }
    }

    public static ClangdSettings getInstance(@NotNull Project project) {
        return (ClangdSettings)project.getService(ClangdSettings.class);
    }

    public synchronized boolean isClangdOn() {
        return this.myState.clangdEnabled && (this.myState.clangdShowErrors || this.myState.clangTidyViaClangd || this.myState.navigationViaClangd || this.myState.parameterInfoViaClangd || this.myState.formatViaClangd || this.myState.completionType != CompletionType.Builtin || Registry.is((String)"clion.clang.clangd.index.on"));
    }

    public synchronized boolean isClangdShowErrors() {
        return this.myState.clangdShowErrors;
    }

    public synchronized void setClangdShowErrors(boolean clangdShowErrors) {
        this.setProperty(value -> {
            this.myState.clangdShowErrors = value;
        }, ClangdSettingsListener::onClangdShowErrorsChanged, this.myState.clangdShowErrors, clangdShowErrors);
    }

    public synchronized boolean isClangTidyViaClangd() {
        return this.myState.clangTidyViaClangd;
    }

    public synchronized void setClangTidyViaClangd(boolean clangTidyViaClangd) {
        this.setProperty(value -> {
            this.myState.clangTidyViaClangd = value;
        }, ClangdSettingsListener::onClangTidyViaClangdChanged, this.myState.clangTidyViaClangd, clangTidyViaClangd);
    }

    public synchronized boolean isNavigationViaClangd() {
        return this.myState.navigationViaClangd;
    }

    public synchronized boolean isParameterInfoViaClangd() {
        return this.myState.parameterInfoViaClangd;
    }

    public synchronized void setNavigationViaClangd(boolean navigationViaClangd) {
        this.setProperty(value -> {
            this.myState.navigationViaClangd = value;
        }, ClangdSettingsListener::onNavigationViaClangdChanged, this.myState.navigationViaClangd, navigationViaClangd);
    }

    public synchronized void setParameterInfoViaClangd(boolean parameterInfoViaClangd) {
        this.setProperty(value -> {
            this.myState.parameterInfoViaClangd = value;
        }, ClangdSettingsListener::onParameterInfoViaClangdChanged, this.myState.parameterInfoViaClangd, parameterInfoViaClangd);
        Registry.get((String)"clang.parameter.info").setValue(parameterInfoViaClangd);
    }

    public synchronized boolean isFormatViaClangd() {
        return this.myState.formatViaClangd;
    }

    public synchronized void setFormatViaClangd(boolean formatViaClangd) {
        this.setProperty(value -> {
            this.myState.formatViaClangd = value;
        }, ClangdSettingsListener::onFormatViaClangdChanged, this.myState.formatViaClangd, formatViaClangd);
    }

    public synchronized CompletionType getCompletionType() {
        return this.myState.completionType;
    }

    public synchronized void setCompletionType(CompletionType completionType) {
        this.setProperty(value -> {
            this.myState.completionType = completionType;
        }, ClangdSettingsListener::onCompletionTypeChanged, this.myState.completionType, completionType);
    }

    public synchronized boolean getGlobalCompletionCacheEnabled() {
        return this.myState.enableGlobalCompletionCache;
    }

    public synchronized void setGlobalCompletionCacheEnabled(boolean enabled) {
        this.setProperty(value -> {
            this.myState.enableGlobalCompletionCache = value;
        }, ClangdSettingsListener::onGlobalCompletionCacheChanged, this.myState.enableGlobalCompletionCache, enabled);
        ClangdSettings.rehighlight();
    }

    public synchronized boolean isClangdEnabled() {
        return this.myState.clangdEnabled;
    }

    public synchronized void setClangdEnabled(boolean clangdEnabled) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            CidrLogService.LOG.error("Enabling clangd in production programmatically? It is allowed from Registry only.");
        }
        this.setClangdEnabledImpl(clangdEnabled);
    }

    private synchronized void setClangdEnabledImpl(boolean clangdEnabled) {
        this.setProperty(value -> {
            this.myState.clangdEnabled = value;
        }, ClangdSettingsListener::onClangdEnabled, this.myState.clangdEnabled, clangdEnabled);
    }

    @NotNull
    @NlsSafe
    public synchronized String getClangdMessagesFilters() {
        return StringUtil.notNullize((String)this.myState.clangdMessagesFilters);
    }

    public synchronized void setClangdMessagesFilters(@NlsSafe @NotNull String clangdMessagesFilters) {
        this.setProperty(value -> {
            this.myState.clangdMessagesFilters = value;
        }, ClangdSettingsListener::onClangdMessagesFiltersChanged, this.myState.clangdMessagesFilters, clangdMessagesFilters);
    }

    public synchronized boolean getIndexerSkipBodies() {
        return this.myState.indexerSkipBodies;
    }

    public synchronized void setIndexerSkipBodies(boolean skipBodies) {
        this.myState.indexerSkipBodies = skipBodies;
    }

    public synchronized boolean getIndexerSkipImplicitInstantiations() {
        return this.myState.indexerSkipImplicitInstantiations;
    }

    public synchronized void setIndexerSkipImplicitInstantiations(boolean skipImplicitInstantiations) {
        this.myState.indexerSkipImplicitInstantiations = skipImplicitInstantiations;
    }

    public synchronized int getIndexerModulesCacheMb() {
        return this.myState.indexerModulesCacheMb;
    }

    public synchronized void setIndexerModulesCacheMb(int modulesCacheMb) {
        this.myState.indexerModulesCacheMb = modulesCacheMb;
    }

    public synchronized int getIndexingThreadsNum() {
        return this.myState.indexingThreadsNum;
    }

    public synchronized void setIndexingThreadsNum(int threadsNum) {
        this.myState.indexingThreadsNum = threadsNum;
    }

    public synchronized boolean getIndexerShowDebugMessages() {
        return this.myState.indexerShowDebugMessages;
    }

    public synchronized void setIndexerShowDebugMessages(boolean showDebugMessages) {
        this.myState.indexerShowDebugMessages = showDebugMessages;
    }

    public synchronized boolean getIndexerRestrictUpdatingThreads() {
        return this.myState.restrictUpdatingThreads;
    }

    public synchronized void setIndexerRestrictUpdatingThreads(boolean restrictUpdatingThreads) {
        this.myState.restrictUpdatingThreads = restrictUpdatingThreads;
    }

    @NotNull
    public synchronized String getClangFlags() {
        return StringUtil.notNullize((String)this.myState.clangWarnings);
    }

    public synchronized void setClangFlags(@NlsSafe @NotNull String clangWarnings) {
        this.myState.clangWarnings = clangWarnings;
    }

    @NotNull
    public synchronized StoredState getState() {
        return new StoredState(this.myState);
    }

    public synchronized void loadState(@NotNull StoredState state) {
        this.setClangdShowErrors(state.clangdShowErrors);
        this.setClangTidyViaClangd(state.clangTidyViaClangd);
        this.setNavigationViaClangd(state.navigationViaClangd);
        this.setParameterInfoViaClangd(state.parameterInfoViaClangd);
        this.setFormatViaClangd(state.formatViaClangd);
        this.setCompletionType(state.completionType != null ? state.completionType : new StoredState().completionType);
        this.setClangFlags(state.clangWarnings);
        this.setClangdMessagesFilters(state.clangdMessagesFilters);
        this.setIndexerSkipBodies(state.indexerSkipBodies);
        this.setIndexerSkipImplicitInstantiations(state.indexerSkipImplicitInstantiations);
        this.setIndexerModulesCacheMb(state.indexerModulesCacheMb);
        this.setIndexingThreadsNum(state.indexingThreadsNum);
        this.setIndexerRestrictUpdatingThreads(state.restrictUpdatingThreads);
        this.setIndexerShowDebugMessages(state.indexerShowDebugMessages);
    }

    @NotNull
    private ClangdSettingsListener getPublisher() {
        return (ClangdSettingsListener)this.myProject.getMessageBus().syncPublisher(ClangdSettingsListener.TOPIC);
    }

    public static void rehighlight() {
        Project[] openProjects;
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            PsiManager.getInstance((Project)project).dropPsiCaches();
        }
    }

    @SafeVarargs
    @NlsSafe
    @NotNull
    private static String makeWarningsDisabled(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList args = new ArrayList();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getDisabledOnlyThis());
            }
        }
        return StringUtil.join(args, (String)",");
    }

    @SafeVarargs
    @NotNull
    private static String makeWarningsEnabled(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList args = new ArrayList();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getEnabledOnlyThis(false));
            }
        }
        return StringUtil.join(args, (String)",");
    }

    @SafeVarargs
    @NotNull
    private static String makeWarningsAsErrors(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList args = new ArrayList();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getEnabledOnlyThis(true));
            }
        }
        return StringUtil.join(args, (String)",");
    }

    private <Type> void setProperty(@NotNull Consumer<Type> propertySetter, @NotNull BiConsumer<ClangdSettingsListener, Type> propertyListener, Type oldValue, Type newValue) {
        if (!Objects.equals(newValue, oldValue)) {
            boolean oldClangdOn = this.isClangdOn();
            propertySetter.accept(newValue);
            propertyListener.accept(this.getPublisher(), newValue);
            boolean newClangOn = this.isClangdOn();
            if (oldClangdOn != newClangOn) {
                this.getPublisher().onClangdOnChanged(newClangOn);
            }
        }
    }

    static class StoredState {
        public boolean clangdShowErrors = !ApplicationManager.getApplication().isUnitTestMode();
        public boolean clangTidyViaClangd = true;
        public boolean navigationViaClangd = true;
        public boolean parameterInfoViaClangd = true;
        public boolean formatViaClangd = true;
        public CompletionType completionType = ApplicationManager.getApplication().isUnitTestMode() ? CompletionType.Builtin : CompletionType.Clangd;
        public boolean enableGlobalCompletionCache = AdvancedSettings.getBoolean((String)"clangd.use.global.completion.cache");
        public boolean clangdEnabled = Registry.is((String)"clion.clang.clangd.on");
        @NlsSafe
        public String clangWarnings = StringUtil.join(Arrays.asList(DEFAULT_DISABLED_WARNINGS, DEFAULT_DISABLED_ERRORS, DEFAULT_ENABLED_WARNINGS, ApplicationManager.getApplication().isUnitTestMode() ? "-Wconversion" : null), (String)",");
        @NlsSafe
        public String clangdMessagesFilters = DEFAULT_MESSAGE_FILTERS;
        public boolean indexerSkipBodies = true;
        public boolean indexerSkipImplicitInstantiations = true;
        public int indexerModulesCacheMb = 4000;
        public int indexingThreadsNum = 0;
        public boolean indexerShowDebugMessages = false;
        public boolean restrictUpdatingThreads = true;

        StoredState() {
        }

        StoredState(@NotNull StoredState other) {
            this.clangdShowErrors = other.clangdShowErrors;
            this.clangTidyViaClangd = other.clangTidyViaClangd;
            this.navigationViaClangd = other.navigationViaClangd;
            this.parameterInfoViaClangd = other.parameterInfoViaClangd;
            this.formatViaClangd = other.formatViaClangd;
            this.completionType = other.completionType;
            this.clangdEnabled = other.clangdEnabled;
            this.clangWarnings = other.clangWarnings;
            this.clangdMessagesFilters = other.clangdMessagesFilters;
            this.enableGlobalCompletionCache = other.enableGlobalCompletionCache;
            this.indexerSkipBodies = other.indexerSkipBodies;
            this.indexerSkipImplicitInstantiations = other.indexerSkipImplicitInstantiations;
            this.indexerModulesCacheMb = other.indexerModulesCacheMb;
            this.indexingThreadsNum = other.indexingThreadsNum;
            this.restrictUpdatingThreads = other.restrictUpdatingThreads;
            this.indexerShowDebugMessages = other.indexerShowDebugMessages;
        }
    }

    public static enum CompletionType {
        Builtin(0),
        Clangd(1);

        private final int value;

        private CompletionType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static CompletionType forValue(int value) {
            CompletionType[] allValues = CompletionType.values();
            if (value < 0 || value >= allValues.length) {
                return Clangd;
            }
            return allValues[value];
        }
    }
}

