/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangWorkspace;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface WorkspaceFile {
    @NlsSafe
    @NotNull
    public String getUrl();

    @NotNull
    public Set<Key<?>> keys();

    public <T> T get(@NotNull Key<T> var1);

    public <T> T getOrDefault(@NotNull Key<T> var1);

    public <T> void put(@NotNull Key<T> var1, T var2);

    public boolean hasKey(@NotNull Key<?> var1);

    public static final class Key<T> {
        @NotNull
        private final String key;
        @Nullable
        private final Supplier<T> defValueProvider;

        public Key(@NonNls @NotNull String key) {
            this(key, null);
        }

        public Key(@NonNls @NotNull String key, @Nullable Supplier<T> defValueProvider) {
            this.key = key;
            this.defValueProvider = defValueProvider;
        }

        @NonNls
        @NotNull
        public String getKey() {
            return this.key;
        }

        public T getValue(@NotNull WorkspaceFile wf) {
            return wf.get(this);
        }

        public T getValue(@NotNull ClangWorkspace<? extends WorkspaceFile> workspace, @NlsSafe @NotNull String url) {
            return (T)workspace.apply(url, wf -> this.getValue((WorkspaceFile)wf));
        }

        public T getValueOrDefault(@NotNull WorkspaceFile wf) {
            return wf.getOrDefault(this);
        }

        public T getValueOrDefault(@NotNull ClangWorkspace<? extends WorkspaceFile> workspace, @NlsSafe @NotNull String url) {
            return (T)workspace.apply(url, wf -> this.getValueOrDefault((WorkspaceFile)wf));
        }

        public T createDefaultValue() {
            return this.defValueProvider != null ? (T)this.defValueProvider.get() : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key1 = (Key)o;
            return Objects.equals(this.key, key1.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        @NonNls
        public String toString() {
            return this.key;
        }
    }
}

