/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionModuleMappingParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionSetCDBParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFileImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.AbstractClangWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFileListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangRemoteWorkspaceImpl
extends AbstractClangWorkspace<RemoteWorkspaceFile>
implements ClangRemoteWorkspace,
WorkspaceFileListener {
    @NotNull
    private final Set<String> myUnsavedFiles = ContainerUtil.newConcurrentSet();
    @Nullable
    private volatile String myIndexUri = null;
    @Nullable
    private volatile CLionModuleMappingParams myCpp20ModuleMapping = null;
    @Nullable
    private volatile String myLoadedGraphUri = null;
    @Nullable
    private volatile ClionSetCDBParams myCDB = null;

    @Override
    @NotNull
    public Set<String> getUnsavedFiles() {
        return Collections.unmodifiableSet(new HashSet<String>(this.myUnsavedFiles));
    }

    @Override
    @Nullable
    public String getLoadedIndexParams() {
        return this.myIndexUri;
    }

    @Override
    public void setLoadedIndexParams(@NotNull String uri) {
        this.myIndexUri = uri;
    }

    @Override
    @Nullable
    public CLionModuleMappingParams getCpp20ModuleMapping() {
        return this.myCpp20ModuleMapping;
    }

    @Override
    public void setCpp20ModuleMapping(@Nullable CLionModuleMappingParams params) {
        this.myCpp20ModuleMapping = params;
    }

    @Override
    @Nullable
    public String getLoadedGraphUri() {
        return this.myLoadedGraphUri;
    }

    @Override
    public void setLoadedGraphUri(@NotNull String uri) {
        this.myLoadedGraphUri = uri;
    }

    @Override
    @Nullable
    public ClionSetCDBParams getCDB() {
        return this.myCDB;
    }

    @Override
    public void setCDB(@NotNull ClionSetCDBParams params) {
        this.myCDB = params;
    }

    @Override
    public boolean isOpenedRemotely(@NotNull String url) {
        return this.apply(url, (WF wf) -> wf.getOrDefault(RemoteWorkspaceFile.IS_OPENED));
    }

    @Override
    public boolean isClosedRemotely(@NotNull String url) {
        return this.apply(url, (WF wf) -> wf.getOrDefault(RemoteWorkspaceFile.IS_OPENED) == false);
    }

    @Override
    public boolean isParsed(@NotNull String url) {
        return this.apply(url, (WF wf) -> wf.hasKey(RemoteWorkspaceFile.REMOTE_COMPILATION_COMMAND));
    }

    @Override
    public ClionReparseTextDocumentParams getReparseParams(@NotNull String url) {
        return this.apply(url, (WF wf) -> wf.getReparseParams());
    }

    @Override
    public String getContent(@NotNull String url) {
        return this.apply(url, (WF wf) -> wf.getContent());
    }

    @Override
    @NotNull
    protected RemoteWorkspaceFile createWorkspaceFile(@NotNull String url) {
        return new RemoteWorkspaceFileImpl(url, this);
    }

    @Override
    public <T> void onChanged(@NotNull String url, @NotNull WorkspaceFile.Key<T> key, T value) {
        if (key == RemoteWorkspaceFile.IS_SAVED) {
            if (Objects.equals(value, Boolean.TRUE)) {
                this.myUnsavedFiles.remove(url);
            } else {
                this.myUnsavedFiles.add(url);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.myIndexUri = null;
        this.myCpp20ModuleMapping = null;
        this.myLoadedGraphUri = null;
        this.myCDB = null;
    }
}

