/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.AbstractClangWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFileImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingParseListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingRequestsStorage;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFileListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClangLocalWorkspaceImpl
extends AbstractClangWorkspace<LocalWorkspaceFile>
implements ClangLocalWorkspace,
WorkspaceFileListener,
PendingParseListener {
    static final Logger LOG = Logger.getInstance((String)ClangLocalWorkspaceImpl.class.getName());
    @NotNull
    private final ClangUrlConverter myConverter;
    @NotNull
    private final List<PendingParseListener> myPendingParseListeners = new ArrayList<PendingParseListener>();
    @NotNull
    private final AtomicLong myGlobalVersionCounter = new AtomicLong(0L);

    public ClangLocalWorkspaceImpl(@NotNull ClangUrlConverter converter) {
        this.myConverter = converter;
    }

    @Override
    public void completePendingParses() {
        List<String> urls = this.getRegisteredUrls();
        for (String url : urls) {
            this.modify(url, (WF wf) -> {
                PendingRequestsStorage storage = wf.getOrDefault(LocalWorkspaceFileImpl.REQUESTS_STORAGE);
                storage.forEachPending(cf -> {
                    if (ClangParseResponse.isInDoneState(cf)) {
                        ClangParseResponse.completeAnswers(cf);
                    }
                    return true;
                });
            });
        }
    }

    @Override
    public int getMaxSizeOfPendingParsesQueue() {
        int maxSize = 0;
        for (String url : this.getRegisteredUrls()) {
            int fileQueueSize = this.apply(url, (WF wf) -> wf.getMaxSizeOfPendingParsesQueue());
            if (fileQueueSize <= maxSize) continue;
            maxSize = fileQueueSize;
        }
        return maxSize;
    }

    @Override
    public int getSizeOfPendingParses(@NotNull String url) {
        return this.apply(url, (WF wf) -> wf.getOrDefault(LocalWorkspaceFileImpl.REQUESTS_STORAGE).sizeOfPending());
    }

    @Override
    @NonNls
    @NotNull
    public String printStats(@NonNls @NotNull String linePrefix) {
        return linePrefix + "Registered files number = " + this.getRegisteredUrls().size() + "\n" + linePrefix + "Max size of pending requests queue = " + this.getMaxSizeOfPendingParsesQueue() + "\n" + super.printStats(linePrefix + "Local ");
    }

    @Override
    public void addPendingParseListener(@NotNull PendingParseListener listener) {
        this.myPendingParseListeners.add(listener);
    }

    @Override
    public void onOverflow(@NotNull ClangParseResponse oldest) {
        for (PendingParseListener listener : this.myPendingParseListeners) {
            listener.onOverflow(oldest);
        }
    }

    @Override
    @NotNull
    protected LocalWorkspaceFile createWorkspaceFile(@NotNull String url) {
        return new LocalWorkspaceFileImpl(url, this.myGlobalVersionCounter, this.myConverter, this, this);
    }
}

