/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.navigation;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ChooseByNameContributorEx2;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import icons.CidrLangIcons;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClangGotoByNameContributor
implements ChooseByNameContributorEx2,
GotoClassContributor {
    private static final boolean ourGotoContributorsEnabled = Registry.is((String)"clion.clang.clangd.index.on");
    private final ConcurrentMap<Project, ConcurrentMap<String, Set<CLionSymbolInformation>>> mySymbolsStorage = new ConcurrentHashMap<Project, ConcurrentMap<String, Set<CLionSymbolInformation>>>();

    protected abstract boolean isAcceptableClangSymbol(@NotNull Project var1, @NotNull SymbolInformation var2);

    public void processNames(@NotNull Processor<? super String> processor, @NotNull FindSymbolParameters parameters) {
        List symbols;
        if (!ourGotoContributorsEnabled) {
            return;
        }
        GlobalSearchScope scope = parameters.getSearchScope();
        Project project = Objects.requireNonNull(scope.getProject());
        if (!this.mySymbolsStorage.containsKey(project)) {
            this.mySymbolsStorage.put(project, new ConcurrentHashMap());
            project.getMessageBus().connect().subscribe(PsiModificationTracker.TOPIC, () -> {
                ConcurrentMap projectStorage = (ConcurrentMap)this.mySymbolsStorage.get(project);
                assert (projectStorage != null);
                projectStorage.clear();
            });
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project);
        CompletableFuture<List<CLionSymbolInformation>> symbolsFuture = service.getSymbols(parameters.getLocalPatternName(), false);
        try {
            symbols = (List)CidrConcurrentUtilsKt.waitCancelAware(symbolsFuture, (String)"workspace/symbols");
        }
        catch (ExecutionException ex) {
            CidrLogService.LOG.error((Throwable)ex);
            return;
        }
        if (symbols != null) {
            for (String symName : this.storeIncomingSymbols(project, symbols)) {
                if (processor.process((Object)symName)) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        if (!ourGotoContributorsEnabled) {
            return;
        }
        Project project = Objects.requireNonNull(parameters.getProject());
        Set<CLionSymbolInformation> symbols = this.loadSymbolsForName(project, name);
        if (symbols != null) {
            Set<CLionSymbolInformation> set = symbols;
            synchronized (set) {
                for (CLionSymbolInformation sym : symbols) {
                    if (!this.isAcceptableClangSymbol(project, sym) || processor.process((Object)new ClangSymbolNavigatableItem(parameters.getProject(), sym))) continue;
                    return;
                }
            }
        }
    }

    public final void processNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
    }

    @NotNull
    private Set<String> storeIncomingSymbols(@NotNull Project project, @NotNull List<CLionSymbolInformation> symbols) {
        HashMap<String, List> sortedSymbols = new HashMap<String, List>();
        for (CLionSymbolInformation cLionSymbolInformation : symbols) {
            List listOfSymbols = sortedSymbols.computeIfAbsent(cLionSymbolInformation.getName(), k -> new ArrayList());
            listOfSymbols.add(cLionSymbolInformation);
            sortedSymbols.putIfAbsent(cLionSymbolInformation.getName(), new ArrayList());
        }
        for (Map.Entry entry : sortedSymbols.entrySet()) {
            ConcurrentMap projectStorage = (ConcurrentMap)this.mySymbolsStorage.get(project);
            Set symbolsForName = projectStorage.computeIfAbsent((String)entry.getKey(), key -> Collections.synchronizedSet(new HashSet()));
            symbolsForName.addAll((Collection)entry.getValue());
        }
        return sortedSymbols.keySet();
    }

    @Nullable
    private Set<CLionSymbolInformation> loadSymbolsForName(@NotNull Project project, @NotNull String name) {
        ConcurrentMap projectCache = Objects.requireNonNull((ConcurrentMap)this.mySymbolsStorage.get(project));
        return (Set)projectCache.get(name);
    }

    @Nullable
    public String getQualifiedName(@NotNull NavigationItem item) {
        if (!(item instanceof ClangSymbolNavigatableItem)) {
            return null;
        }
        return ((ClangSymbolNavigatableItem)item).getQualifiedName();
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "::";
    }

    protected static class ClangSymbolNavigatableItem
    implements NavigationItem {
        @NotNull
        private final Project myProject;
        @NotNull
        private final CLionSymbolInformation mySym;

        private ClangSymbolNavigatableItem(@NotNull Project project, @NotNull CLionSymbolInformation sym) {
            this.myProject = project;
            this.mySym = sym;
        }

        @NlsSafe
        public String getName() {
            return this.mySym.getName();
        }

        @NlsSafe
        public String getQualifiedName() {
            return StringUtil.isEmpty((String)this.mySym.getContainerName()) ? this.getName() : this.mySym.getContainerName() + "::" + this.getName();
        }

        @Nullable
        public ItemPresentation getPresentation() {
            return new ClangSymbolPresentation(this.mySym);
        }

        public void navigate(boolean requestFocus) {
            try {
                Document document;
                VirtualFile vf = VfsUtil.findFileByURL((URL)URI.create(this.mySym.getLocation().getUri()).toURL());
                if (vf != null && (document = FileDocumentManager.getInstance().getDocument(vf)) != null) {
                    int offset = document.getLineStartOffset(this.mySym.getLocation().getRange().getStart().getLine());
                    PsiNavigationSupport.getInstance().createNavigatable(this.myProject, vf, offset).navigate(true);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return true;
        }

        public int hashCode() {
            return this.mySym.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClangSymbolNavigatableItem)) {
                return false;
            }
            return this.mySym.equals((Object)((ClangSymbolNavigatableItem)obj).mySym);
        }
    }

    protected static class ClangSymbolPresentation
    implements ItemPresentation {
        @NotNull
        private final CLionSymbolInformation mySym;

        private ClangSymbolPresentation(@NotNull CLionSymbolInformation sym) {
            this.mySym = sym;
        }

        @NlsSafe
        @Nullable
        public String getPresentableText() {
            String signature = this.mySym.getSignature();
            if (!StringUtil.isEmpty((String)signature)) {
                return this.mySym.getName() + signature;
            }
            return this.mySym.getName();
        }

        @NlsSafe
        @Nullable
        public String getLocationString() {
            StringBuilder sb = new StringBuilder();
            if (!StringUtil.isEmpty((String)this.mySym.getReturnType())) {
                sb.append(": ").append(this.mySym.getReturnType()).append(" ");
            }
            sb.append("(");
            if (!StringUtil.isEmpty((String)this.mySym.getContainerName())) {
                sb.append(this.mySym.getContainerName());
            } else {
                String fileName;
                try {
                    URI uri = URI.create(this.mySym.getLocation().getUri());
                    fileName = new File(uri.toURL().getPath()).getName();
                }
                catch (MalformedURLException ex) {
                    fileName = this.mySym.getLocation().getUri();
                }
                sb.append(fileName);
            }
            sb.append(")");
            return sb.toString();
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            return switch (this.mySym.getKind()) {
                case SymbolKind.Namespace -> CidrLangIcons.CodeAssistantNamespace;
                case SymbolKind.Class, SymbolKind.Struct -> CidrLangIcons.CodeAssistantStruct;
                case SymbolKind.Enum -> CidrLangIcons.CodeAssistantEnum;
                case SymbolKind.Constructor, SymbolKind.Function, SymbolKind.Method -> CidrLangIcons.CodeAssistantFunction;
                case SymbolKind.Field -> CidrLangIcons.CodeAssistantField;
                case SymbolKind.Variable -> CidrLangIcons.CodeAssistantGlobal;
                default -> null;
            };
        }
    }
}

