/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.navigation;

import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.navigation.CellRenderer;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClangGotoAction<Psi extends PsiElement> {
    protected static final Logger LOG = Logger.getInstance((String)ClangGotoAction.class.getName());
    @NotNull
    private final SmartPsiElementPointer<Psi> mySource;
    @NotNull
    private @NlsContexts.PopupTitle String myName;
    @NotNull
    private Icon myIcon;

    public ClangGotoAction(@NotNull Psi source, @NotNull @NlsContexts.PopupTitle String name, @NotNull Icon icon) {
        this.mySource = SmartPointerManager.getInstance((Project)source.getProject()).createSmartPsiElementPointer(source);
        this.myName = name;
        this.myIcon = icon;
    }

    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    protected void setIcon(@NotNull Icon icon) {
        this.myIcon = icon;
    }

    @NotNull
    @NlsContexts.PopupTitle
    public String getName() {
        return this.myName;
    }

    protected void setName(@NotNull @NlsContexts.PopupTitle String name) {
        this.myName = name;
    }

    @Nullable
    public Psi getSource() {
        return (Psi)this.mySource.getElement();
    }

    @Nullable
    public abstract Collection<CLionSymbolInformation> getTargets();

    public abstract void navigate(@Nullable MouseEvent var1, @Nullable Editor var2);

    @NotNull
    @NlsContexts.Tooltip
    public String getTooltip(@NotNull PsiElement psiElement) {
        return this.getName();
    }

    @NotNull
    public PsiElementListCellRenderer<PsiElement> createRenderer(@NotNull Psi source, PsiElement @NotNull [] targets) {
        GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(source, targets, Collections.emptyList());
        return new CellRenderer(gotoData);
    }
}

