/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.memory;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsagePanel;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ClangMemoryIndicatorWidgetFactory
implements StatusBarWidgetFactory {
    @NotNull
    public String getId() {
        return "ClangdMemory";
    }

    @NotNull
    public String getDisplayName() {
        return ClangdBundle.message("language.cpp.clangd.memory.usage.widget.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project) {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (!Objects.equals("CPP_MODULE", module.getModuleTypeName())) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project) {
        return new ClangMemoryUsagePanel(project);
    }

    public void disposeWidget(@NotNull StatusBarWidget widget) {
        Disposer.dispose((Disposable)widget);
    }

    public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
        return true;
    }
}

