/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.ServerInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ExtendedServerInfo;", "", "serverInfo", "Lorg/eclipse/lsp4j/ServerInfo;", "(Lorg/eclipse/lsp4j/ServerInfo;)V", "clangMajor", "", "clangMinor", "clangPatch", "clangVersion", "", "intellij.c.clangd"})
public final class ExtendedServerInfo {
    @NotNull
    private final ServerInfo serverInfo;
    private final int clangMajor;
    private final int clangMinor;
    private final int clangPatch;
    @NotNull
    private final String clangVersion;

    public ExtendedServerInfo(@NotNull ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
        Matcher matcher = ClangUtils.VERSION_PATTERN.matcher(this.serverInfo.getVersion());
        if (matcher.matches()) {
            boolean bl;
            String version = matcher.group(1);
            String[] stringArray = new String[]{"."};
            List majorMinorPatch = StringsKt.split$default((CharSequence)version, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean bl2 = bl = majorMinorPatch.size() == 3;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.clangMajor = Integer.parseInt((String)majorMinorPatch.get(0));
            this.clangMinor = Integer.parseInt((String)majorMinorPatch.get(1));
            this.clangPatch = Integer.parseInt((String)majorMinorPatch.get(2));
            this.clangVersion = this.serverInfo.getVersion();
        } else {
            CidrLogService.logOnce((Level)Level.SEVERE, (String)("Failed to parse version string: " + this.serverInfo.getVersion()), (Throwable)new Exception());
            this.clangMajor = 14;
            this.clangMinor = 0;
            this.clangPatch = 0;
            this.clangVersion = "clangd version 14.0.0 (ssh://git@git.jetbrains.team/llvm-project.git 41b6170636aabaa99c5f78e36da3e741212c7190 based on LLVM 42b588a2000e872d63326a623982c75ab5ac28a9 revision)";
        }
    }
}

