/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangPlannedInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public final class ClangSaveRequest
implements ClangPlannedInteraction {
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final String myUrl;

    public ClangSaveRequest(@NotNull ClangDaemonContext context, @NotNull String url) {
        this.myContext = context;
        this.myUrl = url;
    }

    @Override
    @NotNull
    public List<Pair<String, ClangProperty>> getWrittenProperties() {
        return Collections.singletonList(Pair.create((Object)this.myUrl, (Object)((Object)ClangProperty.SavedFlag)));
    }

    @Override
    public void send(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        server.clionDidSave(new DidSaveTextDocumentParams(new TextDocumentIdentifier(this.myContext.getUrlConverter().toUriFromUrl(this.myUrl))));
        this.toNextRemoteState(ws);
    }

    @Override
    public void onSkipped(@NotNull ClangRemoteWorkspace ws) {
        this.toNextRemoteState(ws);
    }

    private void toNextRemoteState(@NotNull ClangRemoteWorkspace ws) {
        ws.modify(this.myUrl, wf -> {
            wf.put(RemoteWorkspaceFile.IS_SAVED, true);
            if (!wf.getOrDefault(RemoteWorkspaceFile.IS_OPENED).booleanValue()) {
                wf.put(RemoteWorkspaceFile.CONTENT, null);
            }
        });
    }
}

