/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import java.io.File;
import java.util.List;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangRequestsHelper {
    @NlsSafe
    @NotNull
    private static final String MACRO_PREDEFINES_BASE_PATH = "/clion_clangd_inmemory_directory/macros";

    private ClangRequestsHelper() {
        throw new AssertionError();
    }

    public static boolean isMacroFile(@NotNull ClangDaemonContext context, @NlsSafe @NotNull String url) {
        return ClangRequestsHelper.isMacroFile(context.getUrlConverter(), url);
    }

    public static boolean isMacroFile(@NotNull ClangUrlConverter converter, @NlsSafe @NotNull String url) {
        return ClangRequestsHelper.isMacroPath(converter.fromUrl(url));
    }

    public static boolean isMacroPath(@NlsSafe @NotNull String path) {
        return path.contains(MACRO_PREDEFINES_BASE_PATH);
    }

    public static boolean isAllowedByGuard(@NotNull ClangDaemonContext context, @NlsSafe @NotNull String url) {
        return !context.getCrashHandler().isBanned(url);
    }

    static boolean isMacroLSPSymbolKind(@Nullable SymbolKind kind) {
        return kind == SymbolKind.Module;
    }

    public static String getMacrosFileUrl(@NotNull ClangDaemonContext context, @NlsSafe @NotNull String url) {
        return VirtualFileManager.constructUrl((String)"file", (String)ClangRequestsHelper.getMacrosFilePath(context, url).getPath());
    }

    @NlsSafe
    @NotNull
    public static File getMacrosFilePath(@NotNull ClangDaemonContext context, @NlsSafe @NotNull String url) {
        if (!context.getUrlConverter().isAcceptable(url)) {
            return new File(SystemInfo.isWindows ? "C:/clion_clangd_inmemory_directory/macros/__wrong_url_" : "/clion_clangd_inmemory_directory/macros/__wrong_url_");
        }
        Object path = context.getUrlConverter().fromUrl(url);
        if (SystemInfo.isWindows) {
            int driveLetterIndex = ClangUrlConverter.findDriveLetter((String)path);
            if (driveLetterIndex >= 0) {
                char driveLetter = ((String)path).charAt(driveLetterIndex);
                path = driveLetter + ":/clion_clangd_inmemory_directory/macros" + (String)(((String)(path = ((String)path).replaceFirst(":", ""))).startsWith("/") ? path : "/" + (String)path);
                return new File((String)path);
            }
            path = "X:/clion_clangd_inmemory_directory/macros" + (String)(((String)path).startsWith("/") ? path : "/" + (String)path);
            return new File((String)path);
        }
        return new File(MACRO_PREDEFINES_BASE_PATH + (String)(((String)path).startsWith("/") ? path : "/" + (String)path));
    }

    public static String getMacrosParentPath() {
        return (SystemInfo.isWindows ? "C:" : "") + MACRO_PREDEFINES_BASE_PATH;
    }

    public static String getQobjectDefsUrl() {
        return "file://" + ClangRequestsHelper.getQobjectDefsPath();
    }

    public static String getQobjectDefsPath() {
        return ClangRequestsHelper.getMacrosParentPath() + "/QtCore/qobjectdefs.h";
    }

    public static boolean containsQtCore(List<String> compileCommand) {
        for (String arg : compileCommand) {
            if (!arg.startsWith("-I") || !arg.contains("QtCore")) continue;
            return true;
        }
        return false;
    }

    public static String getQobjectDefsContent() {
        return "#include_next <qobjectdefs.h>\n#pragma once\n#pragma clang diagnostic push\n#pragma clang diagnostic ignored \"-Wmacro-redefined\"\n#define __CLION_QT_SIGNAL_ANNOTATION __attribute__((annotate(\"signal_from_qt\")))\n#define __CLION_QT_SLOT_ANNOTATION __attribute__((annotate(\"slot_from_qt\")))\n#ifdef signals\n#define signals public __CLION_QT_SIGNAL_ANNOTATION\n#endif\n#ifdef Q_SIGNALS\n#define Q_SIGNALS public __CLION_QT_SIGNAL_ANNOTATION\n#endif\n#ifdef Q_SIGNAL\n#define Q_SIGNAL __CLION_QT_SIGNAL_ANNOTATION\n#endif\n#ifdef slots\n#define slots __CLION_QT_SLOT_ANNOTATION\n#endif\n#ifdef Q_SLOTS\n#define Q_SLOTS __CLION_QT_SLOT_ANNOTATION\n#endif\n#ifdef Q_SLOT\n#define Q_SLOT __CLION_QT_SLOT_ANNOTATION\n#endif\n#ifdef SIGNAL\n#define SIGNAL(arg) qFlagLocation(#arg)\n#endif\n#ifdef SLOT\n#define SLOT(arg) qFlagLocation(#arg)\n#endif\n#pragma clang diagnostic pop\n";
    }
}

