/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionGlobalCompletionCacheParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionWantDiagnostics;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangHeavyRequestBuilder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.io.File;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangReparseNotification
extends ClangFileBasedNotification<ReparseData> {
    @NotNull
    private final ClangParseResponse myResponse;
    @NotNull
    private final String myMacrosUrl;
    @NotNull
    private final File myMacrosPath;
    private final int myMacrosVersion;
    @NotNull
    private final String myMacroDefinitions;

    @NotNull
    public static ClangInteractionPromise createPromise(@NotNull ClangHeavyRequestBuilder builder, @NotNull ClangDaemonContext context, @NotNull VirtualFile virtualFile, @NotNull ClangParseResponse response, @NotNull String macrosUrl, @NotNull File macrosPath, int macrosVersion) {
        CompletableFuture<ClangReparseNotification> futureRequest = builder.later(() -> ClangReparseNotification.create(context, virtualFile, response, macrosUrl, macrosPath, macrosVersion));
        return new ClangInteractionPromiseImpl.Builder<ClangReparseNotification>(ClangReparseNotification.class, futureRequest).addReadAccessedProperties(response.getUrl(), ClangProperty.Content).addReadAccessedProperties(macrosUrl, ClangProperty.Content).addWriteAccessedProperties(response.getUrl(), ClangProperty.Ast).addRejectedHandler(() -> ClangLanguageServiceUtils.finishOperation(response, false)).create();
    }

    @Nullable
    private static ClangReparseNotification create(@NotNull ClangDaemonContext context, @NotNull VirtualFile virtualFile, @NotNull ClangParseResponse response, @NotNull String macrosUrl, @NotNull File macrosPath, int macrosVersion) {
        if (context.getProject().isDisposed()) {
            return null;
        }
        Project project = context.getProject();
        String url = response.getUrl();
        String targetURI = context.getUrlConverter().toUri(virtualFile);
        int version = response.getVersion();
        boolean cancellable = response.isCancellable();
        if (ClangRequestsHelper.isAllowedByGuard(context, url)) {
            String macros;
            ClionCompileCommandParams compileParams;
            Trustworthiness trustworthiness;
            ClangdCompilationCommand cc = context.getIdeFacade().getCompilationCommand(context.getUrlConverter(), project, virtualFile, macrosPath.getPath(), Cpp20ModulesContext.create(context));
            if (cc != null) {
                trustworthiness = cc.trustworthiness;
                compileParams = cc.ccParams;
                macros = cc.ppDefines;
                if (!ContainerUtil.exists(compileParams.getCommandLine(), arg -> arg.startsWith("--target="))) {
                    trustworthiness = trustworthiness.with(4);
                }
            } else {
                trustworthiness = ClangdBridge.isClangdOnlyMode() ? new Trustworthiness() : new Trustworthiness(1);
                compileParams = new ClionCompileCommandParams(targetURI, targetURI, "", Collections.emptyList(), "/dev/null", true);
                macros = "";
            }
            response.putUserData(ClangParseResponse.TRUSTWORTHINESS, trustworthiness);
            ClionClangTidyConfigParams clangTidyConfig = context.getIdeFacade().getClangTidyConfig(project, virtualFile);
            UnusedIncludesInspectionMode unusedInspectionMode = context.getIdeFacade().getUnusedIncludesInspectionMode(project, virtualFile);
            CLionClazyConfigParams clazyConfig = context.getIdeFacade().getClazyConfig(project, virtualFile);
            ClionWantDiagnostics WantDiags = cancellable ? ClionWantDiagnostics.Auto : ClionWantDiagnostics.Yes;
            ClionClangDFAConfigParams dfaOptions = context.getIdeFacade().getDFAOptions(project, virtualFile);
            ClionGlobalCompletionCacheParams globalCompletionCacheParams = context.getIdeFacade().getGlobalCompletionCacheParams(project, virtualFile);
            VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
            docId.setUri(targetURI);
            docId.setVersion(Integer.valueOf(version));
            ClionReparseTextDocumentParams params = new ClionReparseTextDocumentParams(docId, compileParams, clangTidyConfig, unusedInspectionMode, clazyConfig, WantDiags, dfaOptions, globalCompletionCacheParams, response.getPreambleVersion());
            if (!globalCompletionCacheParams.getEnabled()) {
                response.getCompletionCacheReady().complete(false);
            }
            if (dfaOptions == null) {
                response.getDFAInput().complete(null);
            }
            ReparseData reparseData = new ReparseData(context, url, params);
            return new ClangReparseNotification(context, response, reparseData, macrosUrl, macrosPath, macrosVersion, StringUtil.notNullize((String)macros));
        }
        if (ClangDebugLevel.isWarnOrMore()) {
            CidrLogService.logOnce((Level)Level.WARNING, (String)("File [" + url + "] was banned!"), (Throwable)new Exception());
        }
        return null;
    }

    private ClangReparseNotification(@NotNull ClangDaemonContext context, @NotNull ClangParseResponse response, @NotNull ReparseData data, @NotNull String macrosUrl, @NotNull File macrosPath, int macrosVersion, @NotNull String macroDefinitions) {
        super(context, response.getUrl(), response.getVersion(), true, data);
        this.myResponse = response;
        this.myMacrosUrl = macrosUrl;
        this.myMacrosPath = macrosPath;
        this.myMacrosVersion = macrosVersion;
        this.myMacroDefinitions = macroDefinitions;
    }

    private static void sendQObjectDefsIfRequired(ClangDaemonContext context, @NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (ws.apply(ClangRequestsHelper.getQobjectDefsUrl(), rf -> rf.getContent()) != null) {
            return;
        }
        VersionedTextDocumentIdentifier docIdQobject = new VersionedTextDocumentIdentifier();
        docIdQobject.setUri(context.getUrlConverter().toUri(new File(ClangRequestsHelper.getQobjectDefsPath()), false));
        docIdQobject.setVersion(Integer.valueOf(0));
        TextDocumentContentChangeEvent changeEventQobject = new TextDocumentContentChangeEvent();
        changeEventQobject.setText(ClangRequestsHelper.getQobjectDefsContent());
        ClangChangeNotification.create(context, ClangRequestsHelper.getQobjectDefsUrl(), 0, new DidChangeTextDocumentParams(docIdQobject, Collections.singletonList(changeEventQobject)), false).send(server, ws);
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        assert (ws.isOpenedRemotely(this.myUrl));
        if (ClangDebugLevel.isWarnOrMore()) {
            ClangUtils.warnClangd(LOG, "Reparsing file " + this.myUrl + " of version " + ((ReparseData)this.myParams).params.getTextDocument().getVersion());
        }
        this.myContext.getTelemetry().getGeneralTelemetry().notifyReparseSent(this);
        String prevMacrosContent = ws.apply(this.myMacrosUrl, rf -> rf.getContent());
        if (!Objects.equals(prevMacrosContent, this.myMacroDefinitions)) {
            VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
            docId.setUri(this.myContext.getUrlConverter().toUri(this.myMacrosPath, false));
            docId.setVersion(Integer.valueOf(this.myMacrosVersion));
            TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
            changeEvent.setText(this.myMacroDefinitions);
            ClangChangeNotification.create(this.myContext, this.myMacrosUrl, this.myMacrosVersion, new DidChangeTextDocumentParams(docId, Collections.singletonList(changeEvent)), false).send(server, ws);
        }
        if (ClangRequestsHelper.containsQtCore(((ReparseData)this.myParams).params.getCompilationCommand().getCommandLine())) {
            ClangReparseNotification.sendQObjectDefsIfRequired(this.myContext, server, ws);
        }
        if (ClangReparseNotification.doSend(server, (ReparseData)this.myParams)) {
            ClangLanguageServiceUtils.finishOperation(this.myResponse, true);
            return true;
        }
        return false;
    }

    @Override
    public void onSkipped(@NotNull ClangRemoteWorkspace ws) {
        super.onSkipped(ws);
        ClangLanguageServiceUtils.finishOperation(this.myResponse, false);
    }

    @Override
    public void onRejected() {
        super.onRejected();
        ClangLanguageServiceUtils.finishOperation(this.myResponse, false);
    }

    @Override
    protected void toNextRemoteState(@NotNull ClangRemoteWorkspace ws, @NotNull ReparseData params) {
        super.toNextRemoteState(ws, params);
        this.myResponse.putUserData(ClangParseResponse.UNSAVED_FILES, ws.getUnsavedFiles());
    }

    @Override
    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull ReparseData params) {
        super.toNextRemoteState(wf, params);
        wf.put(RemoteWorkspaceFile.REMOTE_COMPILATION_COMMAND, params.params);
    }

    static boolean doSend(@NotNull ClangServer server, @NotNull ReparseData data) {
        server.clionReparse(data.params);
        return true;
    }

    static class ReparseData {
        @NotNull
        public final ClangDaemonContext context;
        @NotNull
        public final String url;
        @NotNull
        public final ClionReparseTextDocumentParams params;

        ReparseData(@NotNull ClangDaemonContext context, @NotNull String url, @NotNull ClionReparseTextDocumentParams params) {
            this.context = context;
            this.url = url;
            this.params = params;
        }
    }
}

