/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestBuilder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface ClangInteraction {
    public static final Logger LOG = Logger.getInstance((String)ClangInteraction.class.getName());

    public void send(@NotNull ClangServer var1, @NotNull ClangRemoteWorkspace var2);

    default public void onSkipped(@NotNull ClangRemoteWorkspace ws) {
    }

    default public void onRejected() {
    }

    @NonNls
    default public String getName() {
        return this.getClass().getSimpleName();
    }

    default public boolean requiresRecover() {
        return false;
    }

    @NotNull
    public static ClangRequestBuilder newInteraction(@NonNls @NotNull String requestDescription) {
        return new ClangRequestBuilder(requestDescription);
    }

    @NotNull
    public static ClangInteraction createSimple(@NonNls @NotNull String requestDescription, @NotNull Consumer<? super ClangServer> action) {
        return ClangInteraction.createSimple(requestDescription, action, false);
    }

    @NotNull
    public static ClangInteraction createSimple(@NonNls @NotNull String requestDescription, @NotNull Consumer<? super ClangServer> action, boolean recover) {
        return ClangInteraction.newInteraction(requestDescription).action(action).requiresRecover(recover).create();
    }
}

