/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangPreprocessedReport;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ThrowableFunction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContextImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClient;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClientAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCheckPreprocessedCaseParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClangPreprocessResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCompletionCacheReadyParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionDocumentRangeFormattingParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionWorkspaceSymbolParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangdInlayHint;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCancelParseParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFileStats;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDFAInputsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishHighlightingsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishTidyDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionWantDiagnostics;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.InlayHintsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.CLangdCrashCollector;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLine;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLineArgument;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCrashReporter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.TextDocumentServiceAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangCrashHandler {
    public static Key<ClangCrashReporter> CRASH_REPORTER_KEY = Key.create((String)"CLANG_CRASH_REPORTER");
    private static final Logger LOG = Logger.getInstance(ClangCrashHandler.class);
    private static final int FAILURES_THRESHOLD = 2;
    private static final int PENDING_FUTURES_THRESHOLD = 4096;
    private static final long DONT_NOTIFY_CRASH_INTERVAL_MS = 300000L;
    @NotNull
    private static final AtomicBoolean ourCrashReporterRunning = new AtomicBoolean(false);
    @NotNull
    private static final ExecutorService ourCrashReporterService = ConcurrencyUtil.newSingleThreadExecutor((String)"Clang crash reporter");
    @NotNull
    private final Map<ActionType, Long> myCrashReport2Timestamp = new HashMap<ActionType, Long>();
    @NotNull
    private final Map<ActionType, Integer> myCrashReason2Counter = new HashMap<ActionType, Integer>();
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final ClangCrashReporter myReporter = new DefaultClangCrashReporter();
    @NotNull
    private final PendingInteractions myPendingInteractions = new PendingInteractions();
    @NotNull
    private final Cache<String, Integer> myTrackedFailures = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    @NotNull
    private final AtomicInteger myCookieGenerator = new AtomicInteger(0);
    @NotNull
    private final AtomicBoolean myHadCrashes = new AtomicBoolean(false);

    public ClangCrashHandler(@NotNull ClangDaemonContext context) {
        this.myContext = context;
    }

    public boolean hadCrashes() {
        return this.myHadCrashes.get();
    }

    public boolean isBanned(@NotNull String url) {
        if (ClangCrashHandler.isBlacklistEnabled() && this.myContext.getUrlConverter().isAcceptable(url)) {
            String uri = this.myContext.getUrlConverter().toUriFromUrl(url);
            Integer numOfFailures = (Integer)this.myTrackedFailures.getIfPresent((Object)uri);
            return numOfFailures != null && numOfFailures >= 2;
        }
        return false;
    }

    private static boolean isBlacklistEnabled() {
        return Registry.is((String)"clion.clang.clangd.blacklist");
    }

    public boolean hasPendingInteractions() {
        return !this.myPendingInteractions.empty();
    }

    public void onServerFailure() {
        this.myHadCrashes.set(true);
        ArrayList<PendingParse> pendingParses = new ArrayList<PendingParse>();
        ArrayList<PendingRequest> pendingRequests = new ArrayList<PendingRequest>();
        this.myPendingInteractions.runAndClear((parsesMapping, requestsMapping) -> {
            for (Map.Entry uriAndParses : parsesMapping.entrySet()) {
                SortedMap parses = (SortedMap)uriAndParses.getValue();
                if (parses.isEmpty()) continue;
                pendingParses.add((PendingParse)parses.values().iterator().next());
            }
            HashMap<String, PendingRequest> uriToFirstRequest = new HashMap<String, PendingRequest>();
            for (PendingRequest request : requestsMapping.values()) {
                PendingRequest existing = uriToFirstRequest.computeIfAbsent(request.uri, u -> request);
                if (existing == request || !request.before(existing)) continue;
                uriToFirstRequest.put(request.uri, request);
            }
            pendingRequests.addAll(uriToFirstRequest.values());
        });
        this.reportCrash(pendingParses, pendingRequests);
        List<String> newBannedFiles = this.updatedCrashTracker(pendingParses, pendingRequests);
        if (!newBannedFiles.isEmpty() && ClangCrashHandler.isBlacklistEnabled() && ClangDebugLevel.isWarnOrMore()) {
            Notifications.Bus.notify((Notification)new BannedNotification(newBannedFiles), (Project)this.myContext.getProject());
        }
    }

    void reportCrash(@NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        CLangdCrashCollector.TOTAL.log();
        if (!ourCrashReporterRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            ourCrashReporterService.execute(() -> {
                try {
                    BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myContext, () -> {
                        if (this.myContext.isIndexer()) {
                            ClangCrashHandler.doSimpleCrashReport(this.myContext, this.getCrashReporter(), pendingParses, pendingRequests);
                        } else if (!pendingParses.isEmpty() || !pendingRequests.isEmpty()) {
                            Set<String> filesCausedCrash = ClangCrashHandler.getCandidatesCausedCrash(pendingParses, pendingRequests);
                            if (!filesCausedCrash.isEmpty() && Registry.is((String)"clion.clang.clangd.crash_reports")) {
                                this.doAdvancedCrashReport(filesCausedCrash, pendingParses, pendingRequests);
                            } else {
                                ClangCrashHandler.doSimpleCrashReport(this.myContext, this.getCrashReporter(), pendingParses, pendingRequests);
                            }
                            this.investigateCrash(pendingParses, pendingRequests);
                        }
                    });
                }
                finally {
                    ourCrashReporterRunning.set(false);
                }
            });
        }
        catch (Throwable thr) {
            ourCrashReporterRunning.set(false);
        }
    }

    private void investigateCrash(@NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        EnumSet<ActionType> crashReasons = EnumSet.noneOf(ActionType.class);
        for (PendingParse parse : pendingParses) {
            ActionType crashReason = parse.getWhomToBlame();
            if (crashReason == null) continue;
            crashReasons.add(crashReason);
        }
        for (PendingRequest pendingReq : pendingRequests) {
            if (!pendingReq.type.isDangerous() || pendingReq.type.myActionType == null) continue;
            crashReasons.add(pendingReq.type.myActionType);
        }
        for (ActionType whatCrashed : crashReasons) {
            ActionDisabler disabler;
            long timeSinceLastReport;
            int crashCounter = this.myCrashReason2Counter.merge(whatCrashed, 1, Integer::sum);
            switch (whatCrashed) {
                case CLANG_TIDY: 
                case CLION_CLANG_TIDY: {
                    CLangdCrashCollector.TIDY.log();
                    break;
                }
                case INLAY_HINTS: {
                    CLangdCrashCollector.NAME_HINTS.log();
                }
            }
            Long lastReportTs = this.myCrashReport2Timestamp.get((Object)whatCrashed);
            long currentTs = System.currentTimeMillis();
            long l = timeSinceLastReport = lastReportTs != null ? currentTs - lastReportTs : Long.MAX_VALUE;
            if (timeSinceLastReport < 300000L) {
                return;
            }
            if (crashCounter < whatCrashed.beforeDisableCrashCount || whatCrashed.disablerSupplier == null || !(disabler = whatCrashed.disablerSupplier.get()).disable(this.myContext.getProject())) continue;
            ClangCrashHandler.notifyDisabled(ClangdBundle.message(whatCrashed.nameKey, new Object[0]), () -> disabler.enableBack(this.myContext.getProject()));
            this.myCrashReport2Timestamp.put(whatCrashed, currentTs);
            this.myCrashReason2Counter.put(whatCrashed, 0);
        }
    }

    @NotNull
    private ClangCrashReporter getCrashReporter() {
        ClangCrashReporter crashReporter = (ClangCrashReporter)this.myContext.getProject().getUserData(CRASH_REPORTER_KEY);
        return crashReporter != null ? crashReporter : this.myReporter;
    }

    private static void notifyDisabled(@Nls @NotNull String what, final @NotNull Runnable rollback) {
        NotificationAction keepDisabledAction = new NotificationAction(ClangdBundle.message("language.cpp.clangd.disable.keep", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                notification.expire();
            }
        };
        NotificationAction rollbackAction = new NotificationAction(ClangdBundle.message("language.cpp.clangd.disable.rollback", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                notification.expire();
                rollback.run();
            }
        };
        Notification notification = new Notification("System Messages", ClangdBundle.message("language.cpp.clangd.disable.title", what), ClangdBundle.message("language.cpp.clangd.disable.message", what), NotificationType.INFORMATION);
        notification.addAction((AnAction)keepDisabledAction);
        notification.addAction((AnAction)rollbackAction);
        Notifications.Bus.notify((Notification)notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<String> updatedCrashTracker(@NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        Set<String> filesCausedCrash = ClangCrashHandler.getCandidatesCausedCrash(pendingParses, pendingRequests);
        if (filesCausedCrash.isEmpty()) {
            assert (pendingParses.isEmpty()) : "Why there are no affected files, if there are pending parses?";
            for (PendingRequest pendingRequest : pendingRequests) {
                if (pendingRequest.uri == null) continue;
                filesCausedCrash.add(pendingRequest.uri);
            }
        }
        ArrayList<String> newBannedFiles = new ArrayList<String>();
        Cache<String, Integer> cache = this.myTrackedFailures;
        synchronized (cache) {
            for (String uri : filesCausedCrash) {
                Integer numOfFailures = (Integer)this.myTrackedFailures.getIfPresent((Object)uri);
                numOfFailures = numOfFailures != null ? numOfFailures + 1 : 1;
                this.myTrackedFailures.put((Object)uri, (Object)numOfFailures);
                if (numOfFailures != 2) continue;
                newBannedFiles.add(uri);
            }
        }
        return newBannedFiles;
    }

    public void onServerStop() {
        this.myPendingInteractions.clear();
    }

    private void doAdvancedCrashReport(@NotNull Set<String> filesCausedCrash, @NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        assert (!filesCausedCrash.isEmpty()) : "Why generating advanced report if there are no candidates to preprocess?";
        String advancedCrashMessage = ClangCrashHandler.getCrashMessage(ClangdBundle.message("language.cpp.clangd.crash.message", new Object[0]), pendingParses, pendingRequests);
        List urls = ContainerUtil.map(filesCausedCrash, uri -> this.myContext.getUrlConverter().fromUriToUrl((String)uri));
        boolean success = this.withCrashLanguageService(urls, crashService -> {
            long startTime = System.nanoTime();
            CompletableFuture<ClangPreprocessedReport> reportFuture = crashService.generatePreprocessedReport(urls);
            ClangPreprocessedReport report = (ClangPreprocessedReport)CidrConcurrentUtilsKt.waitCancelAware(reportFuture, (String)"crash report");
            if (report == null) {
                return false;
            }
            long reportTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            LOG.warn("Making crash report took " + reportTime + "ms");
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            StringBuilder compilationInfoBuilder = new StringBuilder();
            for (ClangPreprocessedReport.PreprocessedFile preprocessedFile : report.getPreprocessedFiles()) {
                if (compilationInfoBuilder.length() > 0) {
                    compilationInfoBuilder.append("\n\n\n");
                }
                Obfuscator obfuscator = !PluginManagerCore.isRunningFromSources() && !ApplicationManager.getApplication().isUnitTestMode() ? ClangdBridge.getObfuscator() : null;
                compilationInfoBuilder.append(preprocessedFile.getCompilationInfoAsString(obfuscator));
                attachments.add(new Attachment("preprocessed-" + PathUtilRt.getFileName((String)preprocessedFile.getTargetPath(obfuscator)), preprocessedFile.getContent(obfuscator)));
            }
            if (attachments.isEmpty()) {
                return false;
            }
            attachments.add(0, new Attachment("compilation-info.txt", compilationInfoBuilder.toString()));
            this.getCrashReporter().report(advancedCrashMessage, attachments);
            return true;
        });
        if (!success) {
            ClangCrashHandler.doSimpleCrashReport(this.myContext, this.getCrashReporter(), pendingParses, pendingRequests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean withCrashLanguageService(@NotNull List<String> urls, @NotNull ThrowableFunction<ClangLanguageService, Boolean, Exception> crashServiceConsumer) {
        boolean bl;
        block12: {
            ClangDaemonContextImpl crashContext;
            block10: {
                HashSet<String> crashedUrls = new HashSet<String>(urls);
                crashContext = null;
                ClangdLanguageService service = null;
                try {
                    crashContext = new ClangDaemonContextImpl.Builder("crash", this.myContext.getProject()).create();
                    ClangRemoteWorkspace crashRemoteWorkspace = crashContext.getRemoteWorkspace();
                    List<String> allRegisteredUrls = this.myContext.getRemoteWorkspace().getRegisteredUrls();
                    this.myContext.getRemoteWorkspace().modify(allRegisteredUrls, mapOfFiles -> mapOfFiles.forEach((url, rf) -> {
                        if (crashedUrls.contains(url)) {
                            crashRemoteWorkspace.modify((String)url, crf -> {
                                crf.put(RemoteWorkspaceFile.VERSION, 0);
                                crf.put(RemoteWorkspaceFile.IS_OPENED, rf.isOpened());
                                crf.put(RemoteWorkspaceFile.REMOTE_RECOVERED_COMPILATION_COMMAND, rf.getReparseParams());
                                crf.put(RemoteWorkspaceFile.IS_SAVED, rf.isSaved());
                                crf.put(RemoteWorkspaceFile.CONTENT, rf.getContent());
                            });
                        } else if (!rf.isSaved()) {
                            crashRemoteWorkspace.modify((String)url, crf -> {
                                crf.put(RemoteWorkspaceFile.VERSION, 0);
                                crf.put(RemoteWorkspaceFile.IS_SAVED, false);
                                crf.put(RemoteWorkspaceFile.CONTENT, rf.getContent());
                            });
                        }
                    }));
                    service = new ClangdLanguageService(crashContext);
                    bl = crashServiceConsumer.apply(service);
                    if (service == null) break block10;
                }
                catch (Throwable thr) {
                    boolean bl2;
                    block13: {
                        block11: {
                            try {
                                if (!(thr instanceof ControlFlowException)) {
                                    LOG.error(thr);
                                }
                                bl2 = false;
                                if (service == null) break block11;
                            }
                            catch (Throwable throwable) {
                                if (service != null) {
                                    ClangCrashHandler.stopService(service);
                                } else if (crashContext != null) {
                                    Disposer.dispose(crashContext);
                                }
                                throw throwable;
                            }
                            ClangCrashHandler.stopService(service);
                            break block13;
                        }
                        if (crashContext != null) {
                            Disposer.dispose((Disposable)crashContext);
                        }
                    }
                    return bl2;
                }
                ClangCrashHandler.stopService(service);
                break block12;
            }
            if (crashContext != null) {
                Disposer.dispose((Disposable)crashContext);
            }
        }
        return bl;
    }

    private static void stopService(@NotNull ClangLanguageService service) {
        ClangStopData stopData = service.stop();
        try {
            stopData.exitCode.get(450L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.warn((Throwable)ex);
        }
        catch (TimeoutException ex) {
            LOG.info((Throwable)ex);
            stopData.killRunnable.run();
        }
    }

    private static void doSimpleCrashReport(@NotNull ClangDaemonContext ctx, @NotNull ClangCrashReporter reporter, @NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        String title = ctx.isIndexer() ? ClangdBundle.message("language.cpp.clangd.indexer.crash.message.simple", new Object[0]) : ClangdBundle.message("language.cpp.clangd.crash.message.simple", new Object[0]);
        String crashMessage = ClangCrashHandler.getCrashMessage(title, pendingParses, pendingRequests);
        reporter.report(crashMessage, null);
    }

    @NotNull
    private static String getCrashMessage(@NotNull String title, @NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        String pendingParsesText = !pendingParses.isEmpty() ? ClangdBundle.message("language.cpp.clangd.crash.parses.message", pendingParses.stream().map(r -> r.displayText()).collect(Collectors.joining("\n"))) + "\n" : "";
        String pendingRequestsText = !pendingRequests.isEmpty() ? ClangdBundle.message("language.cpp.clangd.crash.requests.message", pendingRequests.stream().map(r -> r.displayText()).collect(Collectors.joining("\n"))) : "";
        return title + "\n" + pendingParsesText + pendingRequestsText;
    }

    @NotNull
    private static Set<String> getCandidatesCausedCrash(@NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        HashSet<String> candidates = new HashSet<String>();
        for (PendingParse pendingParse : pendingParses) {
            candidates.add(pendingParse.uri);
        }
        for (PendingRequest pendingRequest : pendingRequests) {
            if (pendingRequest.uri == null || !pendingRequest.type.isDangerous()) continue;
            candidates.add(pendingRequest.uri);
        }
        return candidates;
    }

    @NotNull
    public ClangClient spyOn(@NotNull ClangClient client) {
        return new ClangClientSpy(client);
    }

    @NotNull
    public ClangServer spyOn(@NotNull ClangServer server) {
        return new ClangServerSpy(server);
    }

    @NonNls
    @NotNull
    public String printStats(@NonNls @NotNull String linePrefix) {
        return this.myPendingInteractions.printStats(linePrefix);
    }

    private static final class DefaultClangCrashReporter
    implements ClangCrashReporter {
        private DefaultClangCrashReporter() {
        }

        @Override
        public void report(@NotNull String message, @Nullable List<Attachment> attachments) {
            if (attachments != null) {
                LOG.error(message, attachments.toArray(Attachment.EMPTY_ARRAY));
            } else if (ApplicationManager.getApplication().isInternal()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
        }
    }

    private static class PendingInteractions {
        private static final int MAX_PENDING_SIZE = 1024;
        @NotNull
        private final Object myLock = new Object();
        @NotNull
        private final Map<String, SortedMap<Integer, PendingParse>> myPendingParses = new HashMap<String, SortedMap<Integer, PendingParse>>();
        @NotNull
        private final IdentityHashMap<CompletableFuture<?>, PendingRequest> myPendingRequests = new IdentityHashMap();
        private int myMaxPendingParsesNumber = 0;
        private int myMaxPendingRequestsNumber = 0;
        private int myPendingParsesNumber = 0;

        private PendingInteractions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addPendingParse(int cookie, @NotNull ClionReparseTextDocumentParams params) {
            String uri = params.getTextDocument().getUri();
            int version = params.getTextDocument().getVersion();
            Object object = this.myLock;
            synchronized (object) {
                Map subMap = this.myPendingParses.computeIfAbsent(uri, u -> new TreeMap());
                if (subMap.size() > 1024) {
                    LOG.warn("Blacklist: too many pending parses to track, clearing now.\nThe first request: " + ((PendingParse)subMap.values().iterator().next()).displayText());
                    subMap.clear();
                    this.myPendingParsesNumber = this.myPendingParses.values().stream().map(versions -> versions.size()).reduce(0, Integer::sum);
                }
                if (subMap.put(version, new PendingParse(cookie, this, params)) == null) {
                    ++this.myPendingParsesNumber;
                }
                this.myMaxPendingParsesNumber = Math.max(this.myMaxPendingParsesNumber, subMap.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removePendingParse(@NotNull String uri, int version) {
            Object object = this.myLock;
            synchronized (object) {
                Map subMap = this.myPendingParses.get(uri);
                if (subMap != null && subMap.remove(version) != null) {
                    --this.myPendingParsesNumber;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        PendingParse findPendingParse(@NotNull String uri, int version) {
            Object object = this.myLock;
            synchronized (object) {
                Map subMap = this.myPendingParses.get(uri);
                return subMap != null ? (PendingParse)subMap.get(version) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean empty() {
            Object object = this.myLock;
            synchronized (object) {
                assert (this.myPendingParsesNumber >= 0) : "Pending parses number < 0?";
                return this.myPendingRequests.isEmpty() && this.myPendingParsesNumber == 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runAndClear(@NotNull BiConsumer<Map<String, SortedMap<Integer, PendingParse>>, Map<CompletableFuture<?>, PendingRequest>> consumer) {
            ArrayList pendingFutures;
            Iterator iterator = this.myLock;
            synchronized (iterator) {
                pendingFutures = new ArrayList(this.myPendingRequests.keySet());
                consumer.accept(this.myPendingParses, this.myPendingRequests);
                this.myPendingParses.clear();
                this.myPendingRequests.clear();
                this.myPendingParsesNumber = 0;
            }
            for (CompletableFuture completableFuture : pendingFutures) {
                completableFuture.complete(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            ArrayList pendingFutures;
            Iterator iterator = this.myLock;
            synchronized (iterator) {
                pendingFutures = new ArrayList(this.myPendingRequests.keySet());
                this.myPendingParses.clear();
                this.myPendingRequests.clear();
                this.myPendingParsesNumber = 0;
            }
            for (CompletableFuture completableFuture : pendingFutures) {
                completableFuture.complete(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> CompletableFuture<T> trackFuture(@NotNull CompletableFuture<T> response, @NotNull PendingRequest request) {
            boolean warnThresholdExceeded = false;
            Object object = this.myLock;
            synchronized (object) {
                if (this.myPendingRequests.size() >= 4096) {
                    warnThresholdExceeded = true;
                    this.myPendingRequests.clear();
                }
                this.myPendingRequests.put(response, request);
                this.myMaxPendingRequestsNumber = Math.max(this.myMaxPendingRequestsNumber, this.myPendingRequests.size());
            }
            response.whenComplete((res, ex) -> {
                Object object = this.myLock;
                synchronized (object) {
                    this.myPendingRequests.remove(response);
                }
            });
            if (warnThresholdExceeded) {
                LOG.warn("Exceeded amount of tracked requests (4096), clearing pending requests");
            }
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNls
        @NotNull
        String printStats(@NonNls @NotNull String linePrefix) {
            Object object = this.myLock;
            synchronized (object) {
                return linePrefix + "seen files number = " + this.myPendingParses.size() + "\n" + linePrefix + "pending files number = " + this.myPendingParses.values().stream().filter(versions -> !versions.isEmpty()).count() + "\n" + linePrefix + "max pending versions number = " + this.myMaxPendingParsesNumber + "\n" + linePrefix + "pending requests number = " + this.myPendingRequests.size() + "\n" + linePrefix + "max pending requests number = " + this.myMaxPendingRequestsNumber + "\n";
            }
        }
    }

    private static final class BannedNotification
    extends Notification {
        private BannedNotification(@NotNull List<String> banned) {
            super("System Messages", ClangdBundle.message("language.cpp.clangd.blacklist.title", new Object[0]), ClangdBundle.message("language.cpp.clangd.blacklist.description", banned), NotificationType.INFORMATION);
        }
    }

    static enum ActionType {
        PARSING("clangd.crash.reason.parsing", Integer.MAX_VALUE, null),
        HIGHLIGHTINGS("clangd.crash.reason.highlightings", Integer.MAX_VALUE, null),
        COMPLETION_CACHE("clangd.crash.reason.completion.cache", Integer.MAX_VALUE, null),
        DFA_INPUT("clangd.crash.reason.dfa", 2, () -> new ActionDisabler(){
            final List<Class<? extends OCInspectionBase>> myDisabledClasses = new ArrayList<Class<? extends OCInspectionBase>>();

            @Override
            public boolean disable(@NotNull Project project) {
                this.myDisabledClasses.addAll(OCInspectionUtil.setClangdDFADisabled((Project)project));
                return !this.myDisabledClasses.isEmpty();
            }

            @Override
            public void enableBack(@NotNull Project project) {
                if (!this.myDisabledClasses.isEmpty()) {
                    for (Class<? extends OCInspectionBase> cls : this.myDisabledClasses) {
                        OCInspectionUtil.setInspectionEnabled((Project)project, cls, (boolean)true);
                    }
                    this.myDisabledClasses.clear();
                }
            }
        }),
        INLAY_HINTS("clangd.crash.reason.inlay_hints", 2, () -> new ActionDisabler(){

            @Override
            public boolean disable(@NotNull Project project) {
                if (ClangdBridge.getParameterHints(project)) {
                    ClangdBridge.setParameterHints(project, false);
                    return true;
                }
                return false;
            }

            @Override
            public void enableBack(@NotNull Project project) {
                ClangdBridge.setParameterHints(project, true);
            }
        }),
        CLAZY("clangd.crash.reason.clazy", 2, () -> new ActionDisabler(){

            @Override
            public boolean disable(@NotNull Project project) {
                OCInspectionUtil.setInspectionEnabled((Project)project, ClangdBridge.getClazyInspection(), (boolean)false);
                return true;
            }

            @Override
            public void enableBack(@NotNull Project project) {
                OCInspectionUtil.setInspectionEnabled((Project)project, ClangdBridge.getClazyInspection(), (boolean)true);
            }
        }),
        CLION_CLANG_TIDY("clangd.crash.reason.clion.clang.tidy", 1, () -> new ActionDisabler(){

            @Override
            public boolean disable(@NotNull Project project) {
                if (ClangdSettings.getInstance(project).isClangTidyViaClangd()) {
                    ClangdSettings.getInstance(project).setClangTidyViaClangd(false);
                    return true;
                }
                return false;
            }

            @Override
            public void enableBack(@NotNull Project project) {
                ClangdSettings.getInstance(project).setClangTidyViaClangd(true);
            }
        }),
        CLANG_TIDY("clangd.crash.reason.clang.tidy", 1, () -> new ActionDisabler(){

            @Override
            public boolean disable(@NotNull Project project) {
                if (ClangdSettings.getInstance(project).isClangTidyViaClangd()) {
                    ClangdSettings.getInstance(project).setClangTidyViaClangd(false);
                    return true;
                }
                return false;
            }

            @Override
            public void enableBack(@NotNull Project project) {
                ClangdSettings.getInstance(project).setClangTidyViaClangd(true);
            }
        });

        @NonNls
        @NotNull
        final String nameKey;
        final int beforeDisableCrashCount;
        @Nullable
        final Supplier<ActionDisabler> disablerSupplier;

        private ActionType(@Nullable String nameKey, int beforeDisableCrashCount, Supplier<ActionDisabler> disablerSupplier) {
            this.nameKey = nameKey;
            this.beforeDisableCrashCount = beforeDisableCrashCount;
            this.disablerSupplier = disablerSupplier;
        }
    }

    private static class PendingParse
    extends AbstractPending {
        @NotNull
        public final String uri;
        public final int version;
        @NotNull
        public final CompletableFuture<ResultState> compilerDiagsState = new CompletableFuture();
        @NotNull
        public final CompletableFuture<ResultState> highlightingsState = new CompletableFuture();
        @NotNull
        public final CompletableFuture<ResultState> DFAInputState = new CompletableFuture();
        @NotNull
        public final CompletableFuture<ResultState> CLionClangTidyState = new CompletableFuture();
        @NotNull
        public final CompletableFuture<ResultState> clazyState = new CompletableFuture();
        @NotNull
        public final CompletableFuture<ResultState> clangTidyState = new CompletableFuture();
        @NotNull
        public final CompletableFuture<ResultState> completionCacheState = new CompletableFuture();

        PendingParse(int cookie, @NotNull PendingInteractions parses, @NotNull ClionReparseTextDocumentParams params) {
            super(cookie);
            this.uri = params.getTextDocument().getUri();
            this.version = params.getTextDocument().getVersion();
            if (!PendingParse.waitForCompilerDiags(params)) {
                this.compilerDiagsState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForHighlightings(params)) {
                this.highlightingsState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForCompletionCache(params)) {
                this.completionCacheState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForDFAInputState(params)) {
                this.DFAInputState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForCLionClangTidyState(params)) {
                this.CLionClangTidyState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForClazyState(params)) {
                this.clazyState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForClangTidyState(params)) {
                this.clangTidyState.complete(ResultState.NOT_REQUESTED);
            }
            CompletableFuture.allOf(this.compilerDiagsState, this.highlightingsState, this.completionCacheState, this.DFAInputState, this.CLionClangTidyState, this.clazyState, this.clangTidyState).whenComplete((res, ex) -> parses.removePendingParse(this.uri, this.version));
        }

        @Nullable
        ActionType getWhomToBlame() {
            ActionType guilty = ActionType.PARSING;
            if (this.compilerDiagsState.isDone()) {
                guilty = ActionType.HIGHLIGHTINGS;
                if (this.highlightingsState.isDone()) {
                    guilty = ActionType.COMPLETION_CACHE;
                    if (this.completionCacheState.isDone()) {
                        guilty = ActionType.DFA_INPUT;
                        if (this.DFAInputState.isDone()) {
                            guilty = ActionType.CLION_CLANG_TIDY;
                            if (this.CLionClangTidyState.isDone()) {
                                guilty = ActionType.CLAZY;
                                if (this.clazyState.isDone()) {
                                    guilty = ActionType.CLANG_TIDY;
                                    if (this.clangTidyState.isDone()) {
                                        guilty = null;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return guilty;
        }

        @NlsSafe
        @NotNull
        String displayText() {
            return this.uri + ", compilerDiags=" + this.stateText(this.compilerDiagsState) + ", highlightings=" + this.stateText(this.highlightingsState) + ", DFAInput=" + this.stateText(this.DFAInputState) + ", CLion-clang-tidy=" + this.stateText(this.CLionClangTidyState) + ", Clazy=" + this.stateText(this.clazyState) + ", clang-tidy=" + this.stateText(this.clangTidyState);
        }

        @NlsSafe
        @NotNull
        String stateText(@NotNull CompletableFuture<ResultState> state) {
            if (!state.isDone()) {
                return "WAITING";
            }
            try {
                return state.get().name();
            }
            catch (Throwable throwable) {
                return "EXCEPTION?";
            }
        }

        private static boolean waitForCompilerDiags(@NotNull ClionReparseTextDocumentParams params) {
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics();
        }

        private static boolean waitForHighlightings(@NotNull ClionReparseTextDocumentParams params) {
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics();
        }

        private static boolean waitForCompletionCache(@NotNull ClionReparseTextDocumentParams params) {
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && (params.getGlobalCompletionCacheParams() == null || params.getGlobalCompletionCacheParams().getEnabled());
        }

        private static boolean waitForDFAInputState(@NotNull ClionReparseTextDocumentParams params) {
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getDFAOptions() != null;
        }

        private static boolean waitForClazyState(@NotNull ClionReparseTextDocumentParams params) {
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getClazyOptions() != null;
        }

        private static boolean waitForCLionClangTidyState(@NotNull ClionReparseTextDocumentParams params) {
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getClangTidyOptions() != null && params.getClangTidyOptions().getClionConfig() != null;
        }

        private static boolean waitForClangTidyState(@NotNull ClionReparseTextDocumentParams params) {
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getClangTidyOptions() != null && params.getClangTidyOptions().getConfig() != null;
        }

        static enum ResultState {
            ARRIVED,
            NOT_REQUESTED;

        }
    }

    private static class PendingRequest
    extends AbstractPending {
        @NotNull
        public final RequestType type;
        @Nullable
        public final String uri;

        PendingRequest(int cookie, @NotNull RequestType type, @Nullable String uri) {
            super(cookie);
            this.type = type;
            this.uri = uri;
        }

        @NotNull
        String displayText() {
            return this.uri + ", " + this.type.name();
        }

        @NonNls
        public String toString() {
            return "PendingRequest{type=" + this.type + ", uri='" + this.uri + "'}";
        }
    }

    private static enum RequestType {
        COMPLETION(true),
        INLAY_HINTS(true, ActionType.INLAY_HINTS),
        DEFINITION(false),
        DUMP_AST(false),
        DUMP_TOKENS(false),
        PARSE_COMMAND_LINE(false),
        CLANGFORMAT_CONFIG(false),
        REQUEST_TIMINGS(false),
        PREPROCESS(false),
        RANGE_FORMAT(true),
        ON_TYPE_FORMAT(false),
        DUMP_MEMORY_STAT(false),
        CHECK_CRASH(true),
        CLION_SYMBOL(false);

        final boolean myIsDangerous;
        @Nullable
        final ActionType myActionType;

        private RequestType(boolean isDangerous) {
            this.myIsDangerous = isDangerous;
            this.myActionType = null;
        }

        private RequestType(boolean isDangerous, ActionType actionType) {
            this.myIsDangerous = isDangerous;
            this.myActionType = actionType;
        }

        boolean isDangerous() {
            return this.myIsDangerous;
        }
    }

    static interface ActionDisabler {
        public boolean disable(@NotNull Project var1);

        public void enableBack(@NotNull Project var1);
    }

    private class ClangClientSpy
    extends ClangClientAdapter {
        ClangClientSpy(ClangClient delegate) {
            super(delegate);
        }

        @Override
        public void clionPublishDiagnostics(@NotNull ClionPublishDiagnosticsParams diagnostics) {
            PendingParse pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(diagnostics.getUri(), diagnostics.getVersion());
            if (pendingParse != null) {
                pendingParse.compilerDiagsState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishDiagnostics(diagnostics);
        }

        @Override
        public void clionPublishHighlightings(@NotNull ClionPublishHighlightingsParams highlightings) {
            PendingParse pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(highlightings.getUri(), highlightings.getVersion());
            if (pendingParse != null) {
                pendingParse.highlightingsState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishHighlightings(highlightings);
        }

        @Override
        public void clionPublishDFAInput(@NotNull ClionPublishDFAInputsParams input) {
            PendingParse pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(input.getUri(), input.getVersion());
            if (pendingParse != null) {
                pendingParse.DFAInputState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishDFAInput(input);
        }

        @Override
        public void clionPublishOurTidyDiagnostics(@NotNull ClionPublishTidyDiagnosticsParams diagnostics) {
            PendingParse pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(diagnostics.getUri(), diagnostics.getVersion());
            if (pendingParse != null) {
                pendingParse.CLionClangTidyState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishOurTidyDiagnostics(diagnostics);
        }

        @Override
        public void clionPublishTidyDiagnostics(@NotNull ClionPublishTidyDiagnosticsParams diagnostics) {
            PendingParse pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(diagnostics.getUri(), diagnostics.getVersion());
            if (pendingParse != null) {
                pendingParse.clangTidyState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishTidyDiagnostics(diagnostics);
        }

        @Override
        public void clionPublishClazyDiagnostics(@NotNull ClionPublishDiagnosticsParams diagnostics) {
            PendingParse pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(diagnostics.getUri(), diagnostics.getVersion());
            if (pendingParse != null) {
                pendingParse.clazyState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishClazyDiagnostics(diagnostics);
        }

        @Override
        public void clionCompletionCacheReady(@NotNull CLionCompletionCacheReadyParams params) {
            PendingParse pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(params.getUri(), params.getVersion());
            if (pendingParse != null) {
                pendingParse.completionCacheState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionCompletionCacheReady(params);
        }
    }

    private class ClangServerSpy
    extends ClangServerAdapter {
        @NotNull
        private final TextDocumentServiceSpy myTextDocumentService;

        ClangServerSpy(ClangServer delegate) {
            super(delegate);
            this.myTextDocumentService = new TextDocumentServiceSpy(delegate.getTextDocumentService());
        }

        @Override
        public void clionReparse(ClionReparseTextDocumentParams params) {
            ClangCrashHandler.this.myPendingInteractions.addPendingParse(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), params);
            super.clionReparse(params);
        }

        @Override
        public void clionCancelParse(ClionCancelParseParams params) {
            assert (params != null);
            String uri = params.getUri();
            int version = params.getVersion();
            ClangCrashHandler.this.myPendingInteractions.removePendingParse(uri, version);
            super.clionCancelParse(params);
        }

        @Override
        @NotNull
        public CompletableFuture<List<? extends SymbolInformation>> clionDefinition(@NotNull TextDocumentPositionParams position) {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionDefinition(position), new PendingDefinitionRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), position));
        }

        @Override
        @NotNull
        public CompletableFuture<List<ClangdInlayHint>> clangdInlayHints(@NotNull InlayHintsParams params) {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clangdInlayHints(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.INLAY_HINTS, params.getTextDocument().getUri()));
        }

        @Override
        @NotNull
        public CompletableFuture<String> clionDumpAST(@NotNull TextDocumentPositionParams position) {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionDumpAST(position), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.DUMP_AST, position.getTextDocument().getUri()));
        }

        @Override
        @NotNull
        public CompletableFuture<List<CLionSymbolInformation>> clionWorkspaceSymbol(@Nullable CLionWorkspaceSymbolParams params) {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionWorkspaceSymbol(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.CLION_SYMBOL, null));
        }

        @Override
        @NotNull
        public CompletableFuture<String> clionDumpTokens(@NotNull TextDocumentPositionParams position) {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionDumpTokens(position), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.DUMP_TOKENS, position.getTextDocument().getUri()));
        }

        @Override
        @NotNull
        public CompletableFuture<ClionMemoryUsageInfo> clionDebugDumpMemoryStat() {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionDebugDumpMemoryStat(), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.DUMP_MEMORY_STAT, null));
        }

        @Override
        @NotNull
        public CompletableFuture<ClionPublishDiagnosticsParams> clionCheckPreprocessedCase(@Nullable CLionCheckPreprocessedCaseParams params) {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionCheckPreprocessedCase(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.CHECK_CRASH, null));
        }

        @Override
        @NotNull
        public CompletableFuture<String> clionClangFormatConfiguration(TextDocumentPositionParams document) {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionClangFormatConfiguration(document), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.CLANGFORMAT_CONFIG, document.getTextDocument().getUri()));
        }

        @Override
        @NotNull
        public CompletableFuture<ClionFileStats> clionRequestTimingsStat(TextDocumentIdentifier document) {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionRequestTimingsStat(document), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.REQUEST_TIMINGS, document.getUri()));
        }

        @Override
        @NotNull
        public CompletableFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> clionCompletion(CompletionParams position) {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionCompletion(position), new PendingCompletionRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), position));
        }

        @Override
        @NotNull
        public CompletableFuture<List<? extends TextEdit>> clionRangeFormatting(@NotNull CLionDocumentRangeFormattingParams params) {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionRangeFormatting(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.RANGE_FORMAT, params.getTextDocument().getUri()));
        }

        @Override
        @NotNull
        public CompletableFuture<List<ClangCommandLineArgument>> clionParseCommandLine(ClangCommandLine commandLine) {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionParseCommandLine(commandLine), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.PARSE_COMMAND_LINE, null));
        }

        @Override
        @NotNull
        public CompletableFuture<CLionClangPreprocessResult> clionPreprocessFile(@NotNull ClionCompileCommandParams commandLine) {
            return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionPreprocessFile(commandLine), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.PREPROCESS, commandLine.getUri()));
        }

        @Override
        @NotNull
        public TextDocumentService getTextDocumentService() {
            return this.myTextDocumentService;
        }

        private final class TextDocumentServiceSpy
        extends TextDocumentServiceAdapter {
            private TextDocumentServiceSpy(TextDocumentService delegate) {
                super(delegate);
            }

            @Override
            public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
                return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.rangeFormatting(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.RANGE_FORMAT, params.getTextDocument().getUri()));
            }

            @Override
            public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
                return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.onTypeFormatting(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.ON_TYPE_FORMAT, params.getTextDocument().getUri()));
            }
        }
    }

    private static class AbstractPending {
        public final int cookie;

        private AbstractPending(int cookie) {
            this.cookie = cookie;
        }

        boolean before(@NotNull AbstractPending other) {
            return this.cookie < other.cookie;
        }
    }

    private static final class PendingDefinitionRequest
    extends PendingRequest {
        @NotNull
        private final TextDocumentPositionParams myDocPosition;

        private PendingDefinitionRequest(int cookie, @NotNull TextDocumentPositionParams docPosition) {
            super(cookie, RequestType.DEFINITION, docPosition.getTextDocument().getUri());
            this.myDocPosition = docPosition;
        }

        @Override
        @NotNull
        String displayText() {
            return this.uri + ":" + this.myDocPosition.getPosition().getLine() + ":" + this.myDocPosition.getPosition().getCharacter() + ", " + this.type.name();
        }
    }

    private static class PendingCompletionRequest
    extends PendingRequest {
        @NotNull
        private final CompletionParams myCompletionParams;

        PendingCompletionRequest(int cookie, @NotNull CompletionParams params) {
            super(cookie, RequestType.COMPLETION, params.getTextDocument().getUri());
            this.myCompletionParams = params;
        }

        @Override
        @NotNull
        String displayText() {
            return this.uri + ":" + this.myCompletionParams.getPosition().getLine() + ":" + this.myCompletionParams.getPosition().getCharacter() + ", " + this.type.name();
        }
    }
}

