/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.Compressor;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangPreprocessedReport;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdReportBugDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdReportBugAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile curFile;
        Project project = e.getProject();
        if (project != null && (curFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null) {
            ClangdReportBugDialog dialog = new ClangdReportBugDialog(project);
            dialog.show();
            try {
                if (dialog.isOK()) {
                    switch (dialog.getSelectedOption()) {
                        case AS_IS: {
                            ReportHandler reportHandler = dialog.getSendAsException() ? ClangdReportBugAction::reportExceptionZip : ClangdReportBugAction::reportSaveZip;
                            ClangdReportBugAction.prepareAsIsReport(project, curFile, reportHandler);
                            break;
                        }
                        case PREPROCESSED: {
                            ReportHandler reportHandler = dialog.getSendAsException() ? ClangdReportBugAction::reportException : ClangdReportBugAction::reportSaveZip;
                            ClangdReportBugAction.preparePreprocessedReport(project, curFile, false, reportHandler);
                            break;
                        }
                        case PREPROCESSED_AND_OBFUSCATED: {
                            ReportHandler reportHandler = dialog.getSendAsException() ? ClangdReportBugAction::reportException : ClangdReportBugAction::reportSaveZip;
                            ClangdReportBugAction.preparePreprocessedReport(project, curFile, true, reportHandler);
                        }
                    }
                }
            }
            catch (IOException ex) {
                ClangUtils.LOG.warn((Throwable)ex);
            }
        }
    }

    private static void preparePreprocessedReport(@NotNull Project project, @NotNull VirtualFile file, boolean obfuscate, @NotNull ReportHandler handler) throws IOException {
        ClangPreprocessedReport report = ClangdReportBugAction.doPreprocess(project, file);
        if (report != null && !report.getPreprocessedFiles().isEmpty()) {
            Obfuscator obfuscator = obfuscate ? ClangdBridge.getObfuscator() : null;
            ClangPreprocessedReport.PreprocessedFile ppFile = report.getPreprocessedFiles().get(0);
            HashMap<String, String> file2Content = new HashMap<String, String>();
            file2Content.put("CompilationInfo.txt", ppFile.getCompilationInfoAsString(obfuscator));
            String fileName = "preprocessed_" + PathUtilRt.getFileName((String)ppFile.getTargetPath(obfuscator));
            file2Content.put(fileName, ppFile.getContent(obfuscator));
            if (ppFile.lastDiagnostics != null) {
                file2Content.put("LastDiagnostics.txt", ppFile.lastDiagnostics);
            }
            handler.accept(project, file2Content);
        }
    }

    private static void prepareAsIsReport(@NotNull Project project, @NotNull VirtualFile file, @NotNull ReportHandler handler) throws IOException {
        ClangPreprocessedReport report = ClangdReportBugAction.doPreprocess(project, file);
        if (report != null && !report.getPreprocessedFiles().isEmpty()) {
            ClangPreprocessedReport.PreprocessedFile ppFile = report.getPreprocessedFiles().get(0);
            if (ppFile.content != null) {
                HashSet<String> paths = new HashSet<String>();
                Pattern regex = Pattern.compile("#\\s[0-9]+\\s\"([^\"]*?)\"");
                Matcher matcher = regex.matcher(ppFile.content);
                while (matcher.find()) {
                    String path = matcher.group(1);
                    if (StringUtil.isEmpty((String)path)) continue;
                    paths.add(path);
                }
                paths.remove("<command line>");
                paths.remove("<built-in>");
                HashMap<String, String> file2Content = new HashMap<String, String>();
                file2Content.put("CompilationInfo.txt", ppFile.getCompilationInfoAsString(null));
                if (ppFile.lastDiagnostics != null) {
                    file2Content.put("LastDiagnostics.txt", ppFile.lastDiagnostics);
                }
                file2Content.put("preprocessed_" + PathUtilRt.getFileName((String)ppFile.getTargetPath(null)), ppFile.getContent(null));
                ClangdReportBugAction.collectFiles(ppFile, paths, file2Content);
                handler.accept(project, file2Content);
            }
        }
    }

    @Nullable
    private static ClangPreprocessedReport doPreprocess(@NotNull Project project, @NotNull VirtualFile file) {
        ClangLanguageService service = ClangLanguageServiceProvider.getOrStart(project);
        return (ClangPreprocessedReport)CidrConcurrentUtilsKt.computeUnderProgress((String)ClangdBundle.message("clangd.report.bug.collecting.title", new Object[0]), (Project)project, () -> {
            try {
                return (ClangPreprocessedReport)CidrConcurrentUtilsKt.waitCancelAware(service.generatePreprocessedReport(Collections.singletonList(file.getUrl())), (String)"preprocessed report");
            }
            catch (ExecutionException ex) {
                ClangUtils.LOG.warn((Throwable)ex);
                return null;
            }
        });
    }

    @Nullable
    private static File getSavePath(@NotNull Project project) {
        String name = project.getName().replaceAll("[^a-zA-Z0-9\\-_]", "_");
        VirtualFileWrapper saved = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(ClangdBundle.message("clangd.report.bug.save.title", new Object[0]), ClangdBundle.message("clangd.report.bug.save.description", new Object[0]), new String[0]), project).save(name + "_report.zip");
        return saved != null ? saved.getFile() : null;
    }

    private static void collectFiles(@NotNull ClangPreprocessedReport.PreprocessedFile ppFile, @NotNull Collection<String> paths, @NotNull Map<String, String> file2Content) throws IOException {
        for (String path : paths) {
            if (ClangRequestsHelper.isMacroPath(path)) {
                file2Content.put(path, ppFile.macros);
                continue;
            }
            if (!FileUtil.exists((String)path)) continue;
            file2Content.put(path, FileUtilRt.loadFile((File)new File(path)));
        }
    }

    @NotNull
    private static String convertWindowsPath(@NotNull String path) {
        if (OSAgnosticPathUtil.startsWithWindowsDrive((String)path)) {
            return "/drive_" + path.charAt(0) + path.substring(2);
        }
        return path;
    }

    private static void reportSaveZip(@NotNull Project project, @NotNull Map<String, String> file2Content) throws IOException {
        byte[] zipArchive = ClangdReportBugAction.makeZipArchive(file2Content);
        File savePath = ClangdReportBugAction.getSavePath(project);
        if (savePath != null) {
            FileUtil.writeToFile((File)savePath, (byte[])zipArchive);
        }
    }

    private static void reportExceptionZip(@NotNull Project project, @NotNull Map<String, String> file2Content) throws IOException {
        byte[] zipArchive = ClangdReportBugAction.makeZipArchive(file2Content);
        ClangUtils.LOG.error("Collected sources are placed into ZIP archive. Please, attach it to the report", new Attachment[]{new Attachment("report.zip", zipArchive, "Collected sources in a .zip archive")});
    }

    private static byte[] makeZipArchive(@NotNull Map<String, String> file2Content) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (Compressor.Zip zip = new Compressor.Zip((OutputStream)baos);){
            for (Map.Entry<String, String> entry : file2Content.entrySet()) {
                zip.addFile(ClangdReportBugAction.convertWindowsPath(entry.getKey()), entry.getValue().getBytes(StandardCharsets.UTF_8));
            }
        }
        return baos.toByteArray();
    }

    private static void reportException(@NotNull Project project, @NotNull Map<String, String> file2Content) throws IOException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (Map.Entry<String, String> entry : file2Content.entrySet()) {
            attachments.add(new Attachment(entry.getKey(), entry.getValue()));
        }
        ClangUtils.LOG.error("Please, attach collected sources to the report", attachments.toArray(Attachment.EMPTY_ARRAY));
    }

    @FunctionalInterface
    private static interface ReportHandler {
        public void accept(@NotNull Project var1, @NotNull Map<String, String> var2) throws IOException;
    }
}

