/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import org.jetbrains.annotations.NotNull;

public class ClangdPreprocessAndObfuscateAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile curFile;
        if (e.getProject() != null && (curFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null) {
            String fileName = curFile.getName();
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(e.getProject());
            service.preprocess(curFile).thenAccept(ppOutput -> {
                if (ppOutput != null) {
                    try {
                        Obfuscator obfuscator = ClangdBridge.getObfuscator();
                        String obfuscated = obfuscator != null ? obfuscator.obfuscate((String)ppOutput) : "Obfuscator is not available. Is clangdBridge active?";
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!e.getProject().isDisposed()) {
                                ClangdPreprocessAndObfuscateAction.showOutputInEditor(e.getProject(), obfuscated, "Preprocessed and obfuscated " + fileName);
                            }
                        });
                    }
                    catch (Throwable thr) {
                        CidrLogService.LOG.error(thr);
                    }
                }
            });
        }
    }

    private static void showOutputInEditor(@NotNull Project project, @NotNull String text, @NotNull String caption) {
        if (project.isDisposed()) {
            return;
        }
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new LightVirtualFile(caption, (Language)PlainTextLanguage.INSTANCE, (CharSequence)text), true);
    }
}

