/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import org.jetbrains.annotations.NotNull;

public class ClangdPreprocessAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile curFile;
        if (e.getProject() != null && (curFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null) {
            String fileName = curFile.getName();
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(e.getProject());
            service.preprocess(curFile).thenAccept(ppOutput -> {
                if (ppOutput != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!e.getProject().isDisposed()) {
                            ClangdPreprocessAction.showOutputInEditor(e.getProject(), ppOutput, "Preprocessed " + fileName);
                        }
                    });
                }
            });
        }
    }

    private static void showOutputInEditor(@NotNull Project project, @NotNull String text, @NotNull String caption) {
        if (project.isDisposed()) {
            return;
        }
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new LightVirtualFile(caption, (Language)PlainTextLanguage.INSTANCE, (CharSequence)text), true);
    }
}

