/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdDumpIndexerCDB;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getProjectRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "renderCommandLine", "", "commandLine", "", "showOutputInEditor", "text", "caption", "JSONCommand", "intellij.c.clangd"})
public final class ClangdDumpIndexerCDB
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = ClangLanguageServiceProvider.getProvider(project2);
        if (object == null || (object = object.getIfStartedIndexer()) == null) {
            return;
        }
        Object indexer = object;
        ClangIdeFacade facade = indexer.getClangIdeFacade();
        ClangUrlConverter urlConv = indexer.getUrlConverter();
        Cpp20ModulesContext cpp20Context = Cpp20ModulesContext.create(indexer.getContext());
        ArrayList<JSONCommand> jsonCommands = new ArrayList<JSONCommand>();
        for (VirtualFile file : this.getProjectRoots(project2)) {
            ClangdCompilationCommand command;
            if (facade.getCompilationCommand(urlConv, project2, file, "clion.macros.file", cpp20Context) == null) continue;
            jsonCommands.add(new JSONCommand(command.ccParams.getDirectory(), this.renderCommandLine(command.ccParams.getCommandLine()), urlConv.fromUri(command.ccParams.getUri())));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String serialized = gson.toJson(jsonCommands);
        ApplicationManager.getApplication().invokeLater(() -> ClangdDumpIndexerCDB.actionPerformed$lambda$0(this, project2, serialized));
    }

    private final Set<VirtualFile> getProjectRoots(Project project) {
        Set sources = new HashSet();
        for (OCResolveConfiguration config : OCWorkspace.getInstance((Project)project).getConfigurations()) {
            sources.addAll(config.getSources());
        }
        return sources;
    }

    private final String renderCommandLine(List<String> commandLine) {
        return CollectionsKt.joinToString$default((Iterable)commandLine, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final void showOutputInEditor(Project project, String text, String caption) {
        if (project.isDisposed()) {
            return;
        }
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new LightVirtualFile(caption, (Language)PlainTextLanguage.INSTANCE, (CharSequence)text), true);
    }

    private static final void actionPerformed$lambda$0(ClangdDumpIndexerCDB this$0, Project $project, String $serialized) {
        this$0.showOutputInEditor($project, $serialized, "CDB for " + $project.getName());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdDumpIndexerCDB$JSONCommand;", "", "directory", "", "command", "file", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCommand", "()Ljava/lang/String;", "getDirectory", "getFile", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.c.clangd"})
    public static final class JSONCommand {
        @NotNull
        private final String directory;
        @NotNull
        private final String command;
        @NotNull
        private final String file;

        public JSONCommand(@NotNull String directory, @NotNull String command, @NotNull String file) {
            this.directory = directory;
            this.command = command;
            this.file = file;
        }

        @NotNull
        public final String getDirectory() {
            return this.directory;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @NotNull
        public final String getFile() {
            return this.file;
        }

        @NotNull
        public final String component1() {
            return this.directory;
        }

        @NotNull
        public final String component2() {
            return this.command;
        }

        @NotNull
        public final String component3() {
            return this.file;
        }

        @NotNull
        public final JSONCommand copy(@NotNull String directory, @NotNull String command, @NotNull String file) {
            return new JSONCommand(directory, command, file);
        }

        public static /* synthetic */ JSONCommand copy$default(JSONCommand jSONCommand, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = jSONCommand.directory;
            }
            if ((n & 2) != 0) {
                string2 = jSONCommand.command;
            }
            if ((n & 4) != 0) {
                string3 = jSONCommand.file;
            }
            return jSONCommand.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "JSONCommand(directory=" + this.directory + ", command=" + this.command + ", file=" + this.file + ")";
        }

        public int hashCode() {
            int result = this.directory.hashCode();
            result = result * 31 + this.command.hashCode();
            result = result * 31 + this.file.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JSONCommand)) {
                return false;
            }
            JSONCommand jSONCommand = (JSONCommand)other;
            if (!Intrinsics.areEqual((Object)this.directory, (Object)jSONCommand.directory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.command, (Object)jSONCommand.command)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)jSONCommand.file);
        }
    }
}

