/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageServiceProvider;
import java.io.IOException;
import java.nio.file.Path;

public class ClangdCachesInvalidator
extends CachesInvalidator {
    public void invalidateCaches() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            String clangdModulesPath = ClangdLanguageServiceProvider.getModulesPath(project);
            try {
                if (!FileUtil.exists((String)clangdModulesPath)) continue;
                FileUtil.delete((Path)Path.of(clangdModulesPath, new String[0]));
            }
            catch (IOException ex) {
                CidrLogService.LOG.warn((Throwable)ex);
            }
        }
    }
}

