/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangMessagesFilter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClangMessagesFilterImpl
implements ClangMessagesFilter,
ClangServerListener {
    @NotNull
    private final Pattern myNotificationPattern = Pattern.compile("\\{\\s*\"jsonrpc\": \"2\\.0\",\\s*\"method\": \"(?<method>.*?)\"");
    @NotNull
    private final Pattern myRequestPattern = Pattern.compile("\\{\\s*\"jsonrpc\": \"2\\.0\",\\s*\"id\": \"(?<id>[0-9]+)\",\\s*\"method\": \"(?<method>.*?)\"");
    @NotNull
    private final Pattern myReplyPattern = Pattern.compile("\\{\\s*\"jsonrpc\": \"2\\.0\",\\s*\"id\": \"(?<id>[0-9]+)\",\\s*\"(result|error)\":");
    @NotNull
    private volatile Filters myFilters;
    @NotNull
    private final Set<String> myRequests = Collections.synchronizedSet(new HashSet());

    public ClangMessagesFilterImpl(@NotNull ClangDaemonContext ctx) {
        this.myFilters = ClangMessagesFilterImpl.createFilters(ctx.getSettings().getClangdMessagesFilters());
        ctx.getMessageBus().connect().subscribe(ClangdSettingsListener.TOPIC, (Object)new ClangdSettingsListener(){

            @Override
            public void onClangdMessagesFiltersChanged(String value) {
                ClangMessagesFilterImpl.this.myFilters = ClangMessagesFilterImpl.createFilters(StringUtil.notNullize((String)value));
            }
        });
        ctx.getMessageBus().connect().subscribe(ClangServerListener.TOPIC, (Object)this);
    }

    @Override
    public boolean matchesBlockedError(@NotNull @NonNls String message) {
        Filters filters = this.myFilters;
        for (Pattern pattern : filters.errorPatterns) {
            if (!pattern.matcher(message).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesBlockedRequestOrReply(@NotNull @NonNls String message) {
        Filters filters = this.myFilters;
        if (filters.methods.isEmpty()) {
            return false;
        }
        Matcher requestMatcher = this.myRequestPattern.matcher(message);
        if (requestMatcher.find()) {
            String method = requestMatcher.group("method");
            String id = requestMatcher.group("id");
            if (filters.methods.contains(method)) {
                if (this.myRequests.size() > 4096) {
                    this.myRequests.clear();
                }
                this.myRequests.add(id);
                return true;
            }
        } else {
            Matcher replyMatcher = this.myReplyPattern.matcher(message);
            if (replyMatcher.find()) {
                String id = replyMatcher.group("id");
                return this.myRequests.remove(id);
            }
            Matcher notificationMatcher = this.myNotificationPattern.matcher(message);
            if (notificationMatcher.find()) {
                String method = notificationMatcher.group("method");
                return filters.methods.contains(method);
            }
        }
        return false;
    }

    @NotNull
    private static Filters createFilters(@NotNull String filters) {
        ArrayList<Pattern> compiledFilters = new ArrayList<Pattern>();
        HashSet<String> methods = new HashSet<String>();
        if (!StringUtil.isEmptyOrSpaces((String)filters)) {
            String[] lines;
            for (String line : lines = filters.split("\n")) {
                if (line.startsWith("clion-method:")) {
                    String method = line.substring("clion-method:".length()).trim();
                    if (method.isEmpty()) continue;
                    methods.add(method);
                    continue;
                }
                assert (!StringUtil.isEmptyOrSpaces((String)line));
                compiledFilters.add(Pattern.compile(line));
            }
        }
        return new Filters(compiledFilters, methods);
    }

    @Override
    public void onServerFailure() {
        this.myRequests.clear();
    }

    @Override
    public void onServerShutDown() {
        this.myRequests.clear();
    }

    private static final class Filters {
        @NotNull
        final @NotNull List<@NotNull Pattern> errorPatterns;
        @NotNull
        final @NotNull Set<@NotNull String> methods;

        private Filters(@NotNull @NotNull List<@NotNull Pattern> patterns, @NotNull @NotNull Set<@NotNull String> methods) {
            this.errorPatterns = patterns;
            this.methods = methods;
        }
    }
}

