/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionGlobalCompletionCacheParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangIdeFacadeImpl
implements ClangIdeFacade {
    @NotNull
    private final ExecutorService myMessagingService;

    public ClangIdeFacadeImpl(@NotNull @NonNls String descriptor) {
        this.myMessagingService = ConcurrencyUtil.newSingleThreadExecutor((String)("ClangdMessagingThread [" + descriptor + "]"));
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile(@NotNull @NonNls String url) {
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Override
    @Nullable
    public Document getDocument(@NotNull VirtualFile file) {
        return FileDocumentManager.getInstance().getDocument(file);
    }

    @Override
    @NotNull
    public List<OpenRequestId> getOpenRequests(@NotNull Project project, @NotNull VirtualFile file) {
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document != null) {
            return EditorFactory.getInstance().editors(document).filter(editor -> editor.getProject() == project).map(EditorOpenRequestId::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isModified(@NotNull VirtualFile file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager fileDocManager = FileDocumentManager.getInstance();
        return fileDocManager.isFileModified(file);
    }

    @Override
    @Nullable
    public ClangFileFacade getFileFacade(@NotNull VirtualFile file) {
        Document document = this.getDocument(file);
        if (document == null) {
            return null;
        }
        return this.getFileFacade(file, document);
    }

    @Override
    @NotNull
    public ClangFileFacade getFileFacade(@NotNull VirtualFile file, @NotNull Document document) {
        return new ClangFileFacadeImpl(document);
    }

    @Nullable
    protected ClangUtils.ResolveInfo getResolveInfoForFile(@NotNull Project project, @NotNull VirtualFile vf) {
        List configs = OCWorkspace.getInstance((Project)project).getConfigurationsForFile(vf);
        OCResolveConfiguration config = (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, (Collection)configs).first;
        OCLanguageKind kind = OCLanguageKindCalculatorBase.calculateMinimalKindByExtension((Project)project, (String)vf.getName());
        return config != null && kind != null ? new ClangUtils.ResolveInfo(config, vf, kind, false) : null;
    }

    @Override
    @Nullable
    public ClangdCompilationCommand getCompilationCommand(@NotNull ClangUrlConverter converter, @NotNull Project project, @NotNull VirtualFile file, @NotNull @NonNls String pathToMacrosFile, @NotNull Cpp20ModulesContext cpp20ModulesContext) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ClangUtils.ResolveInfo resolveInfo = this.getResolveInfoForFile(project, file);
        return ClangUtils.getCompilationCommand(converter, project, file, pathToMacrosFile, cpp20ModulesContext, resolveInfo);
    }

    @Override
    @Nullable
    public UnusedIncludesInspectionMode getUnusedIncludesInspectionMode(@NotNull Project project, @NotNull VirtualFile file) {
        return UnusedIncludesInspectionMode.RemoveNotDirectlyUsed;
    }

    @Override
    @Nullable
    public CLionClazyConfigParams getClazyConfig(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            ClangUtils.warnClangd(CidrLogService.LOG, "Failed to get OCPsiFile for file " + file.getPath());
            return null;
        }
        ClazyInspection inspection = CommonClangTidyUtil.getClazyInspection(psiFile, project);
        return inspection != null && CommonClangTidyUtil.isToolEnabled((LocalInspectionTool)inspection, psiFile, project) ? new CLionClazyConfigParams(inspection.getClazyChecks()) : null;
    }

    @Override
    public ClionClangDFAConfigParams getDFAOptions(@NotNull Project project, @NotNull VirtualFile file) {
        return null;
    }

    @Override
    @NotNull
    public ClionGlobalCompletionCacheParams getGlobalCompletionCacheParams(@NotNull Project project, @NotNull VirtualFile file) {
        return new ClionGlobalCompletionCacheParams(false);
    }

    @Override
    @Nullable
    public ClionClangTidyConfigParams getClangTidyConfig(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            ClangUtils.warnClangd(CidrLogService.LOG, "Failed to get OCPsiFile for file " + file.getPath());
            return null;
        }
        ClangTidyInspection inspection = CommonClangTidyUtil.getClangTidyInspection(psiFile, project);
        if (inspection == null) {
            ClangUtils.warnClangd(CidrLogService.LOG, "Failed to get 'preferClangTidyFilesOverIDESettings' option, default one will be used");
        }
        boolean preferClangTidyFiles = inspection != null && inspection.isPreferClangTidyFilesOverIDESettings();
        String clangTidyConfig = this.getClangTidyConfig(project, psiFile, false);
        String ourClangTidyConfig = this.getClangTidyConfig(project, psiFile, true);
        return StringUtil.isEmpty((String)clangTidyConfig) && StringUtil.isEmpty((String)ourClangTidyConfig) ? null : new ClionClangTidyConfigParams(ourClangTidyConfig, clangTidyConfig, preferClangTidyFiles);
    }

    @Nullable
    private String getClangTidyConfig(Project project, PsiFile file, Boolean takeOurClangTidyConfig) {
        List forcedOptions;
        String forcedConfig = takeOurClangTidyConfig != false ? (String)project.getUserData(CLION_CLANG_TIDY_CONFIG) : (String)project.getUserData(CLANG_TIDY_CONFIG);
        List list = forcedOptions = takeOurClangTidyConfig != false ? (List)project.getUserData(CLION_CLANG_TIDY_OPTIONS) : null;
        if (forcedConfig != null) {
            return CommonClangTidyUtil.getClangTidyConfig(forcedConfig, forcedOptions != null ? forcedOptions : ContainerUtil.emptyList());
        }
        if (!ClangUtils.isClangTidyViaClangdOn(project) || CommonClangTidyUtil.getCustomClangTidyPath() != null) {
            return null;
        }
        if (takeOurClangTidyConfig.booleanValue()) {
            List<OurClangTidyInspection> ourClangTidyInspections = CommonClangTidyUtil.getOurInspections(true, file, project);
            ArrayList checks = ContainerUtil.newArrayList((Object[])new String[]{"-*"});
            checks.addAll(ContainerUtil.map(ourClangTidyInspections, OurClangTidyInspection::getCheckName));
            ArrayList<ClangTidyCheckOption> checkOptions = new ArrayList<ClangTidyCheckOption>();
            for (OurClangTidyInspection inspection : ourClangTidyInspections) {
                checkOptions.addAll(inspection.getClangTidyCheckOptions());
            }
            MisraInspection misraInspection = CommonClangTidyUtil.getMisraInspection(file, project);
            if (misraInspection != null && CommonClangTidyUtil.isToolEnabled((LocalInspectionTool)misraInspection, file, project)) {
                checks.add(misraInspection.getAllMisraChecks());
            }
            return CommonClangTidyUtil.getClangTidyConfig(StringUtil.join((Collection)checks, (String)","), checkOptions);
        }
        ClangTidyInspection clangTidyInspection = CommonClangTidyUtil.getClangTidyInspection(file, project);
        if (clangTidyInspection != null) {
            if (!CommonClangTidyUtil.isToolEnabled((LocalInspectionTool)clangTidyInspection, file, project)) {
                return null;
            }
            String checks = CommonClangTidyUtil.concatClangTidyChecks(clangTidyInspection.getClangTidyChecks(), "-clion-*");
            return CommonClangTidyUtil.getClangTidyConfig(checks, clangTidyInspection.getClangTidyCheckOptions());
        }
        return CommonClangTidyUtil.getClangTidyConfig("-clion-*", ContainerUtil.emptyList());
    }

    @Override
    @Nullable
    public Long getPsiModificationCounter(@NotNull Project project) {
        PsiModificationTracker psiModificationTracker = PsiModificationTracker.getInstance((Project)project);
        return psiModificationTracker != null ? Long.valueOf(psiModificationTracker.getModificationCount()) : null;
    }

    @Override
    public void sendMessageLater(@NotNull Runnable runnable) {
        if (!this.myMessagingService.isShutdown()) {
            this.myMessagingService.execute(() -> {
                while (!this.myMessagingService.isShutdown()) {
                    if (ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)runnable)) {
                        return;
                    }
                    ProgressIndicatorUtils.yieldToPendingWriteActions();
                }
                return;
            });
        }
    }

    @Override
    public void stop() {
        this.myMessagingService.shutdown();
    }
}

