/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.LineColumn;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangFileFacadeImpl
implements ClangFileFacade {
    @NotNull
    private final Document myDocument;

    public ClangFileFacadeImpl(@NotNull Document document) {
        this.myDocument = document;
    }

    @Override
    @NotNull
    public CharSequence getText() {
        return this.myDocument.getImmutableCharSequence();
    }

    @Override
    @Nullable
    public LineColumn getLineColumn(int offset) {
        assert (offset >= 0) : "Why offset < 0?";
        if (offset > this.myDocument.getTextLength()) {
            return null;
        }
        int line = this.myDocument.getLineNumber(offset);
        int column = offset - this.myDocument.getLineStartOffset(line);
        return LineColumn.of((int)line, (int)column);
    }

    @Override
    public int getLineStartOffset(int lineNumber) {
        return this.myDocument.getLineStartOffset(lineNumber);
    }
}

