/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.messages.MessageBusOwner;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ProcessServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangMessagesFilter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangMessagesFilterImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProviderImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCrashHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessorProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessorProviderImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspaceImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspaceImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangDaemonContextImpl
implements ClangDaemonContext {
    private static final Logger LOG = Logger.getInstance((String)ClangDaemonContextImpl.class.getName());
    private final boolean myIsCustomClangdUsed;
    private final boolean myIsIndexer;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myDescriptor;
    @NotNull
    private final String myClangdModulesPath;
    @NotNull
    private final String myCpp20ModulesPath;
    @NotNull
    private final String myCpp20ModuleMapPath;
    @NotNull
    private final String myModuleMapPath;
    @NotNull
    private final ClangdSettings mySettings;
    @NotNull
    private final MessageBus myMessageBus;
    private final boolean myOwnMessageBus;
    @NotNull
    private final ClangLocalWorkspace myLocalWorkspace;
    @NotNull
    private final ClangRemoteWorkspace myRemoteWorkspace;
    @NotNull
    private final ClangIdeFacade myIdeFacade;
    @NotNull
    private final ServerConnectionProvider myServerConnectionProvider;
    @NotNull
    private final ClangClientServerProvider myClientServerProvider;
    @NotNull
    private final ClangServerAccessorProvider myServerAccessorProvider;
    @NotNull
    private final ClangCrashHandler myGuard;
    @NotNull
    private final ClangTelemetry myTelemetry;
    @NotNull
    private final ClangUrlConverter myUrlConverter;
    @NotNull
    private final Charset myProtocolCharset;
    @NotNull
    private final ClangMessagesFilter myMessagesFilter;
    private final int myKeepAsts;
    private volatile boolean areCpp20ModulesEnabled = false;
    private volatile boolean isStopped = false;

    private ClangDaemonContextImpl(boolean isIndexer, boolean isCustomClangd, @NotNull String descriptor, @NotNull Project project, @NotNull ClangdSettings settings, @NotNull ServerConnectionProvider serverConnectionProvider, @NotNull ClangClientServerProvider clientServerProvider, @NotNull ClangServerAccessorProvider serverAccessorProvider, @NotNull ClangUrlConverter converter, @NotNull ClangIdeFacade facade, @Nullable MessageBus messageBus, @NotNull String clangdModulesPath, @NotNull String cpp20ModulesPath, @NotNull String cpp20ModuleMapPath, @NotNull String moduleMapPath, int keepAsts) {
        this.myIsIndexer = isIndexer;
        this.myDescriptor = descriptor;
        this.myIsCustomClangdUsed = isCustomClangd;
        this.myProject = project;
        this.mySettings = settings;
        this.myServerConnectionProvider = serverConnectionProvider;
        this.myClientServerProvider = clientServerProvider;
        this.myServerAccessorProvider = serverAccessorProvider;
        this.myUrlConverter = converter;
        this.myIdeFacade = facade;
        this.myMessageBus = messageBus != null ? messageBus : ClangDaemonContextImpl.createDefaultMessageBus(this);
        this.myOwnMessageBus = messageBus == null;
        this.myClangdModulesPath = clangdModulesPath;
        this.myCpp20ModulesPath = cpp20ModulesPath;
        this.myCpp20ModuleMapPath = cpp20ModuleMapPath;
        this.myModuleMapPath = moduleMapPath;
        this.myKeepAsts = keepAsts;
        this.myLocalWorkspace = new ClangLocalWorkspaceImpl(converter);
        this.myRemoteWorkspace = new ClangRemoteWorkspaceImpl();
        this.myGuard = new ClangCrashHandler(this);
        this.myTelemetry = new ClangTelemetry(this);
        this.myProtocolCharset = StandardCharsets.UTF_8;
        this.myMessagesFilter = new ClangMessagesFilterImpl(this);
    }

    @Override
    public boolean isCpp20ModulesEnabled() {
        return this.areCpp20ModulesEnabled;
    }

    @Override
    public void setCpp20ModulesEnabled(boolean enabled) {
        this.areCpp20ModulesEnabled = enabled;
    }

    @Override
    public boolean isCustomClangdUsed() {
        return this.myIsCustomClangdUsed;
    }

    @Override
    @NotNull
    @NonNls
    public String getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public boolean isIndexer() {
        return this.myIsIndexer;
    }

    @Override
    @NotNull
    public String getClangdModulesPath() {
        return this.myClangdModulesPath;
    }

    @Override
    @NotNull
    public String getCpp20ModulesPath() {
        return this.myCpp20ModulesPath;
    }

    @Override
    @NotNull
    public String getCpp20ModuleMapPath() {
        return this.myCpp20ModuleMapPath;
    }

    @Override
    @NotNull
    public String getModuleMapPath() {
        return this.myModuleMapPath;
    }

    @Override
    @NotNull
    public ClangdSettings getSettings() {
        return this.mySettings;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        return this.myMessageBus;
    }

    @Override
    @NotNull
    public ClangLocalWorkspace getLocalWorkspace() {
        return this.myLocalWorkspace;
    }

    @Override
    @NotNull
    public ClangRemoteWorkspace getRemoteWorkspace() {
        return this.myRemoteWorkspace;
    }

    @Override
    @NotNull
    public ClangIdeFacade getIdeFacade() {
        return this.myIdeFacade;
    }

    @Override
    @NotNull
    public ServerConnectionProvider getConnectionProvider() {
        return this.myServerConnectionProvider;
    }

    @Override
    @NotNull
    public ClangClientServerProvider getClientServerProvider() {
        return this.myClientServerProvider;
    }

    @Override
    @NotNull
    public ClangServerAccessorProvider getServerAccessorProvider() {
        return this.myServerAccessorProvider;
    }

    @Override
    @NotNull
    public ClangCrashHandler getCrashHandler() {
        return this.myGuard;
    }

    @Override
    @NotNull
    public ClangTelemetry getTelemetry() {
        return this.myTelemetry;
    }

    @Override
    @NotNull
    public ClangUrlConverter getUrlConverter() {
        return this.myUrlConverter;
    }

    @Override
    @NotNull
    public Charset getProtocolCharset() {
        return this.myProtocolCharset;
    }

    @Override
    @NotNull
    public ClangMessagesFilter getMessagesFilter() {
        return this.myMessagesFilter;
    }

    @Override
    public int getKeepAsts() {
        return this.myKeepAsts;
    }

    @Override
    public boolean shouldStartServerImmediately() {
        return this.myProject.getUserData(START_SERVER_IMMEDIATELY) != null;
    }

    @Override
    public boolean isStopped() {
        return this.isStopped;
    }

    @Override
    public boolean canPublishMessage() {
        return !this.isStopped && !this.myMessageBus.isDisposed();
    }

    public void dispose() {
        this.isStopped = true;
        this.myIdeFacade.stop();
        if (this.myOwnMessageBus) {
            Disposer.dispose((Disposable)this.myMessageBus);
        }
    }

    @NotNull
    private static MessageBus createDefaultMessageBus(final @NotNull ClangDaemonContext context) {
        return MessageBusFactory.newMessageBus((MessageBusOwner)new MessageBusOwner(){

            @NotNull
            public Object createListener(@NotNull ListenerDescriptor descriptor) {
                throw new UnsupportedOperationException("Not supported.");
            }

            public boolean isDisposed() {
                return context.isStopped();
            }
        });
    }

    public static class Builder {
        @NotNull
        @NonNls
        private final String myDescriptor;
        @NotNull
        private final Project myProject;
        @Nullable
        private ClangdSettings mySettings;
        @Nullable
        private ClangIdeFacade myFacade;
        @Nullable
        private ClangUrlConverter myConverter;
        @Nullable
        private File myClangdPath;
        @Nullable
        private MessageBus myMessageBus;
        @Nullable
        private ClangServerAccessorProvider myServerAccessorProvider;
        private boolean myIsCustomClangdPath = false;
        private boolean myIsIndexer = false;
        @NotNull
        private String myClangdModulesPath = "";
        @NotNull
        private String myCpp20ModulesPath = "";
        @NotNull
        private String myCpp20ModuleMapPath = "";
        @NotNull
        private String myModuleMapPath = "";
        @Nullable
        private Integer myKeepAsts = null;

        public Builder(@NotNull @NonNls String descriptor, @NotNull Project project) {
            this.myDescriptor = descriptor;
            this.myProject = project;
            this.mySettings = ClangdSettings.getInstance(project);
        }

        @NotNull
        public Builder setSettings(@NotNull ClangdSettings settings) {
            this.mySettings = settings;
            return this;
        }

        @NotNull
        public Builder setIdeFacade(@NotNull ClangIdeFacade facade) {
            this.myFacade = facade;
            return this;
        }

        @NotNull
        public Builder setUrlConverter(@NotNull ClangUrlConverter converter) {
            this.myConverter = converter;
            return this;
        }

        @NotNull
        public Builder setClangdPath(@NotNull File clangdPath) {
            this.myClangdPath = clangdPath;
            this.myIsCustomClangdPath = true;
            return this;
        }

        @NotNull
        public Builder setMessageBus(@NotNull MessageBus messageBus) {
            this.myMessageBus = messageBus;
            return this;
        }

        @NotNull
        public Builder setIndexer(boolean indexer) {
            this.myIsIndexer = indexer;
            return this;
        }

        @NotNull
        public Builder setClangdModulesPath(@NotNull String clangdModulesPath) {
            this.myClangdModulesPath = clangdModulesPath;
            return this;
        }

        @NotNull
        public Builder setCpp20ModulesPath(@NotNull String cpp20ModulesPath) {
            this.myCpp20ModulesPath = cpp20ModulesPath;
            return this;
        }

        @NotNull
        public Builder setCpp20ModuleMapPath(@NotNull String cpp20ModuleMapPath) {
            this.myCpp20ModuleMapPath = cpp20ModuleMapPath;
            return this;
        }

        @NotNull
        public Builder setModuleMapPath(@NotNull String moduleMapPath) {
            this.myModuleMapPath = moduleMapPath;
            return this;
        }

        @NotNull
        public Builder setServerAccessorProvider(@NotNull ClangServerAccessorProvider provider2) {
            this.myServerAccessorProvider = provider2;
            return this;
        }

        @NotNull
        public Builder setKeepAsts(int keepAsts) {
            this.myKeepAsts = keepAsts;
            return this;
        }

        @NotNull
        public ClangDaemonContextImpl create() {
            File clangdPath = this.getClangdPath();
            LOG.info("Using clangd from: " + (Serializable)(this.getUrlConverter().isWslMode() ? "//wsl$/" + this.getUrlConverter().getWslMsId() + ClangUtils.getWslClangdDirPath() + "/clangd" : clangdPath));
            int keepAsts = this.myKeepAsts != null ? this.myKeepAsts : EditorWindow.getTabLimit();
            ProcessServerConnectionProvider connectionProvider = new ProcessServerConnectionProvider(this.myProject, clangdPath.getAbsolutePath(), this.myIsIndexer, keepAsts);
            ClangClientServerProviderImpl clientServerProvider = new ClangClientServerProviderImpl();
            return new ClangDaemonContextImpl(this.myIsIndexer, this.myIsCustomClangdPath, this.myDescriptor, this.myProject, this.getSettings(), connectionProvider, clientServerProvider, this.getServerAccessorProvider(), this.getUrlConverter(), this.getIdeFacade(), this.getMessageBus(), this.myClangdModulesPath, this.myCpp20ModulesPath, this.myCpp20ModuleMapPath, this.myModuleMapPath, keepAsts);
        }

        @NotNull
        private ClangIdeFacade getIdeFacade() {
            ClangIdeFacade facade = (ClangIdeFacade)this.myProject.getUserData(ClangDaemonContext.IDE_FACADE_KEY);
            if (facade != null) {
                return facade;
            }
            if (this.myFacade != null) {
                return this.myFacade;
            }
            return new ClangIdeFacadeImpl(this.myDescriptor);
        }

        @NotNull
        private ClangdSettings getSettings() {
            if (this.mySettings != null) {
                return this.mySettings;
            }
            return ClangdSettings.getInstance(this.myProject);
        }

        @NotNull
        private ClangUrlConverter getUrlConverter() {
            if (this.myConverter != null) {
                return this.myConverter;
            }
            ClangUrlConverter urlConverter = (ClangUrlConverter)this.myProject.getUserData(ClangDaemonContext.URL_CONVERTER_KEY);
            return urlConverter != null ? urlConverter : new ClangUrlConverter();
        }

        @NotNull
        public ClangServerAccessorProvider getServerAccessorProvider() {
            return this.myServerAccessorProvider != null ? this.myServerAccessorProvider : new ClangServerAccessorProviderImpl();
        }

        @NotNull
        private File getClangdPath() {
            if (this.myClangdPath != null) {
                return this.myClangdPath;
            }
            Pair<File, Boolean> pathAndIsCustom = ClangUtils.getClangdPath();
            this.myIsCustomClangdPath = (Boolean)pathAndIsCustom.second;
            return (File)pathAndIsCustom.first;
        }

        @Nullable
        private MessageBus getMessageBus() {
            return this.myMessageBus;
        }
    }
}

