/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.connector;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangDaemonNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessServerConnectionProvider
implements ServerConnectionProvider {
    private static final String CLANGD_LOG_PATH = System.getProperty("CLANGD_LOG_PATH");
    private static final Logger LOG = Logger.getInstance(ProcessServerConnectionProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myExePath;
    private final boolean myIsIndexer;
    private final int myKeepAsts;
    @Nullable
    private Error myLastError;

    public ProcessServerConnectionProvider(@NotNull Project project, @NotNull String exePath, boolean isIndexer, int keepAsts) {
        this.myProject = project;
        this.myExePath = exePath;
        this.myIsIndexer = isIndexer;
        this.myKeepAsts = keepAsts;
    }

    @Override
    @Nullable
    public ServerConnection create(@NotNull ClangDaemonContext context) {
        File clangdPath;
        GeneralCommandLine commandLine = this.buildCommandLine(context);
        if (!context.getUrlConverter().isWslMode() && !ProcessServerConnectionProvider.isAvailable(clangdPath = new File(commandLine.getExePath()))) {
            if (!clangdPath.exists()) {
                if (this.myLastError != Error.ClangdNotFound) {
                    Notifications.Bus.notify((Notification)new ClangDaemonNotification(ClangdBundle.message("clangd.executable.not.found", clangdPath)), (Project)this.myProject);
                    LOG.warn("clion-clangd is not found at " + clangdPath);
                }
                this.myLastError = Error.ClangdNotFound;
            } else {
                if (this.myLastError != Error.ClangdCannotBeExecuted) {
                    Notifications.Bus.notify((Notification)new ClangDaemonNotification(ClangdBundle.message("clangd.executable.cannot.execute", clangdPath)), (Project)this.myProject);
                    LOG.warn("clion-clangd cannot be executed at " + clangdPath);
                }
                this.myLastError = Error.ClangdCannotBeExecuted;
            }
            return null;
        }
        this.myLastError = null;
        try {
            ClangdProcessHandler processHandler = new ClangdProcessHandler(commandLine.createProcess(), commandLine.getPreparedCommandLine());
            CompletableFuture<Integer> stopFuture = new CompletableFuture<Integer>();
            processHandler.addProcessListener((ProcessListener)new ClangdProcessAdapter(stopFuture));
            processHandler.startNotify();
            return new ProcessServerConnection(processHandler, stopFuture);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    private GeneralCommandLine patchCommandLineForWsl(@NotNull ClangDaemonContext context, GeneralCommandLine commandLine) {
        ClangUtils.prepareClangBinariesInsideWSL(context.getUrlConverter().getWslMsId());
        @NotNull String wslMsId = context.getUrlConverter().getWslMsId();
        @NotNull WSLDistribution wslDistribution = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(wslMsId);
        commandLine = commandLine.withExePath(ClangUtils.getWslClangdDirPath() + "/clangd");
        try {
            commandLine = wslDistribution.patchCommandLine(commandLine, this.myProject, new WSLCommandLineOptions());
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
        return commandLine;
    }

    @NotNull
    private GeneralCommandLine buildCommandLine(@NotNull ClangDaemonContext context) {
        String traceFilePath;
        Object mirrorFilePath;
        GeneralCommandLine commandLine = new GeneralCommandLine().withExePath(this.myExePath);
        commandLine.addParameter("--clion-mode=" + (this.myIsIndexer ? "clion-indexer" : "clion-main"));
        commandLine.addParameter("-update-debounce=0");
        commandLine.addParameter("-index=false");
        if (Registry.is((String)"clion.clang.clangd.index.on") && !this.myIsIndexer) {
            commandLine.addParameter("-clion-static-index");
            if (Registry.is((String)"clion.clang.clangd.index.dynamic.on")) {
                commandLine.addParameter("-clion-dynamic-index");
            }
        }
        commandLine.addParameter("-include-ineligible-results");
        commandLine.addParameter("-clang-tidy=0");
        if (CLANGD_LOG_PATH != null) {
            commandLine.addParameter("-trace=" + CLANGD_LOG_PATH);
        }
        String resourceDir = new File(ClangUtils.getClangHeaderDir(context.getUrlConverter().isWslMode())).getParent();
        commandLine.addParameter("-resource-dir=" + FileUtil.normalize((String)resourceDir));
        commandLine.addParameter("-keep-asts=" + this.myKeepAsts);
        if (Registry.is((String)"clion.clang.clangd.thread.pool")) {
            commandLine.addParameter("-clion-enable-thread-pool");
        }
        if (Registry.is((String)"clion.clang.clangd.recovery.ast")) {
            commandLine.addParameter("-recovery-ast");
        }
        if ((mirrorFilePath = (String)this.myProject.getUserData(ClangDaemonContext.MIRROR_FILE_PATH)) != null) {
            if (this.myIsIndexer) {
                mirrorFilePath = (String)mirrorFilePath + ".indexer";
            }
            commandLine.addParameter("-input-mirror-file=" + (String)mirrorFilePath);
            commandLine.addParameter("-clion-delimited-mirror-file");
        }
        if ((traceFilePath = (String)this.myProject.getUserData(ClangDaemonContext.TRACE_FILE_PATH)) != null) {
            commandLine.withEnvironment("CLANGD_TRACE", traceFilePath);
        }
        if (ClangDebugLevel.isInfoOrMore()) {
            commandLine.addParameter("-log=verbose");
        }
        commandLine.addParameter("-ranking-model=heuristics");
        if (Registry.is((String)"clion.clang.clangd.completion.preamble")) {
            commandLine.addParameter("-clion-extra-completion-preamble");
        }
        commandLine.addParameter("-header-extensions=" + ClangUtils.getCurrentHeaderExtensions(this.myProject));
        String userArgs = Registry.stringValue((String)(this.myIsIndexer ? "clion.clang.clangd.indexer.cmd.line" : "clion.clang.clangd.cmd.line"));
        if (!userArgs.isEmpty()) {
            commandLine.addParameters(userArgs.split(" "));
        }
        if (System.getenv("LLVM_SYMBOLIZER_PATH") == null) {
            commandLine.withEnvironment("LLVM_SYMBOLIZER_PATH", ClangUtils.getBuiltinClangToolPath(SystemInfo.isWindows ? "llvm-symbolizer.exe" : "llvm-symbolizer").getPath());
        }
        if (context.getUrlConverter().isWslMode()) {
            commandLine = this.patchCommandLineForWsl(context, commandLine);
        }
        return commandLine;
    }

    private static boolean isAvailable(@Nullable File clangdPath) {
        try {
            return clangdPath != null && clangdPath.exists() && clangdPath.canExecute();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static enum Error {
        ClangdNotFound,
        ClangdCannotBeExecuted;

    }

    private static final class ClangdProcessHandler
    extends BaseProcessHandler<Process> {
        ClangdProcessHandler(@NotNull Process process, @NotNull String cmdLine) {
            super(process, cmdLine, StandardCharsets.UTF_8);
        }

        public void startNotify() {
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    try {
                        myWaitFor.setTerminationCallback(exitCode -> this.notifyProcessTerminated(exitCode));
                    }
                    finally {
                        this.removeProcessListener((ProcessListener)this);
                    }
                }
            });
            super.startNotify();
        }

        @NotNull
        public Future<?> executeOnPooledThread(@NotNull Runnable task) {
            return ProcessIOExecutorService.INSTANCE.submit(task);
        }

        @NotNull
        public Future<?> executeTask(@NotNull Runnable task) {
            return this.executeOnPooledThread(task);
        }

        protected void closeStreams() {
            super.closeStreams();
            try {
                this.myProcess.getErrorStream().close();
                this.myProcess.getOutputStream().close();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        @Nullable
        public InputStream getProcessOutput() {
            return this.myProcess.getInputStream();
        }

        @Nullable
        public InputStream getProcessErrors() {
            return this.myProcess.getErrorStream();
        }
    }

    private static final class ClangdProcessAdapter
    extends ProcessAdapter {
        @NotNull
        final CompletableFuture<Integer> myAssociatedStopFuture;

        ClangdProcessAdapter(@NotNull CompletableFuture<Integer> associatedStopFuture) {
            this.myAssociatedStopFuture = associatedStopFuture;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            this.myAssociatedStopFuture.complete(event.getExitCode());
        }
    }

    public static final class ProcessServerConnection
    implements ServerConnection {
        @NotNull
        private final ClangdProcessHandler myProcessHandler;
        @NotNull
        private final CompletableFuture<Integer> myStopFuture;

        ProcessServerConnection(@NotNull ClangdProcessHandler processHandler, @NotNull CompletableFuture<Integer> stopFuture) {
            this.myProcessHandler = processHandler;
            this.myStopFuture = stopFuture;
        }

        public Process getProcess() {
            return this.myProcessHandler.getProcess();
        }

        @Override
        public void stop() {
            if (this.isActive()) {
                this.myProcessHandler.destroyProcess();
            }
        }

        @Override
        public void kill() {
            Process process = this.getProcess();
            if (this.isActive()) {
                if (OSProcessHandler.processCanBeKilledByOS((Process)process)) {
                    OSProcessUtil.killProcess((Process)process);
                } else {
                    process.destroy();
                }
            }
        }

        @Override
        @NotNull
        public CompletableFuture<Integer> getStopFuture() {
            return this.myStopFuture;
        }

        @Override
        public boolean isActive() {
            return !this.myStopFuture.isDone();
        }

        @Override
        @Nullable
        public InputStream getInputStream() {
            return this.myProcessHandler.getProcessOutput();
        }

        @Override
        @Nullable
        public OutputStream getOutputStream() {
            return this.myProcessHandler.getProcessInput();
        }

        @Override
        @Nullable
        public InputStream getErrorStream() {
            return this.myProcessHandler.getProcessErrors();
        }
    }
}

