/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.OurClangTidyInspectionsViaClangdAnnotatorPass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OurClangTidyInspectionsViaClangdAnnotatorPassFactory
implements Disposable,
DirtyScopeTrackingHighlightingPassFactory {
    private static final Logger LOG = Logger.getInstance(OurClangTidyInspectionsViaClangdAnnotatorPassFactory.class);
    private final int myPassId;

    public OurClangTidyInspectionsViaClangdAnnotatorPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, int reparsingPassId) {
        if (reparsingPassId != -1) {
            this.myPassId = registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{reparsingPassId}, null, false, -1);
        } else {
            this.myPassId = -1;
            LOG.error("Failed to register OurClangTidyViaClangdAnnotator pass because reparsing pass is missing!");
        }
    }

    public int getPassId() {
        return this.myPassId;
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (!ClangdBridge.isSupported(file.getProject(), file.getVirtualFile())) {
            return null;
        }
        TextRange dirtyRange = FileStatusMap.getDirtyTextRange((Editor)editor, (int)this.myPassId);
        if (dirtyRange == null) {
            return null;
        }
        return new OurClangTidyInspectionsViaClangdAnnotatorPass(file, editor.getDocument());
    }

    public void dispose() {
    }
}

