/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DisableClangWarningIntentionAction
extends SuppressIntentionAction
implements Iconable {
    @NotNull
    private final String myWarning;

    public DisableClangWarningIntentionAction(@NotNull String warning) {
        this.myWarning = warning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        ClangdSettings settings;
        ClangdSettings clangdSettings = settings = ClangdSettings.getInstance(project);
        synchronized (clangdSettings) {
            settings.setClangFlags(this.modifyConfiguration(settings.getClangFlags()));
        }
        ClangdSettings.rehighlight();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings.isClangdShowErrors();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return ClangdBundle.message("language.cpp.clangd.disable.warning.intention", this.myWarning);
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }

    @NotNull
    private String modifyConfiguration(@NotNull String configuration) {
        List options = StringUtil.split((String)configuration, (String)",");
        options.replaceAll(String::trim);
        String warning = StringUtil.trimStart((String)this.myWarning, (String)"-W");
        options.removeIf(option -> option.equals("-W" + warning));
        if (!options.contains("-Wno-" + warning)) {
            options.add("-Wno-" + warning);
        }
        return StringUtil.join((Collection)options, (String)",");
    }
}

