/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdQuickFix
implements IntentionAction,
LocalQuickFix {
    @NotNull
    private final CodeAction myFixit;
    private final boolean myIsPreview;

    public ClangdQuickFix(@NotNull CodeAction fixit) {
        this(fixit, false);
    }

    public ClangdQuickFix(@NotNull CodeAction fixit, boolean isPreview) {
        this.myFixit = fixit;
        this.myIsPreview = isPreview;
    }

    private void invoke(PsiFile file, @NotNull Project project) {
        if (file == null) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        HashMap<Document, List> editsByDocument = new HashMap<Document, List>();
        for (Map.Entry change : this.myFixit.getEdit().getChanges().entrySet()) {
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl((String)change.getKey());
            if (virtualFile == null) continue;
            Document document = null;
            if (this.myIsPreview) {
                if (file.getOriginalFile().getVirtualFile().equals(virtualFile)) {
                    document = file.getViewProvider().getDocument();
                }
            } else {
                document = documentManager.getDocument(virtualFile);
            }
            if (document == null) continue;
            List edits = editsByDocument.computeIfAbsent(document, d -> new ArrayList());
            edits.addAll((Collection)change.getValue());
        }
        if (editsByDocument.isEmpty()) {
            return;
        }
        for (Map.Entry documentEdits : editsByDocument.entrySet()) {
            Document document = (Document)documentEdits.getKey();
            List edits = (List)documentEdits.getValue();
            edits.stream().sorted(ClangdQuickFix.getEditsComparator()).forEach(edit -> document.replaceString(ClangdQuickFix.getDocOffset(document, edit.getRange().getStart()), ClangdQuickFix.getDocOffset(document, edit.getRange().getEnd()), (CharSequence)edit.getNewText()));
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
    }

    @NotNull
    public String getText() {
        return this.getTextInternal();
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        if (IntentionPreviewUtils.prepareElementForWrite((PsiElement)file)) {
            this.commitDocuments(file, project);
            this.invoke(file, project);
        }
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiFile file = descriptor.getPsiElement().getContainingFile();
        this.invoke(file.getProject(), null, file);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        return new ClangdQuickFix(this.myFixit, true);
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        return ClangdBundle.message("language.cpp.clangd.quick.fix", new Object[0]);
    }

    @IntentionName
    private String getTextInternal() {
        return StringUtil.capitalize((String)this.myFixit.getTitle());
    }

    private void commitDocuments(@NotNull PsiFile file, @NotNull Project project) {
        List filesToChange = this.myFixit.getEdit().getChanges().keySet().stream().distinct().toList();
        if (filesToChange.size() > 1) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        } else {
            PsiDocumentManager.getInstance((Project)project).commitDocument(file.getViewProvider().getDocument());
        }
    }

    @NotNull
    private static Comparator<? super TextEdit> getEditsComparator() {
        return (o1, o2) -> {
            Position lhsStart = o1.getRange().getStart();
            Position rhsStart = o2.getRange().getStart();
            if (lhsStart.getLine() != rhsStart.getLine()) {
                return rhsStart.getLine() - lhsStart.getLine();
            }
            return rhsStart.getCharacter() - lhsStart.getCharacter();
        };
    }

    private static int getDocOffset(@NotNull Document doc, @NotNull Position pos) {
        return doc.getLineStartOffset(pos.getLine()) + pos.getCharacter();
    }
}

