/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.DisableClangWarningIntentionAction;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangWarningProblemGroup
implements SuppressableProblemGroup,
ClangProblemGroup {
    @NotNull
    private final String myDiagID;
    private final SuppressIntentionAction @NotNull [] mySuppressIntentionActions;

    @IntentionFamilyName
    public static String getClangProblemName() {
        return ClangdBundle.message("intention.family.name.clang.warnings", new Object[0]);
    }

    public ClangWarningProblemGroup(@NotNull PsiFile psiFile, @NotNull TextRange range, @NotNull String warningName) {
        HighlightDisplayKey.findOrRegister((String)ClangWarningProblemGroup.getClangProblemName(), (String)ClangWarningProblemGroup.getClangProblemName(), (String)ClangWarningProblemGroup.getClangProblemName());
        this.myDiagID = warningName;
        ArrayList<SuppressIntentionAction> allActions = new ArrayList<SuppressIntentionAction>();
        allActions.add(new DisableClangWarningIntentionAction(warningName));
        allActions.addAll(ClangdBridge.createSuppressActions(psiFile, range, warningName));
        this.mySuppressIntentionActions = allActions.toArray(SuppressIntentionAction.EMPTY_ARRAY);
    }

    public SuppressIntentionAction @NotNull [] getSuppressActions(@Nullable PsiElement element) {
        return this.mySuppressIntentionActions;
    }

    @Nullable
    public String getProblemName() {
        return ClangWarningProblemGroup.getClangProblemName();
    }

    @Override
    @Nullable
    public String getDiagnosticID() {
        return this.myDiagID;
    }
}

