/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.CLionClangInspectionBridgeProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAppliedDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlightKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangInfoProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangWarningProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangdQuickFix;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.lsp4j.CodeAction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangErrorsAnnotatorPass
extends TextEditorHighlightingPass
implements DumbAware {
    private static final int HINTS_LIMIT = 32;
    private static final int HINT_LENGTH_LIMIT = 240;
    private static final Logger LOG = Logger.getInstance((String)ClangErrorsAnnotatorPass.class.getName());
    private static final IdentityHashMap<HighlightSeverity, Boolean> SUPPRESSED = new IdentityHashMap();
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final TextRange myRestrictRange;
    @NotNull
    private final HighlightInfoHolder myHolder;
    private int myParseVersion = -1;

    public ClangErrorsAnnotatorPass(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Document document, @NotNull TextRange restrictRange) {
        super(file.getProject(), document);
        this.myFile = file;
        this.myEditor = editor;
        this.myRestrictRange = restrictRange;
        this.myHolder = new HighlightInfoHolder(file, new HighlightInfoFilter[0]);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        this.myHolder.clear();
        this.myParseVersion = -1;
        if (!ClangUtils.isClangdOn(this.myProject)) {
            return;
        }
        if (!ClangAnnotatorUtil.shouldAnnotate(this.myProject, this.myFile)) {
            return;
        }
        if (!ClangUtils.isClangdShowErrors(this.myProject)) {
            return;
        }
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        ClangAppliedDiagnostic.clearDiagnostics((UserDataHolder)this.myFile);
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(this.myProject);
        service.runWithParsed(virtualFile, response -> {
            if (response == null) {
                return;
            }
            this.myParseVersion = response.getVersion();
            ClangUtils.traceClangd(LOG, "Getting highlightings and diagnostics for " + virtualFile.getName() + "[" + this.myParseVersion + "].");
            CompletableFuture highlightingsFuture = response.getHighlightings();
            List highlightings = (List)ClangErrorsAnnotatorPass.waitForClangFuture(this.myProject, virtualFile, response.getVersion(), highlightingsFuture, "highlightings");
            if (highlightings != null) {
                this.makeHighlightings(service.getClangIdeFacade(), highlightings);
            }
            CompletableFuture diagnosticsFuture = response.getDiagnostics();
            List diagnostics = (List)ClangErrorsAnnotatorPass.waitForClangFuture(this.myProject, virtualFile, response.getVersion(), diagnosticsFuture, "diagnostics");
            if (diagnostics != null) {
                Trustworthiness trustworthiness = response.getTrustworthiness();
                this.makeAnnotations(service.getClangIdeFacade(), trustworthiness, diagnostics, service.getUrlConverter());
            }
        });
    }

    @Nullable
    private static <T> T waitForClangFuture(@NotNull Project project, @NotNull VirtualFile virtualFile, int curFileVersion, @NotNull Future<Supplier<T>> future, @NonNls @NotNull String waitingForWhat) {
        try {
            Supplier supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAware(future, (long)Long.MAX_VALUE, (String)waitingForWhat);
            if (supplier != null) {
                ClangUtils.warnClangd(LOG, waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] received.");
                return supplier.get();
            }
            ClangUtils.warnClangd(LOG, waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] are unavailable.");
        }
        catch (IndexOutOfBoundsException ex) {
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project);
            int version = service.getVersion(virtualFile);
            LOG.error("Got IOOBE when applying " + waitingForWhat + " for version " + curFileVersion + " while the latest version is [" + version + "]", (Throwable)ex);
        }
        catch (TimeoutException ex) {
            ClangUtils.warnClangd(LOG, "Waiting for " + waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] took too much time.");
        }
        catch (ProcessCanceledException ex) {
            ClangUtils.warnClangd(LOG, "Waiting for " + waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] is cancelled.");
            throw ex;
        }
        catch (ExecutionException ex) {
            ClangUtils.logServerException(LOG, ex.getMessage(), ex);
        }
        return null;
    }

    private void makeAnnotations(@NotNull ClangIdeFacade facade, @NotNull Trustworthiness trustworthiness, @Nullable List<ClangDiagnostic> diags, @NotNull ClangUrlConverter converter) {
        if (!ContainerUtil.isEmpty(diags)) {
            ClangErrorsAnnotatorPass.filterDiagnostics(this.myFile, trustworthiness, diags).stream().sorted((l, r) -> {
                int byLine = l.getStartLine() - r.getStartLine();
                return byLine != 0 ? byLine : l.getStartColumn() - r.getStartColumn();
            }).forEachOrdered(diag -> {
                HighlightInfo annotation = ClangErrorsAnnotatorPass.makeAnnotation(facade, diag, this.myFile, this.myEditor.getDocument(), this.myHolder, converter);
                if (annotation != null) {
                    ClangAppliedDiagnostic.putDiagnostic((UserDataHolder)this.myFile, annotation, diag);
                }
            });
        }
    }

    private void makeHighlightings(@NotNull ClangIdeFacade facade, @Nullable List<ClangHighlighting> highlightings) {
        if (!ContainerUtil.isEmpty(highlightings)) {
            ArrayList<ClangHighlighting> sortedHighlightings = new ArrayList<ClangHighlighting>(highlightings);
            sortedHighlightings.sort((l, r) -> {
                int byLine = l.getStartLine() - r.getStartLine();
                return byLine != 0 ? byLine : l.getStartColumn() - r.getStartColumn();
            });
            for (ClangHighlighting highlighting : sortedHighlightings) {
                this.makeHighlighting(highlighting, facade.getFileFacade(this.myFile.getVirtualFile(), this.myEditor.getDocument()), this.myHolder);
            }
        }
    }

    @Nullable
    public static HighlightInfo makeAnnotation(@NotNull ClangIdeFacade facade, @NotNull ClangDiagnostic diagnostic, @NotNull PsiFile file, @NotNull Document document, @NotNull HighlightInfoHolder holder, @NotNull ClangUrlConverter converter) {
        ClangFileFacade fileFacade = facade.getFileFacade(file.getViewProvider().getVirtualFile(), document);
        HighlightInfo specialAnnotation = ClangErrorsAnnotatorPass.makeSpecialAnnotation(facade, diagnostic, file, fileFacade, holder, converter);
        if (specialAnnotation != null) {
            return specialAnnotation;
        }
        return ClangErrorsAnnotatorPass.makeSimpleAnnotation(facade, diagnostic, file, fileFacade, holder, null, converter);
    }

    @Nullable
    private static HighlightInfo makeSpecialAnnotation(@NotNull ClangIdeFacade facade, @NotNull ClangDiagnostic diagnostic, @NotNull PsiFile file, @NotNull ClangFileFacade fileFacade, @NotNull HighlightInfoHolder holder, @NotNull ClangUrlConverter converter) {
        String code = diagnostic.getCode();
        if (ClangErrorsAnnotatorPass.isUnusedIncludeDirectiveDiagnostic(diagnostic)) {
            String inspectionName;
            Class<? extends OCInspectionBase> UIInspectionCls = ClangdBridge.getUnusedIncludesInspection();
            String string = inspectionName = UIInspectionCls != null ? OCInspectionUtil.getInspectionShortName(UIInspectionCls) : "UnusedIncludes";
            if (inspectionName == null) {
                return null;
            }
            assert (code != null) : "to fix the warning";
            CLionClangInspectionBridgeProblemGroup problemGroup = new CLionClangInspectionBridgeProblemGroup(inspectionName, code);
            return ClangErrorsAnnotatorPass.makeSimpleAnnotation(facade, diagnostic, file, fileFacade, holder, problemGroup, converter);
        }
        return null;
    }

    @Nullable
    private static HighlightInfo makeSimpleAnnotation(@NotNull ClangIdeFacade facade, @NotNull ClangDiagnostic diagnostic, @NotNull PsiFile file, @NotNull ClangFileFacade fileFacade, @NotNull HighlightInfoHolder holder, @Nullable ProblemGroup problemGroup, @NotNull ClangUrlConverter converter) {
        TextRange clangRange = ClangErrorsAnnotatorPass.createClangTextRange(diagnostic, fileFacade);
        if (clangRange == null) {
            return null;
        }
        String diagnosticMessage = diagnostic.getMessage();
        List<String> sufficesToRemove = Arrays.asList(" (fix available)", " (fixes available)");
        for (String s : sufficesToRemove) {
            if (!diagnosticMessage.endsWith(s)) continue;
            diagnosticMessage = diagnosticMessage.substring(0, diagnosticMessage.length() - s.length());
        }
        String tooltip = ClangErrorsAnnotatorPass.renderTooltip(facade, diagnosticMessage, diagnostic.getNotes(), file, fileFacade, converter);
        ArrayList<IntentionWrapper> fixes = new ArrayList<IntentionWrapper>(ContainerUtil.map(diagnostic.getClangdFixits(), f -> new ClangdQuickFix((CodeAction)f)));
        if (problemGroup == null) {
            if (diagnostic.getCode() != null && diagnostic.getCode().startsWith("-W")) {
                problemGroup = new ClangWarningProblemGroup(file, clangRange, diagnostic.getCode());
                if (diagnostic.getClangdFixits().isEmpty() && diagnostic.getClionFixits().isEmpty()) {
                    EmptyIntentionAction fixToRegister = new EmptyIntentionAction(ClangWarningProblemGroup.getClangProblemName());
                    fixes.add(new IntentionWrapper((IntentionAction)fixToRegister));
                }
            } else {
                problemGroup = new ClangErrorProblemGroup(diagnostic.getCode());
            }
        }
        HighlightInfoType highlightInfoType = ClangErrorsAnnotatorPass.getHighlightInfoType(diagnostic, file.getProject());
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(clangRange).description(diagnosticMessage).escapedToolTip(tooltip).problemGroup(problemGroup);
        if (ClangErrorsAnnotatorPass.isAnnotationAtEndOfLine((Segment)clangRange, fileFacade.getText())) {
            builder.endOfLine();
        }
        HighlightInfo clangAnnotation = builder.create();
        holder.add(clangAnnotation);
        if (clangAnnotation == null) {
            return null;
        }
        for (IntentionAction intentionAction : fixes) {
            clangAnnotation.registerFix(intentionAction, ClangErrorsAnnotatorPass.getSpecificSuppressOptions(problemGroup), null, clangRange, null);
        }
        return clangAnnotation;
    }

    private void makeHighlighting(@NotNull ClangHighlighting highlighting, @NotNull ClangFileFacade fileFacade, @NotNull HighlightInfoHolder holder) {
        block8: {
            TextRange clangRange = ClangErrorsAnnotatorPass.createClangTextRange(highlighting, fileFacade);
            if (clangRange == null) {
                return;
            }
            if (clangRange.getLength() > 0) {
                try {
                    EditorColorsScheme scheme;
                    Field field = OCHighlightingKeys.class.getDeclaredField(highlighting.getType());
                    Object textAttributesKey = field.get(OCHighlightingKeys.class);
                    if ((textAttributesKey == OCHighlightingKeys.PARAMETER || textAttributesKey == OCHighlightingKeys.LOCAL_VARIABLE) && RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)(scheme = EditorColorsManager.getInstance().getGlobalScheme()), (Language)this.myFile.getLanguage())) {
                        return;
                    }
                    if (!(textAttributesKey instanceof TextAttributesKey)) {
                        throw new IllegalArgumentException("Incorrect highlighting type " + highlighting.getType());
                    }
                    TextAttributesKey key = (TextAttributesKey)textAttributesKey;
                    HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).problemGroup((ProblemGroup)new ClangInfoProblemGroup()).range(clangRange).textAttributes(key).create();
                    holder.add(info);
                }
                catch (NoSuchFieldException e) {
                    assert (false) : "Unknown highlighting type: " + highlighting.getType();
                }
                catch (IllegalAccessException e) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError((Object)("Can't get highlighting type " + highlighting.getType()));
                }
            }
        }
    }

    public void doApplyInformationToEditor() {
        if (ClangUtils.isClangdOn(this.myProject) && ClangUtils.isClangdShowErrors(this.myProject) && this.myParseVersion >= 0) {
            VirtualFile virtualFile = this.myFile.getVirtualFile();
            ClangUtils.traceClangd(LOG, "Applying diags for " + virtualFile.getName() + "[" + this.myParseVersion + "].");
        }
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>();
        for (int i = 0; i < this.myHolder.size(); ++i) {
            HighlightInfo info = this.myHolder.get(i);
            highlights.add(info);
        }
        this.updateHighlights(highlights);
    }

    private void updateHighlights(@NotNull List<HighlightInfo> newHighlights) {
        HashMap<ClangHighlightKey, HighlightInfo> oldHighlightsMap = new HashMap<ClangHighlightKey, HighlightInfo>();
        DaemonCodeAnalyzerEx.processHighlights((Document)this.myDocument, (Project)this.myFile.getProject(), null, (int)0, (int)this.myFile.getTextLength(), highlightInfo -> {
            if (highlightInfo.getProblemGroup() instanceof ClangProblemGroup) {
                oldHighlightsMap.put(new ClangHighlightKey((HighlightInfo)highlightInfo), (HighlightInfo)highlightInfo);
            }
            return true;
        });
        List<HighlightInfo> mergedHighlights = this.mergeHighlights(newHighlights, oldHighlightsMap);
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), mergedHighlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    @NotNull
    private List<HighlightInfo> mergeHighlights(@NotNull List<HighlightInfo> newHighlights, @NotNull Map<ClangHighlightKey, HighlightInfo> oldHighlightsMap) {
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(newHighlights.size());
        for (HighlightInfo newHighlight : newHighlights) {
            if (this.myRestrictRange.containsOffset(newHighlight.getStartOffset()) && this.myRestrictRange.containsOffset(newHighlight.getEndOffset())) {
                result.add(newHighlight);
                continue;
            }
            HighlightInfo oldHighlight = oldHighlightsMap.get(new ClangHighlightKey(newHighlight));
            result.add(oldHighlight != null ? ClangErrorsAnnotatorPass.mergeHighlights(newHighlight, oldHighlight, this.myDocument, this.getColorsScheme()) : newHighlight);
        }
        return result;
    }

    @NotNull
    private static List<ClangDiagnostic> filterDiagnostics(@NotNull PsiFile file, @NotNull Trustworthiness trustworthiness, @NotNull List<ClangDiagnostic> diags) {
        return ContainerUtil.filter(diags, diag -> {
            HighlightSeverity severity = ClangErrorsAnnotatorPass.getHighlightSeverity(diag);
            if (SUPPRESSED.containsKey(severity)) {
                return false;
            }
            if (ClangErrorsAnnotatorPass.isIgnoredDiagnostic(diag)) {
                ClangErrorsAnnotatorPass.reportSuppressed(file, diag);
                return false;
            }
            if (severity == HighlightSeverity.ERROR && (trustworthiness.hasNoCompilationCommand() || trustworthiness.isCompilationCommandGuessed())) {
                ClangErrorsAnnotatorPass.reportSuppressed(file, diag);
                return false;
            }
            if (trustworthiness.hasNoTarget() && diag.getCode() != null) {
                switch (diag.getCode()) {
                    case "pragma_options_align_mac68k_target_unsupported": 
                    case "tls_var_aligned_over_maximum": 
                    case "seh_try_unsupported": 
                    case "asm_invalid_global_var_reg": 
                    case "asm_unknown_register_name": 
                    case "builtin_target_unsupported": 
                    case "type_unsupported": 
                    case "objc_method_unsupported_param_ret_type": 
                    case "attribute_unsupported": 
                    case "attribute_section_invalid_for_target": 
                    case "atomic_load_store_uses_lib": {
                        ClangErrorsAnnotatorPass.reportSuppressed(file, diag);
                        return false;
                    }
                }
            }
            if (ClangErrorsAnnotatorPass.isUnusedIncludeDirectiveDiagnostic(diag) && !OCInspectionUtil.isInspectionEnabled((Project)file.getProject(), ClangdBridge.getUnusedIncludesInspection())) {
                ClangErrorsAnnotatorPass.reportSuppressed(file, diag);
                return false;
            }
            return true;
        });
    }

    private static void reportSuppressed(@NotNull PsiFile file, @NotNull ClangDiagnostic diag) {
        String path = file.getVirtualFile() != null ? file.getVirtualFile().getPath() : "<no-file>";
        String message = "suppressed [" + diag.getCode() + "] " + path + ": " + diag.getMessage();
        if (ClangErrorsAnnotatorPass.isDriverDiagnostic(diag) || ClangErrorsAnnotatorPass.isTargetRelatedDiagnostic(diag)) {
            LOG.warn(message);
        } else {
            ClangUtils.warnClangd(LOG, message);
        }
    }

    private static boolean isAnnotationAtEndOfLine(@NotNull Segment annotation, @NotNull CharSequence text) {
        if (annotation.getStartOffset() != annotation.getEndOffset()) {
            return false;
        }
        if (text.length() <= annotation.getStartOffset()) {
            return true;
        }
        char firstChar = text.charAt(annotation.getStartOffset());
        return firstChar == '\n' || firstChar == '\r';
    }

    @Nullable
    private static TextRange createClangTextRange(@NotNull ClangDiagnostic diag, @NotNull ClangFileFacade helper) {
        CidrConcurrentUtilsKt.checkCanceled();
        try {
            int startLineOffset = helper.getLineStartOffset(diag.getStartLine());
            int endLineOffset = helper.getLineStartOffset(diag.getEndLine());
            return new TextRange(startLineOffset + diag.getStartColumn(), endLineOffset + diag.getEndColumn());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
            LOG.error((Throwable)ex);
            return null;
        }
    }

    @Nullable
    private static TextRange createClangTextRange(@NotNull ClangHighlighting diag, @NotNull ClangFileFacade helper) {
        CidrConcurrentUtilsKt.checkCanceled();
        try {
            int startLineOffset = helper.getLineStartOffset(diag.getStartLine());
            int endLineOffset = helper.getLineStartOffset(diag.getEndLine());
            return new TextRange(startLineOffset + diag.getStartColumn(), endLineOffset + diag.getEndColumn());
        }
        catch (IndexOutOfBoundsException ex) {
            LOG.error((Throwable)ex);
            return null;
        }
    }

    @NotNull
    private static HighlightSeverity getHighlightSeverity(@NotNull ClangDiagnostic diag) {
        HighlightSeverity severity = diag.getSeverity() == HighlightSeverity.ERROR ? HighlightSeverity.ERROR : (diag.getSeverity() == HighlightSeverity.WARNING ? HighlightSeverity.WARNING : (diag.getSeverity() == HighlightSeverity.INFORMATION ? HighlightSeverity.WEAK_WARNING : HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING));
        return severity;
    }

    @NotNull
    public static ProblemHighlightType clangdSeverity2ProblemHighlightType(@NotNull ClangDiagnostic diag) {
        ProblemHighlightType type = ClangErrorsAnnotatorPass.isUnusedIncludeDirectiveDiagnostic(diag) ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : (ClangErrorsAnnotatorPass.isUnusedDiagnostic(diag) ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : (ClangErrorsAnnotatorPass.isUnresolvedIdentifierDiagnostic(diag) ? ProblemHighlightType.LIKE_UNKNOWN_SYMBOL : (ClangErrorsAnnotatorPass.isDeprecationDiagnostic(diag) ? ProblemHighlightType.LIKE_DEPRECATED : (diag.getSeverity() == HighlightSeverity.ERROR ? ProblemHighlightType.GENERIC_ERROR : (diag.getSeverity() == HighlightSeverity.WARNING ? ProblemHighlightType.WARNING : (diag.getSeverity() == HighlightSeverity.INFORMATION || diag.getSeverity() == HighlightSeverity.WEAK_WARNING ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING))))));
        return type;
    }

    @NotNull
    private static HighlightInfoType getHighlightInfoType(@NotNull ClangDiagnostic diag, @NotNull Project project) {
        ProblemHighlightType type = ClangErrorsAnnotatorPass.clangdSeverity2ProblemHighlightType(diag);
        HighlightSeverity severity = ClangErrorsAnnotatorPass.getHighlightSeverity(diag);
        return ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)type, (HighlightSeverity)severity, (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)project));
    }

    private static boolean isUnresolvedIdentifierDiagnostic(@NotNull ClangDiagnostic diagnostic) {
        String name = diagnostic.getCode();
        if (name != null) {
            switch (name) {
                case "undeclared_var_use": 
                case "undeclared_var_use_suggest": 
                case "no_member": 
                case "unknown_typename": 
                case "unknown_typename_suggest": 
                case "-Wimplicit-function-declaration": {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isDeprecationDiagnostic(@NotNull ClangDiagnostic diagnostic) {
        String name = diagnostic.getCode();
        return name != null && name.equals("-Wdeprecated-declarations");
    }

    private static boolean isUnusedDiagnostic(@NotNull ClangDiagnostic diagnostic) {
        String name = diagnostic.getCode();
        return name != null && (name.startsWith("warn_unused_") || name.startsWith("-Wunused"));
    }

    private static boolean isUnusedIncludeDirectiveDiagnostic(@NotNull ClangDiagnostic diagnostic) {
        return StringUtil.equals((CharSequence)"clion_unused_include", (CharSequence)diagnostic.getCode());
    }

    public static boolean isIgnoredDiagnostic(@NotNull ClangDiagnostic diag) {
        return ClangErrorsAnnotatorPass.isDriverDiagnostic(diag) || ClangErrorsAnnotatorPass.isTargetRelatedDiagnostic(diag) || ClangErrorsAnnotatorPass.isUnknownWarningOptionDiagnostic(diag) || ClangUtils.isFromIncludedFile(diag);
    }

    private static boolean isDriverDiagnostic(@NotNull ClangDiagnostic diag) {
        return diag.getCode() != null && diag.getCode().startsWith("drv_");
    }

    private static boolean isTargetRelatedDiagnostic(@NotNull ClangDiagnostic diag) {
        String code = diag.getCode();
        if (code != null) {
            switch (code) {
                case "target_unknown_abi": 
                case "target_unknown_cpu": 
                case "target_unknown_fpmath": {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isUnknownWarningOptionDiagnostic(@NotNull ClangDiagnostic diag) {
        return Objects.equals(diag.getCode(), "-Wunknown-warning-option");
    }

    @NotNull
    @NlsSafe
    private static String renderTooltip(@NotNull ClangIdeFacade facade, @NlsSafe @NotNull String message, @Nullable List<String> notes, @NotNull PsiFile file, @NotNull ClangFileFacade fileFacade, @NotNull ClangUrlConverter converter) {
        HtmlBuilder tooltip = new HtmlBuilder();
        tooltip.append(message);
        if (notes != null) {
            int counter = 0;
            for (String note : notes) {
                tooltip.br();
                if (++counter >= 32) {
                    tooltip.append("...");
                    break;
                }
                ClangPreparedNote clangNote = ClangErrorsAnnotatorPass.parseAndPrepareNote(facade, note, file, fileFacade, converter);
                if (clangNote != null) {
                    tooltip.appendLink("#navigation/" + clangNote.path + ":" + clangNote.offset, StringUtil.shortenTextWithEllipsis((String)clangNote.message, (int)240, (int)0));
                    continue;
                }
                tooltip.append(note);
            }
        }
        return tooltip.wrapWithHtmlBody().toString();
    }

    @Nullable
    private static ClangPreparedNote parseAndPrepareNote(@NotNull ClangIdeFacade facade, @NotNull String note, @NotNull PsiFile file, @NotNull ClangFileFacade fileFacade, @NotNull ClangUrlConverter converter) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ClangLanguageServiceUtils.ClangNote parsedNote = ClangLanguageServiceUtils.parseNote(note, converter);
        if (parsedNote != null) {
            String path = parsedNote.path;
            if (path.contentEquals(file.getName())) {
                path = file.getVirtualFile().getPath();
            } else {
                if (path.contentEquals("<built-in>")) {
                    return null;
                }
                VirtualFile vf = CidrLangUtil.findBestFile((Project)file.getProject(), (String)parsedNote.path, (int)parsedNote.line, candidate -> ClangdBridge.isInProjectSourcesOrLibraries(file.getProject(), candidate));
                ClangFileFacade clangFileFacade = fileFacade = vf != null ? facade.getFileFacade(vf) : null;
            }
            if (fileFacade == null) {
                ClangUtils.warnClangd(LOG, "Failed to find a document for " + path);
                return null;
            }
            return new ClangPreparedNote(parsedNote.message, path, fileFacade.getLineStartOffset(Math.max(0, parsedNote.line - 1)) + Math.max(0, parsedNote.character - 1));
        }
        return null;
    }

    @NotNull
    public static HighlightInfo mergeHighlights(@NotNull HighlightInfo newHighlight, @NotNull HighlightInfo oldHighlight, @Nullable Document document, @Nullable EditorColorsScheme scheme) {
        TextAttributes textAttributes;
        ProblemGroup clangProblemGroup;
        if (newHighlight.getProblemGroup() instanceof ClangInfoProblemGroup) {
            return newHighlight;
        }
        HighlightInfo.Builder mergedBuilder = HighlightInfo.newHighlightInfo((HighlightInfoType)newHighlight.type).range(new TextRange(newHighlight.startOffset, newHighlight.endOffset)).description(newHighlight.getDescription()).severity(newHighlight.getSeverity());
        if (newHighlight.isAfterEndOfLine()) {
            mergedBuilder.endOfLine();
        }
        if (newHighlight.getToolTip() != null) {
            mergedBuilder.escapedToolTip(newHighlight.getToolTip());
        }
        if ((clangProblemGroup = newHighlight.getProblemGroup()) != null) {
            mergedBuilder.problemGroup(clangProblemGroup);
        }
        if (ClangErrorsAnnotatorPass.canApplyTextAttributes(textAttributes = oldHighlight.getTextAttributes(null, scheme), document, newHighlight.startOffset, newHighlight.endOffset)) {
            mergedBuilder.textAttributes(textAttributes);
        } else {
            textAttributes = newHighlight.getTextAttributes(null, scheme);
            if (ClangErrorsAnnotatorPass.canApplyTextAttributes(textAttributes, document, newHighlight.startOffset, newHighlight.endOffset)) {
                mergedBuilder.textAttributes(textAttributes);
            }
        }
        HighlightInfo mergedHighlight = mergedBuilder.createUnconditionally();
        TextRange newRange = new TextRange(newHighlight.getStartOffset(), newHighlight.getEndOffset());
        oldHighlight.findRegisteredQuickFix((descriptor, __) -> {
            String displayName = descriptor.getDisplayName();
            HighlightDisplayKey displayKey = displayName != null ? HighlightDisplayKey.find((String)displayName) : null;
            mergedHighlight.registerFix(descriptor.getAction(), ClangErrorsAnnotatorPass.getSpecificSuppressOptions(clangProblemGroup), displayName, newRange, displayKey);
            return null;
        });
        return mergedHighlight;
    }

    @Nullable
    private static List<IntentionAction> getSpecificSuppressOptions(@Nullable ProblemGroup problemGroup) {
        if (!(problemGroup instanceof ClangWarningProblemGroup)) {
            return null;
        }
        Object[] options = ((ClangWarningProblemGroup)problemGroup).getSuppressActions(null);
        return ContainerUtil.newArrayList((Object[])options, (int)0, (int)(options.length - 1));
    }

    private static boolean canApplyTextAttributes(@Nullable TextAttributes textAttributes, @Nullable Document document, int from, int to) {
        if (textAttributes == null) {
            return false;
        }
        if (document == null) {
            return true;
        }
        return ClangErrorsAnnotatorPass.hasVisibleUnderline(textAttributes) || ClangErrorsAnnotatorPass.hasVisibleCharacters(document, from, to);
    }

    private static boolean hasVisibleUnderline(@NotNull TextAttributes attributes) {
        return attributes.getErrorStripeColor() != null;
    }

    private static boolean hasVisibleCharacters(@NotNull Document document, int from, int to) {
        assert (from <= to) : "Why 'from' offset is greater than 'to' offset?";
        if (from == to) {
            return false;
        }
        CharSequence sequence = document.getImmutableCharSequence();
        for (int offset = from; offset < to; ++offset) {
            if (Character.isWhitespace(sequence.charAt(offset))) continue;
            return true;
        }
        return false;
    }

    static {
        SUPPRESSED.put(HighlightSeverity.INFORMATION, true);
        SUPPRESSED.put(HighlightSeverity.WEAK_WARNING, true);
    }

    private static final class ClangPreparedNote {
        @NlsSafe
        @NotNull
        final String message;
        @NlsSafe
        @NotNull
        final String path;
        final int offset;

        private ClangPreparedNote(@NlsSafe @NotNull String message, @NlsSafe @NotNull String path, int offset) {
            this.message = message;
            this.path = path;
            this.offset = offset;
        }
    }
}

