/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionGlobalCompletionCacheParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullCompilationInfo {
    @NotNull
    public final List<String> compilationCommand;
    @NotNull
    public String targetFile;
    @NotNull
    public String entryFile;
    @NotNull
    public String clangTidyConfig = "{\"Checks\":\"-*\",\"CheckOptions\":[]}";
    @NotNull
    public String ourClangTidyConfig = "{\"Checks\":\"-*\",\"CheckOptions\":[]}";
    @NotNull
    public String clazyConfig = "";
    public boolean usePredefines = false;
    @Nullable
    public ClionClangDFAConfigParams dfaOptions = new ClionClangDFAConfigParams(true);
    @NotNull
    public UnusedIncludesInspectionMode unusedMode = UnusedIncludesInspectionMode.RemoveNotDirectlyUsed;
    @NotNull
    public ClionGlobalCompletionCacheParams globalCompletionCacheParams = new ClionGlobalCompletionCacheParams(true);

    public FullCompilationInfo(@NotNull List<String> compilationCommand) {
        this(compilationCommand.get(compilationCommand.size() - 1), compilationCommand.get(compilationCommand.size() - 1), compilationCommand);
    }

    public FullCompilationInfo(@NotNull String targetFile, @NotNull List<String> compilationCommand) {
        this(targetFile, targetFile, compilationCommand);
    }

    public FullCompilationInfo(@NotNull String targetFile, @NotNull String entryFile, @NotNull List<String> compilationCommand) {
        this.targetFile = targetFile;
        this.compilationCommand = compilationCommand;
        this.entryFile = entryFile;
        assert (compilationCommand.get(compilationCommand.size() - 1).contentEquals(entryFile));
    }

    @NotNull
    public FullCompilationInfo withTargetFile(@NotNull String targetFile) {
        this.targetFile = targetFile;
        return this;
    }

    @NotNull
    public FullCompilationInfo withClangTidyConfig(@NotNull String config) {
        this.clangTidyConfig = config;
        return this;
    }

    @NotNull
    public FullCompilationInfo withOurClangTidyConfig(@NotNull String config) {
        this.ourClangTidyConfig = config;
        return this;
    }

    @NotNull
    public FullCompilationInfo withClazyConfig(@NotNull String config) {
        this.clazyConfig = config;
        return this;
    }

    @NotNull
    public FullCompilationInfo withDfaOptions(@Nullable ClionClangDFAConfigParams opts) {
        this.dfaOptions = opts;
        return this;
    }

    @NotNull
    public FullCompilationInfo withGlobalCompletionCache(@NotNull ClionGlobalCompletionCacheParams cache) {
        this.globalCompletionCacheParams = cache;
        return this;
    }

    @NotNull
    public static List<String> splitCommandLine(@NotNull String commandLine) {
        return Arrays.asList(commandLine.split(" "));
    }
}

