/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridgeInterface;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdBridge {
    public static final Key<Object> CLANG_CAN_OPEN_FILE = Key.create((String)"ClangCanOpenFileOnResolve");
    public static final Key<Object> CLANG_DONT_CLOSE_FILE = Key.create((String)"ClangDontCloseFileIfOpenedForResolve");

    public static boolean isClangdOnlyMode() {
        for (ClangdBridgeInterface bridge : ClangdBridgeInterface.EP_NAME.getExtensionList()) {
            if (bridge.isClangdOnlyMode()) continue;
            return false;
        }
        return true;
    }

    public static void registerAnnotatorPassFactories(@NotNull TextEditorHighlightingPassRegistrar registrar, int reparsingPassId, int clangErrorsPassId) {
        for (ClangdBridgeInterface bridge : ClangdBridgeInterface.EP_NAME.getExtensionList()) {
            bridge.registerAnnotatorPassFactories(registrar, reparsingPassId, clangErrorsPassId);
        }
    }

    @NotNull
    public static List<FileExtensionPair> getFileExtensions(@NotNull Project project) {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getFileExtensions(project);
        }
        return CommonClangTidyUtil.getDefaultFileExtensions();
    }

    public static boolean isSupported(@NotNull Project project, @Nullable VirtualFile vf) {
        if (vf == null) {
            return false;
        }
        List list = ClangdBridgeInterface.EP_NAME.getExtensionList();
        if (!list.isEmpty()) {
            for (ClangdBridgeInterface bridge : list) {
                if (bridge.isSupported(vf)) continue;
                return false;
            }
            return true;
        }
        if (!(vf instanceof VirtualFileWithId)) {
            return false;
        }
        String ext = vf.getExtension();
        if (ext != null) {
            for (FileExtensionPair extPair : ClangdBridge.getFileExtensions(project)) {
                if (!ext.equalsIgnoreCase(extPair.mySourceExt) && !ext.equalsIgnoreCase(extPair.myHeaderExt)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSourceFile(@NotNull Project project, @NotNull VirtualFile vf) {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.isSourceFile(vf);
        }
        String ext = vf.getExtension();
        if (ext != null) {
            for (FileExtensionPair extPair : ClangdBridge.getFileExtensions(project)) {
                if (!ext.equalsIgnoreCase(extPair.mySourceExt)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isHeaderFile(@NotNull Project project, @NotNull VirtualFile vf) {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.isHeaderFile(vf);
        }
        String ext = vf.getExtension();
        if (ext != null) {
            for (FileExtensionPair extPair : ClangdBridge.getFileExtensions(project)) {
                if (!ext.equalsIgnoreCase(extPair.myHeaderExt)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean getParameterHints(@NotNull Project project) {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getParameterHints(project);
        }
        return false;
    }

    public static void setParameterHints(@NotNull Project project, boolean enabled) {
        for (ClangdBridgeInterface bridge : ClangdBridgeInterface.EP_NAME.getExtensionList()) {
            bridge.setParameterHints(project, enabled);
        }
    }

    @Nullable
    public static Class<? extends OCInspectionBase> getClazyInspection() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getClazyInspection();
        }
        return null;
    }

    @Nullable
    public static Class<? extends OCInspectionBase> getUnusedIncludesInspection() {
        for (ClangdBridgeInterface bridge : ClangdBridgeInterface.EP_NAME.getExtensionList()) {
            Class<? extends OCInspectionBase> inspection = bridge.getUnusedIncludesInspection();
            if (inspection == null) continue;
            return inspection;
        }
        return null;
    }

    public static boolean isInProjectSourcesOrLibraries(@NotNull Project project, @NotNull VirtualFile vf) {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.isInProjectSourcesOrLibraries(project, vf);
        }
        return true;
    }

    @NotNull
    public static List<SuppressIntentionAction> createSuppressActions(@NotNull PsiFile psiFile, @NotNull TextRange range, @NotNull String warningName) {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.createSuppressActions(psiFile, range, warningName);
        }
        return Collections.emptyList();
    }

    @NotNull
    public static ClangIdeFacade createClangIdeFacade(@NotNull @NonNls String descriptor, boolean forIndexer) {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.createClangIdeFacade(descriptor, forIndexer);
        }
        return forIndexer ? new ClangIndexerIdeFacadeImpl(descriptor) : new ClangIdeFacadeImpl(descriptor);
    }

    @Nullable
    public static Obfuscator getObfuscator() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.createObfuscator();
        }
        return null;
    }
}

