/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.DummyLanguageService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClangLanguageServiceProvider
extends Disposable {
    @Nullable
    public static ClangLanguageServiceProvider getProvider(@NotNull Project project) {
        return (ClangLanguageServiceProvider)project.getService(ClangLanguageServiceProvider.class);
    }

    @NotNull
    public static ClangLanguageService getOrStart(@NotNull Project project) {
        return ClangLanguageServiceProvider.getOrStart(ClangLanguageServiceProvider.getProvider(project));
    }

    @NotNull
    public static ClangLanguageService getOrStart(@Nullable ClangLanguageServiceProvider provider2) {
        if (provider2 == null) {
            return DummyLanguageService.INSTANCE;
        }
        return provider2.getOrStart();
    }

    @NotNull
    public static ClangLanguageService getIfStarted(@NotNull Project project) {
        return ClangLanguageServiceProvider.getIfStarted(ClangLanguageServiceProvider.getProvider(project));
    }

    @NotNull
    public static ClangLanguageService getIfStarted(@Nullable ClangLanguageServiceProvider provider2) {
        if (provider2 == null) {
            return DummyLanguageService.INSTANCE;
        }
        ClangLanguageService service = provider2.getIfStarted();
        return service != null ? service : DummyLanguageService.INSTANCE;
    }

    @NotNull
    public ClangLanguageService getOrStart();

    @Nullable
    public ClangLanguageService getIfStarted();

    @NotNull
    public ClangStopData stop();

    @NotNull
    public ClangLanguageService getOrStartIndexer();

    @Nullable
    public ClangLanguageService getIfStartedIndexer();

    @NotNull
    public ClangStopData stopIndexer();
}

