/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.CidrLogService;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public enum ClangDebugLevel {
    OFF(0),
    WARN(1),
    INFO(2),
    TRACE(3);

    private final int priority;

    private ClangDebugLevel(int priority) {
        this.priority = priority;
    }

    @NotNull
    public static ClangDebugLevel getCurrentLevel() {
        try {
            return switch (Registry.get((String)"clion.clang.clangd.debug").asString()) {
                case "false", "0" -> OFF;
                case "true", "1" -> WARN;
                case "2" -> INFO;
                case "3" -> TRACE;
                default -> OFF;
            };
        }
        catch (Throwable ex) {
            CidrLogService.logOnce((Level)Level.WARNING, (String)("Either add \"clion.clang.clangd.debug\" registry key, or don't use " + ClangDebugLevel.class.getSimpleName()), (Throwable)ex);
            return OFF;
        }
    }

    public static boolean isOff() {
        return ClangDebugLevel.getCurrentLevel() == OFF;
    }

    public static boolean isWarnOrMore() {
        return ClangDebugLevel.getCurrentLevel().priority >= ClangDebugLevel.WARN.priority;
    }

    public static boolean isInfoOrMore() {
        return ClangDebugLevel.getCurrentLevel().priority >= ClangDebugLevel.INFO.priority;
    }

    public static boolean isTraceOrMore() {
        return ClangDebugLevel.getCurrentLevel().priority >= ClangDebugLevel.TRACE.priority;
    }

    public static void setLevel(@NotNull ClangDebugLevel level) {
        Registry.get((String)"clion.clang.clangd.debug").setValue(level.priority);
    }
}

