/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui.actions.generate;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateDomElementAction
extends CodeInsightAction {
    protected final GenerateDomElementProvider myProvider;

    public GenerateDomElementAction(@NotNull GenerateDomElementProvider generateProvider, @Nullable Icon icon) {
        this.getTemplatePresentation().setDescription(generateProvider.getDescription());
        this.getTemplatePresentation().setText(generateProvider.getText());
        this.getTemplatePresentation().setIcon(icon);
        this.myProvider = generateProvider;
    }

    public GenerateDomElementAction(GenerateDomElementProvider generateProvider) {
        this(generateProvider, null);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
                Runnable runnable = () -> {
                    Object element = GenerateDomElementAction.this.myProvider.generate(project, editor, file);
                    GenerateDomElementAction.this.myProvider.navigate((DomElement)element);
                };
                if (GenerateDomElementAction.this.startInWriteAction()) {
                    WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).run(() -> runnable.run());
                } else {
                    runnable.run();
                }
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
    }

    protected boolean startInWriteAction() {
        return true;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        DomElement element = DomUtil.getContextElement(editor);
        return element != null && this.myProvider.isAvailableForElement(element);
    }

    public GenerateDomElementProvider getProvider() {
        return this.myProvider;
    }
}

