/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.AbstractTableView;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomTableView
extends AbstractTableView<DomElement> {
    private final List<DataProvider> myCustomDataProviders = new SmartList();

    public DomTableView(Project project) {
        super(project);
    }

    public DomTableView(Project project, @Nls String emptyPaneText, String helpID) {
        super(project, emptyPaneText, helpID);
    }

    public void addCustomDataProvider(@NotNull DataProvider provider) {
        this.myCustomDataProviders.add(provider);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        for (DataProvider provider : this.myCustomDataProviders) {
            Object data = provider.getData(dataId);
            if (data == null) continue;
            return data;
        }
        return super.getData(dataId);
    }

    @Override
    protected void wrapValueSetting(@NotNull DomElement domElement, Runnable valueSetter) {
        if (domElement.isValid()) {
            WriteCommandAction.writeCommandAction((Project)this.getProject(), (PsiFile[])new PsiFile[]{DomUtil.getFile(domElement)}).run(() -> valueSetter.run());
            this.fireChanged();
        }
    }
}

