/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.model.DomModel;
import com.intellij.util.xml.model.MultipleDomModelFactory;
import com.intellij.util.xml.model.SimpleModelFactory;
import com.intellij.util.xml.model.impl.DomModelFactoryHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDomModelFactory<S extends UserDataHolder, T extends DomElement, M extends DomModel<T>, C extends PsiElement>
extends DomModelFactoryHelper<T>
implements SimpleModelFactory<T, M>,
MultipleDomModelFactory<S, T, M> {
    private final Project myProject;

    protected BaseDomModelFactory(@NotNull Class<T> aClass, Project project, @NonNls String name) {
        super(aClass, DomService.getInstance().createModelMerger());
        this.myProject = project;
    }

    @Nullable
    public M getModel(@NotNull C context) {
        PsiFile psiFile = context.getContainingFile();
        if (psiFile instanceof XmlFile) {
            return this.getModelByConfigFile((XmlFile)psiFile);
        }
        return null;
    }

    @Nullable
    protected M computeModel(@NotNull XmlFile psiFile, @Nullable S scope) {
        if (scope == null) {
            return null;
        }
        List<M> models = this.getAllModels(scope);
        for (DomModel model : models) {
            Set<XmlFile> configFiles = model.getConfigFiles();
            if (!configFiles.contains(psiFile)) continue;
            return (M)model;
        }
        return null;
    }

    @Override
    @Nullable
    public M getModelByConfigFile(@Nullable XmlFile file) {
        if (file == null) {
            return null;
        }
        XmlFile originalFile = (XmlFile)file.getOriginalFile();
        S scope = this.getModelScope(originalFile);
        return this.computeModel(originalFile, scope);
    }

    @Override
    @Nullable
    public DomFileElement<T> createMergedModelRoot(Set<? extends XmlFile> configFiles) {
        ArrayList configs = new ArrayList(configFiles.size());
        for (XmlFile xmlFile : configFiles) {
            ContainerUtil.addIfNotNull(configs, this.getDomRoot(xmlFile));
        }
        return configs.isEmpty() ? null : this.getModelMerger().mergeModels(DomFileElement.class, configs);
    }

    protected abstract S getModelScope(XmlFile var1);

    @Nullable
    protected abstract List<M> computeAllModels(@NotNull S var1);

    protected abstract M createCombinedModel(Set<XmlFile> var1, DomFileElement<T> var2, M var3, S var4);

    @Override
    @NotNull
    public List<M> getAllModels(@NotNull S s) {
        List<M> models = this.computeAllModels(s);
        return models == null ? Collections.emptyList() : models;
    }

    @Override
    public Set<XmlFile> getAllConfigFiles(@NotNull S scope) {
        HashSet<XmlFile> xmlFiles = new HashSet<XmlFile>();
        for (DomModel model : this.getAllModels(scope)) {
            xmlFiles.addAll(model.getConfigFiles());
        }
        return xmlFiles;
    }

    @Override
    @Nullable
    public M getCombinedModel(@Nullable S s) {
        if (s == null) {
            return null;
        }
        List<M> models = this.getAllModels(s);
        return (M)(switch (models.size()) {
            case 0 -> null;
            case 1 -> (DomModel)models.get(0);
            default -> {
                LinkedHashSet<XmlFile> configFiles = new LinkedHashSet<XmlFile>();
                LinkedHashSet list = new LinkedHashSet(models.size());
                for (DomModel model : models) {
                    Set<XmlFile> files = model.getConfigFiles();
                    for (XmlFile file : files) {
                        ContainerUtil.addIfNotNull(list, this.getDomRoot(file));
                    }
                    configFiles.addAll(files);
                }
                DomFileElement mergedModel = this.getModelMerger().mergeModels(DomFileElement.class, list);
                DomModel firstModel = (DomModel)models.get(0);
                yield this.createCombinedModel(configFiles, mergedModel, firstModel, s);
            }
        });
    }

    protected Project getProject() {
        return this.myProject;
    }
}

