/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlDomBundle;
import org.jetbrains.annotations.NotNull;

public class RemoveDomElementQuickFix
implements LocalQuickFix {
    private final boolean myIsTag;
    private final String myName;

    public RemoveDomElementQuickFix(@NotNull DomElement element) {
        this.myIsTag = element.getXmlElement() instanceof XmlTag;
        this.myName = element.getXmlElementName();
    }

    @NotNull
    public String getName() {
        return XmlDomBundle.message(this.myIsTag ? "dom.quickfix.remove.element.name" : "dom.quickfix.remove.attribute.name", this.myName);
    }

    @NotNull
    public String getFamilyName() {
        return XmlDomBundle.message("dom.quickfix.remove.element.family", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (this.myIsTag) {
            XmlTag tag = (XmlTag)descriptor.getPsiElement();
            XmlTag parentTag = tag.getParentTag();
            DomElement domElement = DomManager.getDomManager(project).getDomElement(tag);
            assert (domElement != null);
            domElement.undefine();
            if (parentTag != null && parentTag.isValid()) {
                parentTag.collapseIfEmpty();
            }
        } else {
            GenericAttributeValue<?> domElement = DomManager.getDomManager(project).getDomElement((XmlAttribute)descriptor.getPsiElement());
            assert (domElement != null);
            domElement.undefine();
        }
    }
}

