/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDomElementQuickFix<T extends DomElement>
implements LocalQuickFix {
    protected final T myElement;
    @IntentionName
    protected final String myName;

    public AddDomElementQuickFix(@NotNull T element) {
        this.myElement = element.createStableCopy();
        this.myName = this.computeName();
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @IntentionName
    private String computeName() {
        String name = this.myElement.getXmlElementName();
        return XmlDomBundle.message(this.isTag() ? "dom.quickfix.add.element.name" : "dom.quickfix.add.attribute.name", name);
    }

    private boolean isTag() {
        return this.myElement.getXmlElement() instanceof XmlTag;
    }

    @NotNull
    public String getFamilyName() {
        return XmlDomBundle.message("dom.quickfix.add.element.family", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        XmlElement element = this.myElement.ensureXmlElementExists();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            XmlElement navigationElement = this.isTag() ? element : ((XmlAttribute)element).getValueElement();
            PsiNavigateUtil.navigate((PsiElement)navigationElement);
        }
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        XmlElement parent = (XmlElement)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myElement.getParent().getXmlElement(), (PsiFile)target);
        DomElement element = DomUtil.getDomElement((PsiElement)parent);
        if (element == null) {
            return null;
        }
        AbstractDomChildrenDescription description = this.myElement.getChildDescription();
        if (description == null) {
            return null;
        }
        List<? extends DomElement> values = description.getStableValues(element);
        return values.isEmpty() ? null : new AddDomElementQuickFix<DomElement>(values.get(0));
    }
}

