/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.SmartFMap;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.JavaMethodSignature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class JavaMethod
implements AnnotatedElement {
    public static final JavaMethod[] EMPTY_ARRAY = new JavaMethod[0];
    private static final Object NONE = new Object();
    private final JavaMethodSignature mySignature;
    private final Class myDeclaringClass;
    private final Method myMethod;
    private volatile SmartFMap<Class, Object> myAnnotationsMap = SmartFMap.emptyMap();
    private volatile List<Method> myHierarchy;

    private JavaMethod(@NotNull Class<?> declaringClass, JavaMethodSignature signature) {
        this.mySignature = signature;
        this.myMethod = signature.findMethod(declaringClass);
        assert (this.myMethod != null) : "No method " + signature + " in class " + declaringClass;
        this.myDeclaringClass = this.myMethod.getDeclaringClass();
    }

    public Class<?> getDeclaringClass() {
        return this.myDeclaringClass;
    }

    public JavaMethodSignature getSignature() {
        return this.mySignature;
    }

    @NotNull
    public List<Method> getHierarchy() {
        List<Method> hierarchy = this.myHierarchy;
        if (hierarchy == null) {
            this.myHierarchy = hierarchy = Collections.unmodifiableList(this.mySignature.getAllMethods(this.myDeclaringClass));
        }
        return hierarchy;
    }

    public String getMethodName() {
        return this.mySignature.getMethodName();
    }

    public Method getMethod() {
        return this.myMethod;
    }

    public Type[] getGenericParameterTypes() {
        return this.myMethod.getGenericParameterTypes();
    }

    public Type getGenericReturnType() {
        return this.myMethod.getGenericReturnType();
    }

    public static JavaMethod getMethod(Class declaringClass, JavaMethodSignature signature) {
        return new JavaMethod(declaringClass, signature);
    }

    public static JavaMethod getMethod(Class declaringClass, Method method) {
        return JavaMethod.getMethod(declaringClass, new JavaMethodSignature(method));
    }

    public Object invoke(Object o, Object ... args) {
        return DomReflectionUtil.invokeMethod(this.myMethod, o, args);
    }

    public String toString() {
        return "JavaMethod: " + this.myMethod.toString();
    }

    @NonNls
    public String getName() {
        return this.myMethod.getName();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Object annotation = this.myAnnotationsMap.get(annotationClass);
        if (annotation == null) {
            annotation = this.findAnnotation(annotationClass);
            this.myAnnotationsMap = this.myAnnotationsMap.plus(annotationClass, annotation);
        }
        return (T)(annotation == NONE ? null : (Annotation)annotation);
    }

    @NotNull
    private Object findAnnotation(Class<? extends Annotation> annotationClass) {
        for (Method method : this.getHierarchy()) {
            Annotation annotation = method.getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return NONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaMethod)) {
            return false;
        }
        JavaMethod that = (JavaMethod)o;
        if (!this.myDeclaringClass.equals(that.myDeclaringClass)) {
            return false;
        }
        return this.mySignature.equals(that.mySignature);
    }

    public int hashCode() {
        int result = this.mySignature.hashCode();
        result = 31 * result + this.myDeclaringClass.hashCode();
        return result;
    }

    public Class getReturnType() {
        return this.myMethod.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return this.myMethod.getParameterTypes();
    }

    public int getParameterCount() {
        return this.myMethod.getParameterCount();
    }
}

