/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.JavaMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomReflectionUtil {
    private DomReflectionUtil() {
    }

    public static <T extends Annotation> T findAnnotationDFS(@NotNull Class<?> rawType, Class<T> annotationType) {
        T annotation = rawType.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        for (Class<?> aClass : rawType.getInterfaces()) {
            annotation = DomReflectionUtil.findAnnotationDFS(aClass, annotationType);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static boolean canHaveIsPropertyGetterPrefix(Type type) {
        return Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type) || Boolean.class.equals(DomUtil.getGenericValueParameter(type));
    }

    public static JavaMethod[] getGetterMethods(String[] path, Class<? extends DomElement> startClass) {
        JavaMethod[] methods = new JavaMethod[path.length];
        Class aClass = startClass;
        for (int i = 0; i < path.length; ++i) {
            JavaMethod getter = DomReflectionUtil.findGetter(aClass, path[i]);
            assert (getter != null) : "Couldn't find getter for property " + path[i] + " in class " + aClass;
            methods[i] = getter;
            aClass = getter.getReturnType();
            if (!List.class.isAssignableFrom(aClass)) continue;
            aClass = ReflectionUtil.getRawType((Type)Objects.requireNonNull(DomReflectionUtil.extractCollectionElementType(getter.getGenericReturnType())));
        }
        return methods;
    }

    @Nullable
    public static JavaMethod findGetter(Class<?> aClass, String propertyName) {
        String capitalized = StringUtil.capitalize((String)propertyName);
        Method method = ReflectionUtil.getMethod(aClass, (String)("get" + capitalized), (Class[])new Class[0]);
        if (method != null) {
            return JavaMethod.getMethod(aClass, method);
        }
        method = ReflectionUtil.getMethod(aClass, (String)("is" + capitalized), (Class[])new Class[0]);
        if (method == null) {
            return null;
        }
        JavaMethod javaMethod = JavaMethod.getMethod(aClass, method);
        return DomReflectionUtil.canHaveIsPropertyGetterPrefix(javaMethod.getGenericReturnType()) ? javaMethod : null;
    }

    public static Object invokeMethod(Method method, Object object, Object ... args) {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Calling method " + method + " on object " + object + " with arguments " + Arrays.asList(args), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)cause;
            }
            ExceptionUtil.rethrow((Throwable)cause);
            return null;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Nullable
    public static Type extractCollectionElementType(Type returnType) {
        if (!(returnType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)returnType;
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            return null;
        }
        Class rawClass = (Class)rawType;
        if (!List.class.equals((Object)rawClass) && !Collection.class.equals((Object)rawClass)) {
            return null;
        }
        Type[] arguments = ReflectionUtil.getActualTypeArguments((ParameterizedType)parameterizedType);
        if (arguments.length == 1) {
            Type argument = arguments[0];
            if (argument instanceof WildcardType) {
                Type[] upperBounds = ((WildcardType)argument).getUpperBounds();
                if (upperBounds.length == 1) {
                    return upperBounds[0];
                }
            } else if (argument instanceof ParameterizedType ? DomUtil.getGenericValueParameter(argument) != null : argument instanceof Class) {
                return argument;
            }
        }
        return null;
    }
}

